/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.toolsmiths.validation.architecture.internal.checkers;

import java.util.Collection;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.ECrossReferenceAdapter;
import org.eclipse.papyrus.infra.core.architecture.ADElement;
import org.eclipse.papyrus.infra.core.architecture.ArchitectureContext;
import org.eclipse.papyrus.infra.core.architecture.ArchitecturePackage;
import org.eclipse.papyrus.infra.core.architecture.RepresentationKind;
import org.eclipse.papyrus.infra.types.ElementTypeSetConfiguration;
import org.eclipse.papyrus.toolsmiths.validation.architecture.internal.messages.Messages;
import org.eclipse.papyrus.toolsmiths.validation.common.checkers.CustomModelChecker;
import org.eclipse.papyrus.toolsmiths.validation.common.internal.utils.ArchitectureIndex;
import org.eclipse.papyrus.toolsmiths.validation.common.internal.utils.ProjectManagementUtils;

public class ArchitectureCustomValidator
extends CustomModelChecker.SwitchValidator {
    private static final String ELEM_ELEMENT_TYPE_SET = "elementTypeSet";

    public ArchitectureCustomValidator(String nsURI) {
        super(nsURI);
    }

    public void validate(ADElement element, DiagnosticChain diagnostics, Map<Object, Object> context) {
        this.validateIcon((EObject)element, element.getIcon(), diagnostics, context);
    }

    public void validate(RepresentationKind representation, DiagnosticChain diagnostics, Map<Object, Object> context) {
        this.validateIcon((EObject)representation, representation.getGrayedIcon(), diagnostics, context);
        this.validateRepresentationKindUsed(representation, diagnostics, context);
    }

    private void validateIcon(EObject owner, String iconURI, DiagnosticChain diagnostics, Map<Object, Object> context) {
        ResourceSet rset;
        if (iconURI == null) {
            return;
        }
        URI uri = null;
        try {
            uri = URI.createURI((String)iconURI);
        }
        catch (Exception e) {
            diagnostics.add(this.createDiagnostic(4, owner, this.format(Messages.ArchitectureCustomValidator_0, context, new Object[]{owner, iconURI})));
        }
        if (uri != null && !(rset = owner.eResource().getResourceSet()).getURIConverter().exists(uri, null)) {
            diagnostics.add(this.createDiagnostic(4, owner, this.format(Messages.ArchitectureCustomValidator_1, context, new Object[]{owner, uri.lastSegment()})));
        }
    }

    public void validate(ArchitectureContext architecture, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (architecture.getId() != null) {
            architecture.getElementTypes().forEach(typeSet -> this.validateElementTypesContextID(architecture, (ElementTypeSetConfiguration)typeSet, diagnostics, context));
        }
    }

    private void validateElementTypesContextID(ArchitectureContext architecture, ElementTypeSetConfiguration typeSet, DiagnosticChain diagnostics, Map<Object, Object> context) {
        Collection registrations = ProjectManagementUtils.getExtensionElements((String)"org.eclipse.papyrus.infra.types.core.elementTypeSetConfiguration", (String)ELEM_ELEMENT_TYPE_SET, (String[])new String[0]).filter(ProjectManagementUtils.resourcePathIs((String)"path", (URI)typeSet.eResource().getURI())).collect(Collectors.toList());
        if (!registrations.isEmpty()) {
            if (registrations.stream().noneMatch(ProjectManagementUtils.hasAttribute((String)"clientContextID", architecture.getId()::equals))) {
                diagnostics.add(this.createDiagnostic(2, (EObject)architecture, this.format(Messages.ArchitectureCustomValidator_2, context, new Object[]{typeSet})));
            }
        }
    }

    private void validateRepresentationKindUsed(RepresentationKind representation, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.findArchitectureContextReference(representation)) {
            diagnostics.add(this.createDiagnostic(2, (EObject)representation, this.format("No viewpoint includes ''{0}'', so it is not accessible.", context, new Object[]{representation})));
        }
    }

    protected boolean findArchitectureContextReference(RepresentationKind representation) {
        boolean result;
        boolean bl = result = !this.requireCrossReferenceAdapter((EObject)representation).getInverseReferences((EObject)representation, ArchitecturePackage.Literals.ARCHITECTURE_VIEWPOINT__REPRESENTATION_KINDS, false).isEmpty();
        if (!result) {
            result = ArchitectureIndex.getInstance().isReferenced((EObject)representation, ArchitecturePackage.Literals.ARCHITECTURE_VIEWPOINT__REPRESENTATION_KINDS);
        }
        return result;
    }

    private ECrossReferenceAdapter requireCrossReferenceAdapter(EObject object) {
        ECrossReferenceAdapter result = ECrossReferenceAdapter.getCrossReferenceAdapter((Notifier)object);
        if (result == null) {
            ResourceSet rset;
            result = new ECrossReferenceAdapter();
            Resource resource = object.eResource();
            ResourceSet resourceSet = rset = resource != null ? resource.getResourceSet() : null;
            if (rset != null) {
                rset.eAdapters().add((Object)result);
            } else if (resource != null) {
                resource.eAdapters().add((Object)result);
            } else {
                object.eAdapters().add((Object)result);
            }
        }
        return result;
    }
}

