/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.toolsmiths.validation.architecture.internal.checkers;

import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.papyrus.infra.core.architecture.ArchitectureDomain;
import org.eclipse.papyrus.infra.core.architecture.ArchitecturePackage;
import org.eclipse.papyrus.toolsmiths.validation.architecture.Activator;
import org.eclipse.papyrus.toolsmiths.validation.architecture.internal.checkers.ArchitectureCustomValidator;
import org.eclipse.papyrus.toolsmiths.validation.architecture.internal.checkers.ArchitectureDependencies;
import org.eclipse.papyrus.toolsmiths.validation.architecture.internal.checkers.ArchitecturePluginXMLValidator;
import org.eclipse.papyrus.toolsmiths.validation.architecture.internal.checkers.ReferencedIconsBuildPropertiesDependencies;
import org.eclipse.papyrus.toolsmiths.validation.architecture.internal.messages.Messages;
import org.eclipse.papyrus.toolsmiths.validation.common.checkers.BuildPropertiesChecker;
import org.eclipse.papyrus.toolsmiths.validation.common.checkers.CustomModelChecker;
import org.eclipse.papyrus.toolsmiths.validation.common.checkers.ExtensionsChecker;
import org.eclipse.papyrus.toolsmiths.validation.common.checkers.IPluginChecker;
import org.eclipse.papyrus.toolsmiths.validation.common.checkers.IPluginChecker2;
import org.eclipse.papyrus.toolsmiths.validation.common.checkers.ModelDependenciesChecker;
import org.eclipse.papyrus.toolsmiths.validation.common.checkers.ModelValidationChecker;
import org.eclipse.papyrus.toolsmiths.validation.common.internal.utils.PluginErrorReporter;
import org.eclipse.papyrus.toolsmiths.validation.common.utils.MarkersService;
import org.eclipse.papyrus.toolsmiths.validation.common.utils.PluginValidationService;
import org.eclipse.papyrus.toolsmiths.validation.common.utils.ProjectManagementService;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class ArchitecturePluginChecker {
    public static final String ARCHITECTURE_EXTENSION = "architecture";
    private static final Set<String> ADDITIONAL_REQUIREMENTS = Set.of("org.eclipse.papyrus.infra.architecture");

    public static void checkArchitecturePlugin(IProject project) {
        Shell shell = Display.getCurrent().getActiveShell();
        try {
            new ProgressMonitorDialog(shell).run(true, true, monitor -> {
                Collection architectureFiles = ProjectManagementService.getFilesFromProject((IContainer)project, (String)ARCHITECTURE_EXTENSION, (boolean)true);
                monitor.beginTask(Messages.ArchitecturePluginChecker_0, 1 + architectureFiles.size() * 3);
                monitor.subTask(Messages.ArchitecturePluginChecker_1);
                MarkersService.deleteMarkers((IResource)project, (String)"org.eclipse.papyrus.toolsmiths.validation.architecture.diagnostic");
                PluginValidationService pluginValidationService = new PluginValidationService();
                pluginValidationService.addPluginChecker((IPluginChecker)ArchitecturePluginChecker.createModelDependenciesChecker(project));
                for (IFile architectureFile : architectureFiles) {
                    URI architectureFileURI = URI.createPlatformResourceURI((String)architectureFile.getFullPath().toOSString(), (boolean)true);
                    Resource resource = new ResourceSetImpl().getResource(architectureFileURI, true);
                    pluginValidationService.addPluginChecker((IPluginChecker)ArchitecturePluginChecker.createModelValidationChecker(project, architectureFile, resource));
                    pluginValidationService.addPluginChecker(ArchitecturePluginChecker.createExtensionsChecker(project, architectureFile, resource));
                    pluginValidationService.addPluginChecker((IPluginChecker)ArchitecturePluginChecker.createModelDependenciesChecker(project, architectureFile, resource));
                    pluginValidationService.addPluginChecker((IPluginChecker)ArchitecturePluginChecker.createBuildPropertiesChecker(project, architectureFile, resource));
                }
                monitor.worked(1);
                pluginValidationService.validate(monitor);
            });
        }
        catch (InvocationTargetException e) {
            Activator.log.error((Throwable)e);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static IPluginChecker2.Factory modelValidationCheckerFactory() {
        return IPluginChecker2.Factory.forEMFResource(ArchitecturePluginChecker::createModelValidationChecker);
    }

    private static ModelValidationChecker createModelValidationChecker(IProject project, IFile modelFile, Resource resource) {
        return new ModelValidationChecker(modelFile, resource, "org.eclipse.papyrus.toolsmiths.validation.architecture.diagnostic");
    }

    public static IPluginChecker2.Factory buildPropertiesCheckerFactory() {
        return IPluginChecker2.Factory.forEMFResource(ArchitecturePluginChecker::createBuildPropertiesChecker);
    }

    private static BuildPropertiesChecker createBuildPropertiesChecker(IProject project, IFile modelFile, Resource resource) {
        return new BuildPropertiesChecker(project, modelFile, resource, "org.eclipse.papyrus.toolsmiths.validation.architecture.diagnostic").withDependencies(file -> new ReferencedIconsBuildPropertiesDependencies(resource).getDependencies());
    }

    public static IPluginChecker2.Factory modelDependenciesCheckerFactory() {
        return IPluginChecker2.Factory.forProject(ArchitecturePluginChecker::createModelDependenciesChecker).or(IPluginChecker2.Factory.forEMFResource(ArchitecturePluginChecker::createModelDependenciesChecker));
    }

    private static ModelDependenciesChecker createModelDependenciesChecker(IProject project) {
        return new ModelDependenciesChecker(project, null, null, "org.eclipse.papyrus.toolsmiths.validation.architecture.diagnostic").addRequirements(ADDITIONAL_REQUIREMENTS).withSeverityFunction(bundle -> ADDITIONAL_REQUIREMENTS.contains(bundle) ? 2 : 4);
    }

    private static ModelDependenciesChecker createModelDependenciesChecker(IProject project, IFile modelFile, Resource resource) {
        return new ModelDependenciesChecker(project, modelFile, resource, "org.eclipse.papyrus.toolsmiths.validation.architecture.diagnostic").withAdditionalRequirements(new ArchitectureDependencies(project)::computeDependencies);
    }

    public static IPluginChecker2.Factory extensionsCheckerFactory() {
        return IPluginChecker2.Factory.forEMFResource(ArchitecturePluginChecker::createExtensionsChecker);
    }

    private static ExtensionsChecker<ArchitectureDomain, PluginErrorReporter<ArchitectureDomain>> createExtensionsChecker(IProject project, IFile modelFile, Resource resource) {
        Collection domains = EcoreUtil.getObjectsByType((Collection)resource.getContents(), (EClassifier)ArchitecturePackage.Literals.ARCHITECTURE_DOMAIN);
        return new ExtensionsChecker(project, modelFile, domains, "org.eclipse.papyrus.toolsmiths.validation.architecture.diagnostic", ArchitecturePluginChecker::createPluginErrorReporter);
    }

    private static PluginErrorReporter<ArchitectureDomain> createPluginErrorReporter(IFile pluginXML, IFile modelFile, ArchitectureDomain model) {
        ArchitecturePluginXMLValidator validator = new ArchitecturePluginXMLValidator(modelFile);
        return new PluginErrorReporter(pluginXML, modelFile, (EObject)model, "org.eclipse.papyrus.toolsmiths.validation.architecture.diagnostic", domain -> domain.getId()).requireExtensionPoint("org.eclipse.papyrus.infra.architecture.models", validator::matchExtension, null, validator::problemID);
    }

    public static IPluginChecker2.Factory customModelCheckerFactory() {
        return IPluginChecker2.Factory.forEMFResource(ArchitecturePluginChecker::createCustomModelChecker);
    }

    private static CustomModelChecker createCustomModelChecker(IProject project, IFile modelFile, Resource resource) {
        return new CustomModelChecker(modelFile, resource, "org.eclipse.papyrus.toolsmiths.validation.architecture.diagnostic").withValidator("http://www.eclipse.org/papyrus/infra/core/architecture", ArchitectureCustomValidator::new).withValidator("http://www.eclipse.org/papyrus/infra/gmfdiag/representation", ArchitectureCustomValidator::new);
    }
}

