/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.toolsmiths.validation.architecture.internal.checkers;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.Switch;
import org.eclipse.papyrus.infra.core.architecture.ADElement;
import org.eclipse.papyrus.infra.core.architecture.RepresentationKind;
import org.eclipse.papyrus.infra.core.architecture.util.ArchitectureSwitch;

class ReferencedIconsBuildPropertiesDependencies {
    private final Resource resource;

    ReferencedIconsBuildPropertiesDependencies(Resource resource) {
        this.resource = resource;
    }

    Collection<IResource> getDependencies() {
        HashSet<IResource> result = new HashSet<IResource>();
        Set<URI> iconURIs = this.collectIcons((List<EObject>)this.resource.getContents());
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        for (URI next : iconURIs) {
            String projectName;
            IProject project;
            if (!next.isPlatformPlugin() && !next.isPlatformResource() || (project = root.getProject(projectName = next.segment(1))) == null || !project.isAccessible()) continue;
            IFile icon = root.getFile((IPath)new Path(next.toPlatformString(false)));
            result.add((IResource)icon);
        }
        return result;
    }

    private Set<URI> collectIcons(List<EObject> objects) {
        final HashSet<URI> result = new HashSet<URI>();
        ArchitectureSwitch<Set<URI>> iconsSwitch = new ArchitectureSwitch<Set<URI>>(){

            public Set<URI> caseADElement(ADElement object) {
                this.collectURI(object.getIcon());
                return null;
            }

            public Set<URI> caseRepresentationKind(RepresentationKind object) {
                this.collectURI(object.getGrayedIcon());
                return null;
            }

            private void collectURI(String uriString) {
                if (uriString != null && !uriString.isBlank()) {
                    try {
                        result.add(URI.createURI((String)uriString));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }

            public Set<URI> defaultCase(EObject object) {
                object.eContents().forEach(arg_0 -> (this).doSwitch(arg_0));
                return result;
            }
        };
        objects.forEach(arg_0 -> ((Switch)iconsSwitch).doSwitch(arg_0));
        return result;
    }
}

