/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.junit.utils.rules;

import com.google.common.base.Charsets;
import com.google.common.io.CharSource;
import com.google.common.io.Resources;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.function.Function;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.ResourceAttributes;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.workspace.util.WorkspaceSynchronizer;
import org.eclipse.papyrus.junit.utils.JUnitUtils;
import org.eclipse.papyrus.junit.utils.rules.ProjectName;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public class ProjectFixture
implements TestRule {
    private IProject project;
    private Class<?> testClass;

    public final IProject getProject() {
        return this.project;
    }

    public URI getURI(IPath path) {
        return URI.createPlatformResourceURI((String)this.project.getFile(path).getFullPath().toString(), (boolean)true);
    }

    public URI getURI(String path) {
        return URI.createPlatformResourceURI((String)this.project.getFile((IPath)new Path(path)).getFullPath().toString(), (boolean)true);
    }

    public IFile getFile(URI uri) {
        return !uri.isPlatformResource() ? null : this.project.getWorkspace().getRoot().getFile((IPath)new Path(uri.toPlatformString(true)));
    }

    public IFile getFile(String path) {
        IResource resource = this.getProject().findMember(path);
        MatcherAssert.assertThat((String)("No such file in project: " + path), (Object)resource, (Matcher)CoreMatchers.instanceOf(IFile.class));
        MatcherAssert.assertThat((String)("File not accessible: " + path), (Object)resource.isAccessible(), (Matcher)CoreMatchers.is((Object)true));
        return (IFile)resource;
    }

    public IFile createFile(String relativeFilePath, Class<?> classFromBundle, String resourcePath) throws IOException {
        return this.createFile(relativeFilePath, classFromBundle, resourcePath, null);
    }

    public IFile createFile(String relativeFilePath, String resourcePath) throws IOException {
        return this.createFile(relativeFilePath, this.testClass, resourcePath, null);
    }

    public IFile createFile(String relativeFilePath, Class<?> classFromBundle, String resourcePath, Function<String, String> textFilter) throws IOException {
        IFile result;
        InputStream input;
        Object content;
        URL resource;
        Bundle bundle = FrameworkUtil.getBundle(classFromBundle);
        URL uRL = resource = bundle == null ? null : bundle.getResource(resourcePath);
        if (resource == null) {
            throw new IOException("No such bundle resource: " + resourcePath);
        }
        Path path = new Path(relativeFilePath);
        if (textFilter != null) {
            content = Resources.toString((URL)resource, (Charset)Charsets.UTF_8);
            content = textFilter.apply((String)content);
            input = CharSource.wrap((CharSequence)content).asByteSource(Charsets.UTF_8).openStream();
        } else {
            input = resource.openStream();
        }
        try {
            content = null;
            Object var11_12 = null;
            try {
                try {
                    this.createFolders(path.removeLastSegments(1));
                    result = this.project.getFile((IPath)path);
                    result.create(input, false, null);
                }
                finally {
                    if (input != null) {
                        input.close();
                    }
                }
            }
            catch (Throwable throwable) {
                if (content == null) {
                    content = throwable;
                } else if (content != throwable) {
                    ((Throwable)content).addSuppressed(throwable);
                }
                throw content;
            }
        }
        catch (CoreException e) {
            if (e.getStatus().getException() instanceof IOException) {
                throw (IOException)e.getStatus().getException();
            }
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            throw new IOException("Failed to create file", e);
        }
        return result;
    }

    public IFile createFile(String relativeFilePath, String resourcePath, Function<String, String> textFilter) throws IOException {
        return this.createFile(relativeFilePath, this.testClass, resourcePath, textFilter);
    }

    public static Function<String, String> replaceTokens(String token, String replacement) {
        String delimitedToken = String.format("{{%s}}", token);
        return input -> input.replace(delimitedToken, replacement);
    }

    private void createFolders(IPath folderPath) throws CoreException {
        if (folderPath.segmentCount() > 0 && !folderPath.lastSegment().isEmpty()) {
            this.createFolders(folderPath.removeLastSegments(1));
            IFolder folder = this.project.getFolder(folderPath);
            if (!folder.isAccessible()) {
                folder.create(false, true, null);
            }
        }
    }

    public IFile createFile(Class<?> classFromBundle, String resourcePath) throws IOException {
        return this.createFile(new Path(resourcePath).lastSegment(), classFromBundle, resourcePath);
    }

    public void copyFolder(Class<?> classFromBundle, String folderPath) throws IOException {
        this.copyFolder(classFromBundle, folderPath, (IContainer)this.project);
    }

    public void copyFolder(Class<?> classFromBundle, String folderPath, IContainer destination) throws IOException {
        URL resource;
        Bundle bundle = FrameworkUtil.getBundle(classFromBundle);
        URL uRL = resource = bundle == null ? null : bundle.getResource(folderPath);
        if (resource == null) {
            throw new IOException("No such bundle resource: " + folderPath);
        }
        File pluginFile = null;
        try {
            pluginFile = new File(FileLocator.toFileURL((URL)resource).toURI());
        }
        catch (URISyntaxException e1) {
            throw new IOException("Error while getting project files");
        }
        try {
            this.copyFiles(pluginFile, destination);
        }
        catch (Exception e) {
            throw new IOException("Error while copying project files");
        }
    }

    private void copyFiles(File srcFolder, IContainer destFolder) throws CoreException, FileNotFoundException {
        if (srcFolder != null && srcFolder.isDirectory()) {
            File[] fileArray = srcFolder.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File currentFile = fileArray[n2];
                if (currentFile.isDirectory()) {
                    IFolder newFolder = destFolder.getFolder((IPath)new Path(currentFile.getName()));
                    if (!newFolder.exists()) {
                        newFolder.create(true, true, null);
                    }
                    this.copyFiles(currentFile, (IContainer)newFolder);
                } else {
                    IFile newFile = destFolder.getFile((IPath)new Path(currentFile.getName()));
                    if (newFile.exists()) {
                        newFile.delete(true, null);
                    }
                    newFile.create((InputStream)new FileInputStream(currentFile), true, null);
                }
                ++n2;
            }
        }
    }

    public Statement apply(final Statement base, final Description description) {
        String name = description.getMethodName();
        ProjectName annotation = JUnitUtils.getAnnotation(description, ProjectName.class);
        if (annotation != null && annotation.value() != null) {
            name = annotation.value();
        }
        if (name == null && (name = description.getClassName()) != null) {
            name = name.substring(name.lastIndexOf(46) + 1);
        }
        final String projectName = name;
        return new Statement(){

            public void evaluate() throws Throwable {
                ProjectFixture.this.testClass = JUnitUtils.getTestClass(description);
                ProjectFixture.this.createProject(projectName);
                try {
                    base.evaluate();
                }
                finally {
                    ProjectFixture.this.deleteProject();
                    ProjectFixture.this.testClass = null;
                }
            }
        };
    }

    protected void createProject(String name) throws CoreException {
        this.project = ResourcesPlugin.getWorkspace().getRoot().getProject(name);
        if (this.project.exists()) {
            this.deleteProject();
        }
        if (!this.project.exists()) {
            this.project.create(null);
        }
        if (!this.project.isOpen()) {
            this.project.open(null);
        }
        this.project.refreshLocal(2, null);
    }

    protected void deleteProject() {
        try {
            this.project.refreshLocal(2, null);
            this.project.accept(new IResourceVisitor(){

                public boolean visit(IResource resource) throws CoreException {
                    switch (resource.getType()) {
                        case 1: 
                        case 2: {
                            ProjectFixture.this.ensureWritable(resource);
                        }
                    }
                    return true;
                }
            });
            this.project.delete(true, null);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    protected void ensureWritable(IResource resource) throws CoreException {
        ResourceAttributes attr = resource.getResourceAttributes();
        if (attr.isReadOnly()) {
            attr.setReadOnly(false);
            resource.setResourceAttributes(attr);
        }
    }

    public void setReadOnly(String projectRelativePath) {
        this.setReadOnly((IPath)new Path(projectRelativePath));
    }

    public void setReadOnly(IPath projectRelativePath) {
        this.setReadOnly(this.project.findMember(projectRelativePath));
    }

    public void setReadOnly(Resource resource) {
        IFile file = WorkspaceSynchronizer.getFile((Resource)resource);
        MatcherAssert.assertThat((String)"Cannot set non-workspace resource read-only", (Object)file, (Matcher)CoreMatchers.notNullValue());
        this.setReadOnly((IResource)file);
    }

    public void setReadOnly(IResource resource) {
        this.setReadOnly(resource, true);
    }

    public void setReadOnly(IResource resource, boolean readOnly) {
        ResourceAttributes attr = resource.getResourceAttributes();
        if (attr.isReadOnly() != readOnly) {
            attr.setReadOnly(readOnly);
            try {
                resource.setResourceAttributes(attr);
            }
            catch (CoreException e) {
                e.getLocalizedMessage();
                Assert.fail((String)String.format("Failed to make workspace resource %s: %s", readOnly ? "read-only" : "writable", e.getLocalizedMessage()));
            }
        }
    }
}

