/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.toolsmiths.plugin.builder;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.papyrus.toolsmiths.plugin.builder.AbstractPapyrusBuilder;
import org.eclipse.papyrus.toolsmiths.plugin.builder.Activator;

public class PapyrusPluginBuilder
extends IncrementalProjectBuilder {
    public static final String BUILDER_ID = "org.eclipse.papyrus.plugin.builder";
    private static final List<AbstractPapyrusBuilder> modelBuilders = new ArrayList<AbstractPapyrusBuilder>();
    private static final List<AbstractPapyrusBuilder> pluginBuilders = new ArrayList<AbstractPapyrusBuilder>();
    private static final List<AbstractPapyrusBuilder> manifestBuilders = new ArrayList<AbstractPapyrusBuilder>();

    public static final void addModelBuilder(AbstractPapyrusBuilder modelBuilder) {
        modelBuilders.add(modelBuilder);
    }

    public static final void addPluginBuilder(AbstractPapyrusBuilder pluginBuilder) {
        pluginBuilders.add(pluginBuilder);
    }

    public static final void addManifestBuilder(AbstractPapyrusBuilder pluginBuilder) {
        manifestBuilders.add(pluginBuilder);
    }

    protected IProject[] build(int kind, Map<String, String> args, IProgressMonitor monitor) throws CoreException {
        IProject[] projects;
        if (this.getProject() == null) {
            return null;
        }
        if (!this.isPapyrusPluginBuilderActivated()) {
            return null;
        }
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)(1 + (this.isPapyrusModelBuilderActivated() ? modelBuilders.size() : 0) + (this.isPapyrusManifestBuilderActivated() ? manifestBuilders.size() : 0) + pluginBuilders.size()));
        this.clean((IProgressMonitor)subMonitor.newChild(1));
        ArrayList<IProject> wantedDeltaProjects = new ArrayList<IProject>();
        if (this.isPapyrusModelBuilderActivated()) {
            for (AbstractPapyrusBuilder builder : modelBuilders) {
                projects = builder.build(this.getProject(), this, kind, args, (IProgressMonitor)subMonitor.newChild(1));
                if (projects == null || projects.length == 0) continue;
                wantedDeltaProjects.addAll(Arrays.asList(projects));
            }
        }
        if (this.isPapyrusManifestBuilderActivated()) {
            for (AbstractPapyrusBuilder builder : manifestBuilders) {
                projects = builder.build(this.getProject(), this, kind, args, (IProgressMonitor)subMonitor.newChild(1));
                if (projects == null || projects.length == 0) continue;
                wantedDeltaProjects.addAll(Arrays.asList(projects));
            }
        }
        for (AbstractPapyrusBuilder builder : pluginBuilders) {
            projects = builder.build(this.getProject(), this, kind, args, (IProgressMonitor)subMonitor.newChild(1));
            if (projects == null || projects.length == 0) continue;
            wantedDeltaProjects.addAll(Arrays.asList(projects));
        }
        SubMonitor.done((IProgressMonitor)monitor);
        return wantedDeltaProjects.toArray(new IProject[wantedDeltaProjects.size()]);
    }

    protected void clean(IProgressMonitor monitor) throws CoreException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)(1 + (this.isPapyrusModelBuilderActivated() ? modelBuilders.size() : 0) + (this.isPapyrusManifestBuilderActivated() ? manifestBuilders.size() : 0) + pluginBuilders.size()));
        super.clean((IProgressMonitor)subMonitor.newChild(1));
        if (this.isPapyrusModelBuilderActivated()) {
            for (AbstractPapyrusBuilder builder : modelBuilders) {
                builder.clean((IProgressMonitor)subMonitor.newChild(1), this.getProject());
            }
        }
        if (this.isPapyrusManifestBuilderActivated()) {
            for (AbstractPapyrusBuilder builder : manifestBuilders) {
                builder.clean((IProgressMonitor)subMonitor.newChild(1), this.getProject());
            }
        }
        for (AbstractPapyrusBuilder builder : pluginBuilders) {
            builder.clean((IProgressMonitor)subMonitor.newChild(1), this.getProject());
        }
        SubMonitor.done((IProgressMonitor)monitor);
    }

    protected boolean isPapyrusPluginBuilderActivated() {
        Boolean result = Activator.getDefault().getPreferenceStore().getBoolean("ActivateMainPapyrusBuilder");
        return result;
    }

    protected boolean isPapyrusModelBuilderActivated() {
        boolean result = Activator.getDefault().getPreferenceStore().getBoolean("ActivatePapyrusModelBuilder");
        if (result) {
            result = Activator.getDefault().getPreferenceStore().getBoolean("PapyrusModelBuilder_CheckModelDependencies") || Activator.getDefault().getPreferenceStore().getBoolean("PapyrusModelBuilder_ValidateModel");
        }
        return result;
    }

    protected boolean isPapyrusManifestBuilderActivated() {
        boolean result = Activator.getDefault().getPreferenceStore().getBoolean("ActivatePapyrusManifestBuilder");
        if (result) {
            result = Activator.getDefault().getPreferenceStore().getBoolean("PapyrusManifestBuilder_CheckDependencyRange") || Activator.getDefault().getPreferenceStore().getBoolean("PapyrusManifestBuilder_CheckReexport");
        }
        return result;
    }
}

