/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.toolsmiths.plugin.builder;

import com.google.common.collect.ListMultimap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Stream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.papyrus.toolsmiths.plugin.builder.AbstractPapyrusBuilder;
import org.eclipse.papyrus.toolsmiths.plugin.builder.PapyrusPluginBuilder;
import org.eclipse.papyrus.toolsmiths.validation.common.checkers.DiagnosticEquivalence;
import org.eclipse.papyrus.toolsmiths.validation.common.checkers.IPluginChecker2;
import org.eclipse.papyrus.toolsmiths.validation.common.utils.CheckerDiagnosticChain;
import org.eclipse.papyrus.toolsmiths.validation.common.utils.MarkersService;

public class PluginCheckerBuilder
extends AbstractPapyrusBuilder {
    private final String defaultMarkerType;
    private final Function<? super IProject, ListMultimap<IFile, ? extends EObject>> mapperFunction;
    private final List<IPluginChecker2.Factory> checkerFactories = new ArrayList<IPluginChecker2.Factory>();
    private DiagnosticEquivalence diagnosticEquivalence = DiagnosticEquivalence.DEFAULT;

    public PluginCheckerBuilder(Function<? super IProject, ListMultimap<IFile, ? extends EObject>> mapperFunction) {
        this("org.eclipse.pde.core.problem", mapperFunction);
    }

    public PluginCheckerBuilder(String defaultMarkerType, Function<? super IProject, ListMultimap<IFile, ? extends EObject>> mapperFunction) {
        this.defaultMarkerType = defaultMarkerType;
        this.mapperFunction = mapperFunction;
    }

    public PluginCheckerBuilder withChecker(IPluginChecker2.Factory checkerFactory) {
        this.checkerFactories.add(checkerFactory);
        return this;
    }

    public PluginCheckerBuilder withDiagnosticEquivalence(DiagnosticEquivalence diagnosticEquivalence) {
        this.diagnosticEquivalence = diagnosticEquivalence == null ? DiagnosticEquivalence.DEFAULT : diagnosticEquivalence;
        return this;
    }

    @Override
    public void clean(IProgressMonitor monitor, IProject iProject) throws CoreException {
        iProject.deleteMarkers(this.defaultMarkerType, true, 2);
    }

    @Override
    public IProject[] build(IProject builtProject, PapyrusPluginBuilder papyrusBuilder, int kind, Map<String, String> args, IProgressMonitor monitor) throws CoreException {
        if (papyrusBuilder.isInterrupted() || monitor.isCanceled()) {
            return null;
        }
        ListMultimap<IFile, ? extends EObject> sets = this.mapperFunction.apply((IProject)builtProject);
        if (sets.isEmpty()) {
            return null;
        }
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)((1 + sets.keySet().size()) * this.checkerFactories.size() + 1));
        CheckerDiagnosticChain diagnostics = new CheckerDiagnosticChain();
        this.check(builtProject, null, null, (DiagnosticChain)diagnostics, subMonitor);
        for (IFile next : sets.keySet()) {
            Resource resource = ((EObject)sets.get((Object)next).get(0)).eResource();
            this.check(builtProject, next, resource, (DiagnosticChain)diagnostics, subMonitor);
        }
        if (diagnostics.getSeverity() > 0) {
            this.wrap(diagnostics.stream()).distinct().forEach(this::createMarker);
        }
        subMonitor.worked(1);
        SubMonitor.done((IProgressMonitor)monitor);
        return new IProject[]{builtProject};
    }

    private void check(IProject project, IFile modelFile, Resource resource, DiagnosticChain diagnostics, SubMonitor monitor) {
        this.checkerFactories.stream().map(factory -> factory.createChecker(project, modelFile, resource)).peek(checker -> {
            if (checker == null) {
                monitor.worked(1);
            }
        }).filter(Objects::nonNull).forEach(checker -> checker.check(diagnostics, (IProgressMonitor)monitor.newChild(1)));
    }

    protected void createMarker(Diagnostic diagnostic) {
        IPluginChecker2.getFile((Diagnostic)diagnostic).map(file -> this.createMarker((IFile)file, diagnostic)).ifPresent(marker -> IPluginChecker2.setAttributes((Diagnostic)diagnostic, (IMarker)marker));
    }

    private IMarker createMarker(IFile file, Diagnostic diagnostic) {
        return MarkersService.createMarker((IResource)file, (String)IPluginChecker2.getMarkerType((Diagnostic)diagnostic).orElse(this.defaultMarkerType), (Diagnostic)diagnostic);
    }

    private Diagnostic wrap(Diagnostic diagnostic) {
        return IPluginChecker2.getMarkerType((Diagnostic)diagnostic).isEmpty() ? this.diagnosticEquivalence.wrap(diagnostic, new Object[]{IPluginChecker2.markerType((String)this.defaultMarkerType)}) : this.diagnosticEquivalence.wrap(diagnostic, new Object[0]);
    }

    private Stream<Diagnostic> wrap(Stream<Diagnostic> diagnostics) {
        return diagnostics.map(this::wrap);
    }
}

