/*****************************************************************************
 * Copyright (c) 2019, 2021 CEA LIST, Christian W. Damus, and others.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 *   Nicolas FAUVERGUE (CEA LIST) nicolas.fauvergue@cea.fr - Initial API and implementation
 *   Christian W. Damus - bug 570097
 *
 *****************************************************************************/

package org.eclipse.papyrus.toolsmiths.validation.profile.constants;

import org.eclipse.papyrus.toolsmiths.validation.common.checkers.CommonProblemConstants;

/**
 * The profile plug-in validation constants.
 */
public class ProfilePluginValidationConstants {

	/**
	 * The type for the validation of profile plugin.
	 */
	public static final String PROFILE_PLUGIN_VALIDATION_MARKER_TYPE = "org.eclipse.papyrus.toolsmiths.validation.profile.diagnostic"; //$NON-NLS-1$

	/**
	 * The UMLProfile extension point identifier.
	 */
	public static final String UMLPROFILE_EXTENSION_POINT = "org.eclipse.papyrus.uml.extensionpoints.UMLProfile"; //$NON-NLS-1$

	/**
	 * The uml generated package extension point identifier.
	 */
	public static final String UML_GENERATED_PACKAGE_EXTENSION_POINT = "org.eclipse.uml2.uml.generated_package"; //$NON-NLS-1$

	/**
	 * The EMF Ecore generated package extension point identifier.
	 */
	public static final String ECORE_GENERATED_PACKAGE_EXTENSION_POINT = "org.eclipse.emf.ecore.generated_package"; //$NON-NLS-1$

	/**
	 * The EMF Ecore URI mapping extension point identifier.
	 */
	public static final String ECORE_URI_MAPPING_EXTENSION_POINT = "org.eclipse.emf.ecore.uri_mapping"; //$NON-NLS-1$

	/** additional marker attributes */
	public static final String STATIC_PROFILE_STEREOTYPE_URI = "staticProfileStereotypeUri"; //$NON-NLS-1$

	/** Problem IDs for the markers generated by the profile error reporters. */
	public static final int PROBLEM_ID_BASE = CommonProblemConstants.MAX_PROBLEM_ID + 0x01;
	public static final int NO_GENMODEL_MARKER_ID = PROBLEM_ID_BASE + 0x00;
	public static final int PAPYRUS_PROFILE_EXTENSION_NO_NAME_MARKER_ID = PROBLEM_ID_BASE + 0x01;
	public static final int MISSING_UML_EXTENSION_MARKER_ID = PROBLEM_ID_BASE + 0x02;
	public static final int NO_URI_MARKER_ID = PROBLEM_ID_BASE + 0x03;
	public static final int NO_ECORE_GEN_PACKAGE_MARKER_ID = PROBLEM_ID_BASE + 0x04;
	public static final int NO_UML2_GEN_PACKAGE_MARKER_ID = PROBLEM_ID_BASE + 0x05;
	public static final int NO_PAPYRUS_PROFILE_MARKER_ID = PROBLEM_ID_BASE + 0x06;
	public static final int NO_UML2_GEN_PACKAGE_LOCATION_MARKER_ID = PROBLEM_ID_BASE + 0x07;
	public static final int MAX_PROBLEM_ID = PROBLEM_ID_BASE + 0x3f;
}
