/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.common.commands;

import com.google.common.collect.Iterables;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.notation.CanonicalStyle;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.gmfdiag.common.editpolicies.IPapyrusCanonicalEditPolicy;
import org.eclipse.papyrus.infra.gmfdiag.common.utils.DiagramEditPartsUtil;

public class SetCanonicalCommand
extends AbstractTransactionalCommand {
    private View view;
    private boolean canonical;

    public SetCanonicalCommand(TransactionalEditingDomain domain, View view, boolean canonical) {
        super(domain, "Set Canonical", SetCanonicalCommand.getWorkspaceFiles((EObject)view));
        this.view = view;
        this.canonical = canonical;
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        CommandResult result = null;
        Iterable<EditPart> editParts = DiagramEditPartsUtil.findEditParts(this.view);
        if (Iterables.isEmpty(editParts)) {
            result = CommandResult.newErrorCommandResult((String)"Notation view has no EditParts");
        } else {
            this.setCanonical(this.view, this.canonical);
            this.refreshCanonical(editParts);
            result = CommandResult.newOKCommandResult((Object)this.canonical);
        }
        return result;
    }

    protected void setCanonical(View view, boolean canonical) {
        CanonicalStyle style = (CanonicalStyle)view.getStyle(NotationPackage.Literals.CANONICAL_STYLE);
        if (style == null) {
            style = (CanonicalStyle)view.createStyle(NotationPackage.Literals.CANONICAL_STYLE);
        }
        style.setCanonical(canonical);
        if (style.eContainer() == null) {
            EList styles = view.getStyles();
            styles.add(style);
        }
    }

    protected void refreshCanonical(Iterable<? extends EditPart> editParts) {
        TreeIterator<EditPart> all = DiagramEditPartsUtil.getAllContents(editParts);
        while (all.hasNext()) {
            EditPolicy editPolicy = ((EditPart)all.next()).getEditPolicy((Object)"Canonical");
            if (!(editPolicy instanceof IPapyrusCanonicalEditPolicy)) continue;
            ((IPapyrusCanonicalEditPolicy)editPolicy).refreshActive();
        }
    }

    protected IStatus doUndo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        IStatus result = super.doUndo(monitor, info);
        this.refreshCanonical(DiagramEditPartsUtil.findEditParts(this.view));
        return result;
    }

    protected IStatus doRedo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        IStatus result = super.doRedo(monitor, info);
        this.refreshCanonical(DiagramEditPartsUtil.findEditParts(this.view));
        return result;
    }
}

