/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.emf.resource;

import java.util.Collection;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandWrapper;
import org.eclipse.emf.common.command.IdentityCommand;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.RemoveCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.infra.tools.util.TypeUtils;

public class ShardResourceHelper
implements AutoCloseable {
    private final Resource resource;
    private final EObject object;
    private boolean closed;
    private boolean initialized;
    private EAnnotation annotation;
    private Adapter annotationAdapter;

    public ShardResourceHelper(Resource resource) {
        this(resource, null);
    }

    public ShardResourceHelper(EObject element) {
        this(element.eResource(), element);
    }

    private ShardResourceHelper(Resource resource, EObject object) {
        this.resource = resource;
        this.object = object;
    }

    public boolean isShard() {
        return this.getAnnotation() != null;
    }

    public void setShard(boolean isShard) {
        this.checkClosed();
        if (isShard != this.isShard()) {
            if (this.getAnnotation() != null) {
                EcoreUtil.remove((EObject)this.getAnnotation());
            } else {
                EObject annotationOwner;
                EAnnotation annotation = EcoreFactory.eINSTANCE.createEAnnotation();
                annotation.setSource("http://www.eclipse.org/papyrus/2016/resource/shard");
                EObject shardElement = this.getShardElement();
                if (shardElement instanceof EModelElement) {
                    ((EModelElement)shardElement).getEAnnotations().add((Object)annotation);
                    annotationOwner = shardElement;
                } else if (shardElement != null) {
                    int index = this.resource.getContents().indexOf((Object)shardElement) + 1;
                    this.resource.getContents().add(index, (Object)annotation);
                    annotationOwner = this.resource;
                } else {
                    this.resource.getContents().add(Math.min(1, this.resource.getContents().size()), (Object)annotation);
                    annotationOwner = this.resource;
                }
                if (shardElement != null && shardElement.eContainer() != null) {
                    annotation.getReferences().add((Object)shardElement.eContainer());
                }
                this.setAnnotation(annotation);
                this.attachAnnotationAdapter((Notifier)annotationOwner);
            }
        }
    }

    private EObject getShardElement() {
        this.checkClosed();
        EObject result = null;
        if (this.object != null) {
            result = this.object;
            while (result != null) {
                InternalEObject internal = (InternalEObject)result;
                if (internal.eDirectResource() == this.resource) break;
                result = result.eContainer();
            }
        }
        if (result == null && !this.resource.getContents().isEmpty()) {
            result = (EObject)this.resource.getContents().get(0);
        }
        return result;
    }

    public Command getSetShardCommand(boolean isShard) {
        Object result;
        if (this.isShard() == isShard) {
            result = IdentityCommand.INSTANCE;
        } else if (this.getAnnotation() != null) {
            EAnnotation annotation = this.getAnnotation();
            result = annotation.getEModelElement() != null ? RemoveCommand.create((EditingDomain)EMFHelper.resolveEditingDomain((EObject)annotation), (Object)annotation.getEModelElement(), (Object)EcorePackage.Literals.EMODEL_ELEMENT__EANNOTATIONS, (Object)annotation) : new RemoveCommand(EMFHelper.resolveEditingDomain(this.resource), this.resource.getContents(), (Object)annotation);
            result = new CommandWrapper("Toggle Submodel", "Toggle the ability to open the resource as an independent sub-model unit", (Command)result);
        } else {
            EObject annotationOwner;
            EditingDomain domain;
            final EAnnotation annotation = EcoreFactory.eINSTANCE.createEAnnotation();
            annotation.setSource("http://www.eclipse.org/papyrus/2016/resource/shard");
            EObject shardElement = this.getShardElement();
            if (shardElement instanceof EModelElement) {
                domain = EMFHelper.resolveEditingDomain(shardElement);
                result = AddCommand.create((EditingDomain)domain, (Object)shardElement, (Object)EcorePackage.Literals.EMODEL_ELEMENT__EANNOTATIONS, (Object)annotation);
                annotationOwner = shardElement;
            } else if (shardElement != null) {
                int index = this.resource.getContents().indexOf((Object)shardElement) + 1;
                domain = EMFHelper.resolveEditingDomain(shardElement);
                result = new AddCommand(domain, this.resource.getContents(), (Object)annotation, index);
                annotationOwner = this.resource;
            } else {
                domain = EMFHelper.resolveEditingDomain(this.resource);
                int index = Math.min(1, this.resource.getContents().size());
                result = new AddCommand(domain, this.resource.getContents(), (Object)annotation, index);
                annotationOwner = this.resource;
            }
            if (shardElement != null && shardElement.eContainer() != null) {
                result = result.chain(AddCommand.create((EditingDomain)domain, (Object)annotation, (Object)EcorePackage.Literals.EANNOTATION__REFERENCES, (Object)shardElement.eContainer()));
            }
            result = new CommandWrapper("Toggle Submodel", "Toggle the ability to open the resource as an independent sub-model unit", (Command)result, (Notifier)annotationOwner){
                private final /* synthetic */ Notifier val$annotationOwner;
                {
                    this.val$annotationOwner = notifier;
                    super($anonymous0, $anonymous1, $anonymous2);
                }

                public void execute() {
                    super.execute();
                    if (!ShardResourceHelper.this.isClosed()) {
                        ShardResourceHelper.this.setAnnotation(annotation);
                        ShardResourceHelper.this.attachAnnotationAdapter(this.val$annotationOwner);
                    }
                }
            };
        }
        return result;
    }

    @Override
    public void close() {
        this.closed = true;
        this.doClose();
    }

    protected void doClose() {
        this.clearAnnotation();
        this.detachAnnotationAdapter();
    }

    public final boolean isClosed() {
        return this.closed;
    }

    protected final void checkClosed() {
        if (this.isClosed()) {
            throw new IllegalStateException("closed");
        }
    }

    private EAnnotation getAnnotation() {
        this.checkClosed();
        if (!this.initialized) {
            this.setAnnotation(this.findAnnotation());
            this.initialized = true;
        }
        return this.annotation;
    }

    private EAnnotation findAnnotation() {
        EAnnotation result = null;
        if (this.resource != null && !this.resource.getContents().isEmpty()) {
            EObject annotationOwner;
            EObject shardElement = this.getShardElement();
            if (shardElement instanceof EModelElement) {
                result = ((EModelElement)shardElement).getEAnnotation("http://www.eclipse.org/papyrus/2016/resource/shard");
                annotationOwner = shardElement;
            } else {
                EAnnotation maybe;
                int index;
                EList contents = this.resource.getContents();
                annotationOwner = this.resource;
                if (shardElement != null && (index = contents.indexOf(shardElement) + 1) < contents.size() && (maybe = (EAnnotation)TypeUtils.as(contents.get(index), EAnnotation.class)) != null && "http://www.eclipse.org/papyrus/2016/resource/shard".equals(maybe.getSource())) {
                    result = maybe;
                }
                if (result == null && this.object == null) {
                    result = contents.stream().filter(EAnnotation.class::isInstance).map(EAnnotation.class::cast).filter(a -> "http://www.eclipse.org/papyrus/2016/resource/shard".equals(a.getSource())).findFirst().orElse(null);
                }
            }
            this.attachAnnotationAdapter((Notifier)annotationOwner);
        }
        return result;
    }

    private void clearAnnotation() {
        this.initialized = false;
        this.setAnnotation(null);
    }

    private void setAnnotation(EAnnotation annotation) {
        this.annotation = annotation;
    }

    private void attachAnnotationAdapter(Notifier annotationOwner) {
        if (this.annotationAdapter == null) {
            this.annotationAdapter = new AdapterImpl(){

                public void notifyChanged(Notification msg) {
                    if (msg.getEventType() == 8) {
                        ShardResourceHelper.this.clearAnnotation();
                    } else if (msg.getFeature() == EcorePackage.Literals.EMODEL_ELEMENT__EANNOTATIONS || msg.getNotifier() == ShardResourceHelper.this.resource && msg.getFeatureID(Resource.class) == 2) {
                        boolean clear = false;
                        switch (msg.getEventType()) {
                            case 1: 
                            case 2: 
                            case 4: {
                                clear = msg.getOldValue() == ShardResourceHelper.this.getAnnotation();
                                break;
                            }
                            case 3: 
                            case 5: {
                                clear = ShardResourceHelper.this.getAnnotation() == null;
                                break;
                            }
                            case 6: {
                                clear = ((Collection)msg.getOldValue()).contains(ShardResourceHelper.this.getAnnotation());
                            }
                        }
                        if (clear) {
                            ShardResourceHelper.this.clearAnnotation();
                        }
                    }
                }
            };
            annotationOwner.eAdapters().add((Object)this.annotationAdapter);
        }
    }

    private void detachAnnotationAdapter() {
        if (this.annotationAdapter != null) {
            Adapter adapter = this.annotationAdapter;
            this.annotationAdapter = null;
            if (adapter.getTarget() != null) {
                adapter.getTarget().eAdapters().remove((Object)adapter);
            }
        }
    }
}

