/**
 * Copyright (c) 2011 - 2013 Montages AG
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 * Svyatoslav Kovalsky (Montages) - initial API and implementation
 * Michael Golubev (Montages) - #386838 - migrate to Xtend2
 */
package aspects.impl.diagram.editparts;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenParserImplementation;
import org.eclipse.papyrus.gmf.codegen.gmfgen.LabelModelFacet;
import org.eclipse.papyrus.gmf.codegen.gmfgen.OclChoiceParser;
import org.eclipse.papyrus.gmf.codegen.gmfgen.PredefinedEnumParser;
import org.eclipse.xtext.xbase.lib.Extension;
import xpt.Common_qvto;

@Singleton
@SuppressWarnings("all")
public class ChoiceUtils_qvto extends impl.diagram.editparts.ChoiceUtils_qvto {
  @Inject
  @Extension
  private Common_qvto _common_qvto;
  
  @Override
  public boolean isChoiceLabel(final LabelModelFacet modelFacet) {
    GenParserImplementation parser = modelFacet.getParser();
    boolean _notEquals = (!Objects.equal(parser, null));
    if (_notEquals) {
      return (this._common_qvto.oclIsKindOf(parser, PredefinedEnumParser.class) || this._common_qvto.oclIsKindOf(parser, OclChoiceParser.class));
    } else {
      return false;
    }
  }
}
