/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.emf.utils;

import com.google.common.base.Function;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;

public class EMFFunctions {
    private EMFFunctions() {
    }

    public static Function<EObject, URI> objectURI() {
        return new Function<EObject, URI>(){

            public URI apply(EObject input) {
                return input == null ? null : EcoreUtil.getURI((EObject)input);
            }
        };
    }

    public static Function<Resource, URI> resourceURI() {
        return new Function<Resource, URI>(){

            public URI apply(Resource input) {
                return input == null ? null : input.getURI();
            }
        };
    }

    public static Function<URI, URI> trimURIFragment() {
        return new Function<URI, URI>(){

            public URI apply(URI input) {
                return input == null ? null : input.trimFragment();
            }
        };
    }

    public static Function<EObject, Object> getFeature(final EStructuralFeature feature) {
        return new Function<EObject, Object>(){

            public Object apply(EObject input) {
                return input == null ? null : input.eGet(feature);
            }
        };
    }

    public static <T> Function<EObject, T> getFeature(final EStructuralFeature feature, final Class<T> ofType) {
        return new Function<EObject, T>(){

            public T apply(EObject input) {
                return input == null ? null : (Object)ofType.cast(input.eGet(feature));
            }
        };
    }
}

