/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.nattable.common.reconciler;

import java.util.AbstractMap;
import java.util.StringTokenizer;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.type.core.commands.SetValueCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.SetRequest;
import org.eclipse.papyrus.infra.nattable.common.Activator;
import org.eclipse.papyrus.infra.nattable.model.nattable.Table;

public class TableVersioningUtils {
    public static final String VERSION_ANNOTATION = "http://www.eclipse.org/papyrus/infra/nattable/version";
    public static final String COMPATIBILITY_VERSION = "version";
    public static final String UNDEFINED_VERSION = "undefined";
    private static final String DELIM_VERSION = ".";

    private static String CURRENT_TABLE_VERSION() {
        return "1.3.0";
    }

    public static void stampCurrentVersion(Table table) {
        TableVersioningUtils.setCompatibilityVersion(table, TableVersioningUtils.CURRENT_TABLE_VERSION());
    }

    public static ICommand createStampCurrentVersionCommand(Table table) {
        EAnnotation annot = TableVersioningUtils.findOrCreateCompatibilityAnnotation(table);
        if (annot.eContainer() == null) {
            annot.getDetails().put((Object)COMPATIBILITY_VERSION, (Object)TableVersioningUtils.CURRENT_TABLE_VERSION());
            return new SetValueCommand(new SetRequest((EObject)table, (EStructuralFeature)EcorePackage.eINSTANCE.getEModelElement_EAnnotations(), (Object)annot));
        }
        return new SetValueCommand(new SetRequest((EObject)annot, (EStructuralFeature)EcorePackage.eINSTANCE.getEAnnotation_Details(), new AbstractMap.SimpleEntry<String, String>(COMPATIBILITY_VERSION, TableVersioningUtils.CURRENT_TABLE_VERSION())));
    }

    public static String getCompatibilityVersion(Table table) {
        EAnnotation annot = TableVersioningUtils.findOrCreateCompatibilityAnnotation(table);
        return annot.eContainer() == null ? UNDEFINED_VERSION : (String)annot.getDetails().get((Object)COMPATIBILITY_VERSION);
    }

    public static void setCompatibilityVersion(Table table, String version) {
        EAnnotation annot = TableVersioningUtils.findOrCreateCompatibilityAnnotation(table);
        annot.getDetails().put((Object)COMPATIBILITY_VERSION, (Object)version);
        if (annot.eContainer() == null) {
            table.getEAnnotations().add((Object)annot);
        }
    }

    private static EAnnotation findOrCreateCompatibilityAnnotation(Table table) {
        EAnnotation annot = table.getEAnnotation(VERSION_ANNOTATION);
        if (annot == null) {
            annot = EcoreFactory.eINSTANCE.createEAnnotation();
            annot.setSource(VERSION_ANNOTATION);
            annot.getDetails().put((Object)COMPATIBILITY_VERSION, (Object)TableVersioningUtils.CURRENT_TABLE_VERSION());
        }
        return annot;
    }

    public static boolean isOfCurrentPapyrusVersion(Table table) {
        return TableVersioningUtils.isCurrentPapyrusVersion(TableVersioningUtils.getCompatibilityVersion(table));
    }

    public static boolean isCurrentPapyrusVersion(String version) {
        return TableVersioningUtils.CURRENT_TABLE_VERSION().equals(version);
    }

    public static boolean isBeforeVersion(String referenceVersion, String testedVersion) {
        boolean before = false;
        StringTokenizer targetVersionTokenizer = new StringTokenizer(referenceVersion, DELIM_VERSION);
        StringTokenizer sourceVersionTokenizer = new StringTokenizer(testedVersion, DELIM_VERSION);
        try {
            if (targetVersionTokenizer.countTokens() == sourceVersionTokenizer.countTokens()) {
                int sourceIntermediateVersion;
                int targetIntermediateVersion;
                int sourceMainVersion;
                int targetMainVersion = Integer.parseInt(targetVersionTokenizer.nextToken());
                before = targetMainVersion == (sourceMainVersion = Integer.parseInt(sourceVersionTokenizer.nextToken())) ? (targetIntermediateVersion = Integer.parseInt(targetVersionTokenizer.nextToken())) > (sourceIntermediateVersion = Integer.parseInt(sourceVersionTokenizer.nextToken())) : targetMainVersion > sourceMainVersion;
            }
        }
        catch (NumberFormatException e) {
            Activator.log.error((Throwable)e);
        }
        return before;
    }
}

