/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.common.util;

import java.util.Collections;
import java.util.Map;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.impl.InternalTransaction;
import org.eclipse.emf.transaction.impl.InternalTransactionalEditingDomain;
import org.eclipse.emf.workspace.AbstractEMFOperation;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.parts.DiagramGraphicalViewer;
import org.eclipse.gmf.runtime.diagram.ui.util.EditPartUtil;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.emf.gmf.command.GMFtoEMFCommandWrapper;
import org.eclipse.papyrus.infra.emf.gmf.util.GMFUnsafe;
import org.eclipse.papyrus.infra.emf.utils.ServiceUtilsForEObject;
import org.eclipse.papyrus.uml.diagram.common.Activator;

public class CommandUtil {
    private static final String DOMAIN_FORMAT = "The transactional Domain cannot be retrived from the object %s";

    public static void executeCommand(final org.eclipse.gef.commands.Command cmd, IGraphicalEditPart part) {
        Map<String, Boolean> options = null;
        boolean isActivating = true;
        EditPartViewer viewer = part.getViewer();
        if (viewer instanceof DiagramGraphicalViewer) {
            isActivating = ((DiagramGraphicalViewer)viewer).isInitializing();
        }
        if (isActivating || !EditPartUtil.isWriteTransactionInProgress((IGraphicalEditPart)part, (boolean)false, (boolean)false)) {
            options = Collections.singletonMap("unprotected", Boolean.TRUE);
        }
        AbstractEMFOperation operation = new AbstractEMFOperation(part.getEditingDomain(), "", options){

            protected IStatus doExecute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                cmd.execute();
                return Status.OK_STATUS;
            }
        };
        try {
            operation.execute((IProgressMonitor)new NullProgressMonitor(), null);
        }
        catch (ExecutionException e) {
            Activator.log.error((Throwable)e);
        }
    }

    public static void executeUnsafeCommand(ICommand command, Object object) {
        TransactionalEditingDomain domain = CommandUtil.resolveEditingDomain(object);
        if (domain != null) {
            CommandUtil.executeCommand(command, domain);
        }
    }

    public static void executeUnsafeCommand(Command command, Object object) {
        TransactionalEditingDomain domain = CommandUtil.resolveEditingDomain(object);
        if (domain != null) {
            CommandUtil.executeCommand(command, domain);
        }
    }

    public static void executeUnsafeCommand(Runnable command, Object object) {
        TransactionalEditingDomain domain = CommandUtil.resolveEditingDomain(object);
        if (domain != null) {
            CommandUtil.executeCommand(command, domain);
        }
    }

    public static void executeCommandInStack(Command command, Object object) {
        TransactionalEditingDomain domain = CommandUtil.resolveEditingDomain(object);
        if (CommandUtil.canWrite(domain) && command.canExecute()) {
            command.execute();
        } else {
            domain.getCommandStack().execute(command);
        }
    }

    public static TransactionalEditingDomain resolveEditingDomain(Object object) {
        TransactionalEditingDomain domain = null;
        try {
            if (object instanceof TransactionalEditingDomain) {
                domain = (TransactionalEditingDomain)object;
            } else if (object instanceof IGraphicalEditPart) {
                domain = ((IGraphicalEditPart)object).getEditingDomain();
            } else if (object instanceof EObject) {
                domain = ServiceUtilsForEObject.getInstance().getTransactionalEditingDomain((Object)((EObject)object));
            } else {
                Activator.log.error(String.format(DOMAIN_FORMAT, object.toString()), null);
            }
        }
        catch (ServiceException e) {
            Activator.log.error((Throwable)e);
        }
        return domain;
    }

    public static void executeCommand(Command command, TransactionalEditingDomain domain) {
        if (!CommandUtil.canWrite(domain)) {
            try {
                GMFUnsafe.write((TransactionalEditingDomain)domain, (Command)command);
            }
            catch (Exception e) {
                Activator.log.error("Unprotected command execution failed.", (Throwable)e);
            }
        } else if (command.canExecute()) {
            command.execute();
        }
    }

    private static boolean canWrite(TransactionalEditingDomain domain) {
        InternalTransaction activeTransaction = null;
        if (domain instanceof InternalTransactionalEditingDomain) {
            activeTransaction = ((InternalTransactionalEditingDomain)domain).getActiveTransaction();
        }
        return activeTransaction != null && !activeTransaction.isReadOnly();
    }

    private static void executeCommand(ICommand command, TransactionalEditingDomain domain) {
        CommandUtil.executeCommand(GMFtoEMFCommandWrapper.wrap((ICommand)command), domain);
    }

    private static void executeCommand(Runnable command, TransactionalEditingDomain domain) {
        if (!CommandUtil.canWrite(domain)) {
            try {
                GMFUnsafe.write((TransactionalEditingDomain)domain, (Runnable)command);
            }
            catch (Exception e) {
                Activator.log.error("Unprotected command execution failed.", (Throwable)e);
            }
        } else {
            command.run();
        }
    }
}

