/*
 * Decompiled with CFR 0.152.
 */
package xpt.navigator;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Arrays;
import java.util.Set;
import org.eclipse.emf.codegen.util.CodeGenUtil;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenCommonBase;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenDiagram;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenLink;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenNavigator;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenNavigatorChildReference;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenNavigatorPath;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenNavigatorPathSegment;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenNavigatorReferenceType;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenNode;
import org.eclipse.papyrus.gmf.codegen.xtend.annotations.Localization;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.IntegerRange;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import xpt.CodeStyle;
import xpt.Common;
import xpt.Common_qvto;
import xpt.Externalizer;
import xpt.editor.VisualIDRegistry;
import xpt.navigator.NavigatorAbstractNavigatorItem;
import xpt.navigator.NavigatorGroup;
import xpt.navigator.NavigatorItem;
import xpt.navigator.Utils_qvto;

@Singleton
public class NavigatorContentProvider {
    @Inject
    @Extension
    private Common _common;
    @Inject
    @Extension
    private Common_qvto _common_qvto;
    @Inject
    @Extension
    private Utils_qvto _utils_qvto;
    @Inject
    @Extension
    private CodeStyle _codeStyle;
    @Inject
    private VisualIDRegistry xptVisualIDRegistry;
    @Inject
    private Externalizer xptExternalizer;
    @Inject
    private NavigatorGroup navigatorGroup;
    @Inject
    private NavigatorAbstractNavigatorItem abstractNavigatorItem;
    @Inject
    private NavigatorItem xptNavigatorItem;

    public CharSequence className(GenNavigator it) {
        StringConcatenation _builder = new StringConcatenation();
        String _contentProviderClassName = it.getContentProviderClassName();
        _builder.append(_contentProviderClassName);
        return _builder;
    }

    public CharSequence packageName(GenNavigator it) {
        StringConcatenation _builder = new StringConcatenation();
        String _packageName = it.getPackageName();
        _builder.append(_packageName);
        return _builder;
    }

    public CharSequence qualifiedClassName(GenNavigator it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _packageName = this.packageName(it);
        _builder.append((Object)_packageName);
        _builder.append(".");
        CharSequence _className = this.className(it);
        _builder.append((Object)_className);
        return _builder;
    }

    public CharSequence fullPath(GenNavigator it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _qualifiedClassName = this.qualifiedClassName(it);
        _builder.append((Object)_qualifiedClassName);
        return _builder;
    }

    public CharSequence NavigatorContentProvider(GenNavigator it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _copyright = this._common.copyright(it.getEditorGen());
        _builder.append((Object)_copyright);
        _builder.newLineIfNotEmpty();
        _builder.append("package ");
        CharSequence _packageName = this.packageName(it);
        _builder.append((Object)_packageName);
        _builder.append(";");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        CharSequence _generatedClassComment = this._common.generatedClassComment();
        _builder.append((Object)_generatedClassComment);
        _builder.newLineIfNotEmpty();
        _builder.append("public class ");
        CharSequence _className = this.className(it);
        _builder.append((Object)_className);
        _builder.append(" implements org.eclipse.ui.navigator.ICommonContentProvider {");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("\t");
        CharSequence _attributes = this.attributes(it);
        _builder.append((Object)_attributes, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        CharSequence _constructor = this.constructor(it);
        _builder.append((Object)_constructor, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        CharSequence _genAllMethodNodeCase = this.genAllMethodNodeCase(it);
        _builder.append((Object)_genAllMethodNodeCase, "\t");
        _builder.append(" ");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        CharSequence _iContentProvider = this.iContentProvider(it);
        _builder.append((Object)_iContentProvider, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        CharSequence _iStructuredContentProvider = this.iStructuredContentProvider(it);
        _builder.append((Object)_iStructuredContentProvider, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        CharSequence _iMementoAware = this.iMementoAware(it);
        _builder.append((Object)_iMementoAware, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        CharSequence _iCommonContentProvider = this.iCommonContentProvider(it);
        _builder.append((Object)_iCommonContentProvider, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        CharSequence _iTreeContentProvider = this.iTreeContentProvider(it);
        _builder.append((Object)_iTreeContentProvider, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence attributes(GenNavigator it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _generatedMemberComment = this._common.generatedMemberComment();
        _builder.append((Object)_generatedMemberComment);
        _builder.newLineIfNotEmpty();
        _builder.append("private static final Object[] EMPTY_ARRAY = new Object[0];");
        _builder.newLine();
        _builder.newLine();
        CharSequence _generatedMemberComment_1 = this._common.generatedMemberComment();
        _builder.append((Object)_generatedMemberComment_1);
        _builder.newLineIfNotEmpty();
        _builder.append("private org.eclipse.jface.viewers.Viewer myViewer;");
        _builder.newLine();
        _builder.newLine();
        CharSequence _generatedMemberComment_2 = this._common.generatedMemberComment();
        _builder.append((Object)_generatedMemberComment_2);
        _builder.newLineIfNotEmpty();
        _builder.append("private org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain myEditingDomain;");
        _builder.newLine();
        _builder.newLine();
        CharSequence _generatedMemberComment_3 = this._common.generatedMemberComment();
        _builder.append((Object)_generatedMemberComment_3);
        _builder.newLineIfNotEmpty();
        _builder.append("private org.eclipse.emf.workspace.util.WorkspaceSynchronizer myWorkspaceSynchronizer;");
        _builder.newLine();
        _builder.newLine();
        CharSequence _generatedMemberComment_4 = this._common.generatedMemberComment();
        _builder.append((Object)_generatedMemberComment_4);
        _builder.newLineIfNotEmpty();
        _builder.append("private Runnable myViewerRefreshRunnable;");
        _builder.newLine();
        return _builder;
    }

    public CharSequence constructor(GenNavigator it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _generatedMemberComment = this._common.generatedMemberComment();
        _builder.append((Object)_generatedMemberComment);
        _builder.newLineIfNotEmpty();
        _builder.append("public ");
        CharSequence _className = this.className(it);
        _builder.append((Object)_className);
        _builder.append("() {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        CharSequence _initCommonAttributes = this.initCommonAttributes(it);
        _builder.append((Object)_initCommonAttributes, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence initCommonAttributes(GenNavigator it) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("org.eclipse.emf.transaction.TransactionalEditingDomain editingDomain = ");
        CharSequence _createEditingDomain = this.createEditingDomain(it);
        _builder.append((Object)_createEditingDomain);
        _builder.append(";");
        _builder.newLineIfNotEmpty();
        _builder.append("myEditingDomain = (org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain) editingDomain;");
        _builder.newLine();
        _builder.append("@SuppressWarnings(\"serial\")");
        _builder.newLine();
        _builder.append("java.util.Map<org.eclipse.emf.ecore.resource.Resource, java.lang.Boolean> map = new java.util.HashMap<");
        String _diamondOp = this._codeStyle.diamondOp((GenCommonBase)it.getEditorGen().getDiagram(), "org.eclipse.emf.ecore.resource.Resource", "java.lang.Boolean");
        _builder.append(_diamondOp);
        _builder.append(">() {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        CharSequence _overrideI = this._codeStyle.overrideI(it);
        _builder.append((Object)_overrideI, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("public java.lang.Boolean get(java.lang.Object key) {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("if (!containsKey(key)) {");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("if (key instanceof org.eclipse.emf.ecore.resource.Resource) {");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("put((org.eclipse.emf.ecore.resource.Resource) key, java.lang.Boolean.TRUE);");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("return super.get(key);");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("};");
        _builder.newLine();
        _builder.append("myEditingDomain.setResourceToReadOnlyMap(map);");
        _builder.newLine();
        _builder.append("myViewerRefreshRunnable = new Runnable() {");
        _builder.newLine();
        _builder.append("\t");
        CharSequence _overrideI_1 = this._codeStyle.overrideI(it);
        _builder.append((Object)_overrideI_1, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("public void run() {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("if (myViewer != null) {");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("myViewer.refresh();");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("};");
        _builder.newLine();
        _builder.append("myWorkspaceSynchronizer = new org.eclipse.emf.workspace.util.WorkspaceSynchronizer(editingDomain, new org.eclipse.emf.workspace.util.WorkspaceSynchronizer.Delegate() {");
        _builder.newLine();
        _builder.append("\t");
        CharSequence _overrideC = this._codeStyle.overrideC(it);
        _builder.append((Object)_overrideC, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("public void dispose() {");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        CharSequence _overrideC_1 = this._codeStyle.overrideC(it);
        _builder.append((Object)_overrideC_1, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("public boolean handleResourceChanged(final org.eclipse.emf.ecore.resource.Resource resource) {");
        _builder.newLine();
        _builder.append("\t\t");
        CharSequence _processChanges = this.processChanges(it);
        _builder.append((Object)_processChanges, "\t\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        CharSequence _overrideC_2 = this._codeStyle.overrideC(it);
        _builder.append((Object)_overrideC_2, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("public boolean handleResourceDeleted(org.eclipse.emf.ecore.resource.Resource resource) {");
        _builder.newLine();
        _builder.append("\t\t");
        CharSequence _processChanges_1 = this.processChanges(it);
        _builder.append((Object)_processChanges_1, "\t\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        CharSequence _overrideC_3 = this._codeStyle.overrideC(it);
        _builder.append((Object)_overrideC_3, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("public boolean handleResourceMoved(org.eclipse.emf.ecore.resource.Resource resource, final org.eclipse.emf.common.util.URI newURI) {");
        _builder.newLine();
        _builder.append("\t\t");
        CharSequence _processChanges_2 = this.processChanges(it);
        _builder.append((Object)_processChanges_2, "\t\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("});");
        _builder.newLine();
        return _builder;
    }

    public CharSequence processChanges(GenNavigator it) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("for (java.util.Iterator<org.eclipse.emf.ecore.resource.Resource> it = myEditingDomain.getResourceSet().getResources().iterator(); it.hasNext();) {");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("org.eclipse.emf.ecore.resource.Resource nextResource = it.next();");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("nextResource.unload();");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        _builder.append("if (myViewer != null) {");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("myViewer.getControl().getDisplay().asyncExec(myViewerRefreshRunnable);");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        _builder.append("return true;");
        _builder.newLine();
        return _builder;
    }

    public CharSequence iContentProvider(GenNavigator it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _dispose = this.dispose(it);
        _builder.append((Object)_dispose);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        CharSequence _inputChanged = this.inputChanged(it);
        _builder.append((Object)_inputChanged);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        CharSequence _generatedMemberComment = this._common.generatedMemberComment();
        _builder.append((Object)_generatedMemberComment);
        _builder.newLineIfNotEmpty();
        _builder.append("void unloadAllResources() {");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("for (org.eclipse.emf.ecore.resource.Resource nextResource : myEditingDomain.getResourceSet().getResources()) {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("nextResource.unload();");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        CharSequence _generatedMemberComment_1 = this._common.generatedMemberComment();
        _builder.append((Object)_generatedMemberComment_1);
        _builder.newLineIfNotEmpty();
        _builder.append("void asyncRefresh() {");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("if (myViewer != null && !myViewer.getControl().isDisposed()) {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("myViewer.getControl().getDisplay().asyncExec(myViewerRefreshRunnable);");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence dispose(GenNavigator it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _generatedMemberComment = this._common.generatedMemberComment();
        _builder.append((Object)_generatedMemberComment);
        _builder.newLineIfNotEmpty();
        CharSequence _overrideC = this._codeStyle.overrideC(it);
        _builder.append((Object)_overrideC);
        _builder.newLineIfNotEmpty();
        _builder.append("public void dispose() {");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("myWorkspaceSynchronizer.dispose();");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("myWorkspaceSynchronizer = null;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("myViewerRefreshRunnable = null;");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("for (java.util.Iterator<org.eclipse.emf.ecore.resource.Resource> it = myEditingDomain.getResourceSet().getResources().iterator(); it.hasNext();) {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("org.eclipse.emf.ecore.resource.Resource resource = it.next();");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("resource.unload();");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("((org.eclipse.emf.transaction.TransactionalEditingDomain) myEditingDomain).dispose();");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("myEditingDomain = null;");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence inputChanged(GenNavigator it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _generatedMemberComment = this._common.generatedMemberComment();
        _builder.append((Object)_generatedMemberComment);
        _builder.newLineIfNotEmpty();
        CharSequence _overrideI = this._codeStyle.overrideI(it);
        _builder.append((Object)_overrideI);
        _builder.newLineIfNotEmpty();
        _builder.append("public void inputChanged(org.eclipse.jface.viewers.Viewer viewer, Object oldInput, Object newInput) {");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("myViewer = viewer;");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence iStructuredContentProvider(GenNavigator it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _generatedMemberComment = this._common.generatedMemberComment();
        _builder.append((Object)_generatedMemberComment);
        _builder.newLineIfNotEmpty();
        CharSequence _overrideC = this._codeStyle.overrideC(it);
        _builder.append((Object)_overrideC);
        _builder.newLineIfNotEmpty();
        _builder.append("public Object[] getElements(Object inputElement) {");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("return getChildren(inputElement);");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence iMementoAware(GenNavigator it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _generatedMemberComment = this._common.generatedMemberComment();
        _builder.append((Object)_generatedMemberComment);
        _builder.newLineIfNotEmpty();
        CharSequence _overrideI = this._codeStyle.overrideI(it);
        _builder.append((Object)_overrideI);
        _builder.newLineIfNotEmpty();
        _builder.append("public void restoreState(org.eclipse.ui.IMemento aMemento) {");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        CharSequence _generatedMemberComment_1 = this._common.generatedMemberComment();
        _builder.append((Object)_generatedMemberComment_1);
        _builder.newLineIfNotEmpty();
        CharSequence _overrideI_1 = this._codeStyle.overrideI(it);
        _builder.append((Object)_overrideI_1);
        _builder.newLineIfNotEmpty();
        _builder.append("public void saveState(org.eclipse.ui.IMemento aMemento) {");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence iCommonContentProvider(GenNavigator it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _generatedMemberComment = this._common.generatedMemberComment();
        _builder.append((Object)_generatedMemberComment);
        _builder.newLineIfNotEmpty();
        CharSequence _overrideI = this._codeStyle.overrideI(it);
        _builder.append((Object)_overrideI);
        _builder.newLineIfNotEmpty();
        _builder.append("public void init(org.eclipse.ui.navigator.ICommonContentExtensionSite aConfig) {");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence iTreeContentProvider(GenNavigator it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _children = this.getChildren(it);
        _builder.append((Object)_children);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        CharSequence _parent = this.getParent(it);
        _builder.append((Object)_parent);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        CharSequence _hasChildren = this.hasChildren(it);
        _builder.append((Object)_hasChildren);
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    public CharSequence getChildren(GenNavigator it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _generatedMemberComment = this._common.generatedMemberComment();
        _builder.append((Object)_generatedMemberComment);
        _builder.newLineIfNotEmpty();
        CharSequence _overrideI = this._codeStyle.overrideI(it);
        _builder.append((Object)_overrideI);
        _builder.newLineIfNotEmpty();
        _builder.append("public Object[] getChildren(Object parentElement) {");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("if (parentElement instanceof org.eclipse.core.resources.IFile) {");
        _builder.newLine();
        _builder.append("\t\t");
        CharSequence _fileChildren = this.getFileChildren(it);
        _builder.append((Object)_fileChildren, "\t\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t \t");
        _builder.append("} ");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t\t \t");
        _builder.append("if (parentElement instanceof ");
        CharSequence _qualifiedClassName = this.navigatorGroup.qualifiedClassName(it);
        _builder.append((Object)_qualifiedClassName, "\t\t \t");
        _builder.append(") {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        CharSequence _groupChildren = this.getGroupChildren(it);
        _builder.append((Object)_groupChildren, "\t\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("} ");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("if (parentElement instanceof ");
        CharSequence _qualifiedClassName_1 = this.xptNavigatorItem.qualifiedClassName(it);
        _builder.append((Object)_qualifiedClassName_1, "\t");
        _builder.append(") {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        CharSequence _itemChildren = this.getItemChildren(it);
        _builder.append((Object)_itemChildren, "\t\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        boolean _generateShortcutIcon = it.getEditorGen().getDiagram().generateShortcutIcon();
        if (_generateShortcutIcon) {
            _builder.append("\t");
            CharSequence _adaptableChildren = this.getAdaptableChildren(it);
            _builder.append((Object)_adaptableChildren, "\t");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("\t");
        CharSequence _otherChildren = this.getOtherChildren(it);
        _builder.append((Object)_otherChildren, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        CharSequence _viewChildren = this.getViewChildren(it);
        _builder.append((Object)_viewChildren);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        CharSequence _utilityMethods = this.utilityMethods(it);
        _builder.append((Object)_utilityMethods);
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    public CharSequence getParent(GenNavigator it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _generatedMemberComment = this._common.generatedMemberComment();
        _builder.append((Object)_generatedMemberComment);
        _builder.newLineIfNotEmpty();
        CharSequence _overrideI = this._codeStyle.overrideI(it);
        _builder.append((Object)_overrideI);
        _builder.newLineIfNotEmpty();
        _builder.append("public Object getParent(Object element) {");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("if (element instanceof ");
        CharSequence _qualifiedClassName = this.abstractNavigatorItem.qualifiedClassName(it);
        _builder.append((Object)_qualifiedClassName, "\t");
        _builder.append(") {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        CharSequence _qualifiedClassName_1 = this.abstractNavigatorItem.qualifiedClassName(it);
        _builder.append((Object)_qualifiedClassName_1, "\t\t");
        _builder.append(" abstractNavigatorItem = (");
        CharSequence _qualifiedClassName_2 = this.abstractNavigatorItem.qualifiedClassName(it);
        _builder.append((Object)_qualifiedClassName_2, "\t\t");
        _builder.append(") element;");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("return abstractNavigatorItem.getParent();");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("return null;");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence hasChildren(GenNavigator it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _generatedMemberComment = this._common.generatedMemberComment();
        _builder.append((Object)_generatedMemberComment);
        _builder.newLineIfNotEmpty();
        CharSequence _overrideI = this._codeStyle.overrideI(it);
        _builder.append((Object)_overrideI);
        _builder.newLineIfNotEmpty();
        _builder.append("public boolean hasChildren(Object element) {");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("return element instanceof org.eclipse.core.resources.IFile || getChildren(element).length > 0;");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence getFileChildren(GenNavigator it) {
        StringConcatenation _builder = new StringConcatenation();
        Iterable<GenNavigatorChildReference> references = this._utils_qvto.getChildReferencesFrom(it, null);
        _builder.newLineIfNotEmpty();
        CharSequence _fileResource = this.getFileResource(it);
        _builder.append((Object)_fileResource);
        _builder.newLineIfNotEmpty();
        _builder.append("java.util.Collection<Object> result = new java.util.ArrayList<");
        String _diamondOp = this._codeStyle.diamondOp((GenCommonBase)it.getEditorGen().getDiagram(), "Object");
        _builder.append(_diamondOp);
        _builder.append(">();");
        _builder.newLineIfNotEmpty();
        Set<String> _groupNames = this._utils_qvto.getGroupNames(references);
        for (String groupName : _groupNames) {
            CharSequence _initGroupVariables = this.initGroupVariables(groupName, it, references, "file", null);
            _builder.append((Object)_initGroupVariables);
            _builder.newLineIfNotEmpty();
        }
        _builder.append("java.util.List<org.eclipse.gmf.runtime.notation.View> topViews = new java.util.ArrayList<");
        String _diamondOp_1 = this._codeStyle.diamondOp((GenCommonBase)it.getEditorGen().getDiagram(), "org.eclipse.gmf.runtime.notation.View");
        _builder.append(_diamondOp_1);
        _builder.append(">(resource.getContents().size());");
        _builder.newLineIfNotEmpty();
        _builder.append("for (org.eclipse.emf.ecore.EObject o : resource.getContents()) {");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("if (o instanceof org.eclipse.gmf.runtime.notation.View) {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("topViews.add((org.eclipse.gmf.runtime.notation.View) o);");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        for (GenNavigatorChildReference ref : references) {
            CharSequence _addNavigatorItemsPrefix = this.addNavigatorItemsPrefix(ref);
            _builder.append((Object)_addNavigatorItemsPrefix);
            _builder.append("selectViewsByType(resource.getContents(), ");
            CharSequence _childViewType = this.getChildViewType(ref.getChild());
            _builder.append((Object)_childViewType);
            _builder.append(")");
            CharSequence _addNavigatorItemsSuffix = this.addNavigatorItemsSuffix(ref, "file", false);
            _builder.append((Object)_addNavigatorItemsSuffix);
            _builder.newLineIfNotEmpty();
        }
        Set<String> _groupNames_1 = this._utils_qvto.getGroupNames(references);
        for (String groupName_1 : _groupNames_1) {
            CharSequence _addGroups = this.addGroups(groupName_1, references);
            _builder.append((Object)_addGroups);
            _builder.newLineIfNotEmpty();
        }
        _builder.append("return result.toArray();");
        _builder.newLine();
        return _builder;
    }

    public CharSequence getFileResource(GenNavigator it) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("org.eclipse.core.resources.IFile file = (org.eclipse.core.resources.IFile) parentElement;");
        _builder.newLine();
        _builder.append("org.eclipse.emf.common.util.URI fileURI = org.eclipse.emf.common.util.URI.createPlatformResourceURI(file.getFullPath().toString(), true);");
        _builder.newLine();
        _builder.append("org.eclipse.emf.ecore.resource.Resource resource = myEditingDomain.getResourceSet().getResource(fileURI, true);");
        _builder.newLine();
        return _builder;
    }

    public CharSequence getGroupChildren(GenNavigator it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _qualifiedClassName = this.navigatorGroup.qualifiedClassName(it);
        _builder.append((Object)_qualifiedClassName);
        _builder.append(" group = (");
        CharSequence _qualifiedClassName_1 = this.navigatorGroup.qualifiedClassName(it);
        _builder.append((Object)_qualifiedClassName_1);
        _builder.append(") parentElement;");
        _builder.newLineIfNotEmpty();
        _builder.append("return group.getChildren();");
        _builder.newLine();
        return _builder;
    }

    public CharSequence getItemChildren(GenNavigator it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _qualifiedClassName = this.xptNavigatorItem.qualifiedClassName(it);
        _builder.append((Object)_qualifiedClassName);
        _builder.append(" navigatorItem = (");
        CharSequence _qualifiedClassName_1 = this.xptNavigatorItem.qualifiedClassName(it);
        _builder.append((Object)_qualifiedClassName_1);
        _builder.append(") parentElement;");
        _builder.newLineIfNotEmpty();
        _builder.append("if (navigatorItem.isLeaf() || !isOwnView(navigatorItem.getView())) {");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("return EMPTY_ARRAY;");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        _builder.append("return getViewChildren(navigatorItem.getView(), parentElement);");
        _builder.newLine();
        return _builder;
    }

    public CharSequence getAdaptableChildren(GenNavigator it) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("/*");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* Due to plugin.xml restrictions this code will be called only for views representing");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* shortcuts to this diagram elements created on other diagrams. ");
        _builder.newLine();
        _builder.append("*/ ");
        _builder.newLine();
        _builder.append("if (parentElement instanceof org.eclipse.core.runtime.IAdaptable) {");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("org.eclipse.gmf.runtime.notation.View view = (org.eclipse.gmf.runtime.notation.View) ((org.eclipse.core.runtime.IAdaptable) parentElement).getAdapter(org.eclipse.gmf.runtime.notation.View.class);");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("if (view != null) {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("return getViewChildren(view, parentElement);");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence getOtherChildren(GenNavigator it) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("return EMPTY_ARRAY;");
        _builder.newLine();
        return _builder;
    }

    public CharSequence getViewChildren(GenNavigator it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _generatedMemberComment = this._common.generatedMemberComment();
        _builder.append((Object)_generatedMemberComment);
        _builder.newLineIfNotEmpty();
        _builder.append("private Object[] getViewChildren(org.eclipse.gmf.runtime.notation.View view, Object parentElement) {");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("String vid = ");
        CharSequence _visualIDMethodCall = this.xptVisualIDRegistry.getVisualIDMethodCall(it.getEditorGen().getDiagram());
        _builder.append((Object)_visualIDMethodCall, "\t");
        _builder.append("(view);");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("if (vid != null) { ");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("switch (vid) {");
        _builder.newLine();
        Iterable<GenCommonBase> _navigatorContainerNodes = this._utils_qvto.getNavigatorContainerNodes(it);
        for (GenCommonBase node : _navigatorContainerNodes) {
            CharSequence _caseNavigatorNode = this.caseNavigatorNode(node, it);
            _builder.append((Object)_caseNavigatorNode);
            _builder.append("\t");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("\t\t\t\t\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("return EMPTY_ARRAY;");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence utilityMethods(GenNavigator it) {
        StringConcatenation _builder = new StringConcatenation();
        boolean _notEmpty = this._common_qvto.notEmpty(this._utils_qvto.getNavigatorContainerNodes(it));
        if (_notEmpty) {
            _builder.append("\t");
            CharSequence _generatedMemberComment = this._common.generatedMemberComment();
            _builder.append((Object)_generatedMemberComment, "\t");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("private java.util.Collection<?> getLinksSourceByType(java.util.Collection<?> edges, String type) {");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("java.util.Collection<?> result = new java.util.ArrayList<>();");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("for (java.util.Iterator<?> it = edges.iterator(); it.hasNext();) {");
            _builder.newLine();
            _builder.append("\t\t\t");
            _builder.append("org.eclipse.gmf.runtime.notation.Edge nextEdge = (org.eclipse.gmf.runtime.notation.Edge) it.next();");
            _builder.newLine();
            _builder.append("\t\t\t");
            _builder.append("org.eclipse.gmf.runtime.notation.View nextEdgeSource = nextEdge.getSource();");
            _builder.newLine();
            _builder.append("\t\t\t");
            _builder.append("if (type.equals(nextEdgeSource.getType()) && isOwnView(nextEdgeSource)) {");
            _builder.newLine();
            _builder.append("\t\t\t\t");
            _builder.append("result.add(nextEdgeSource);");
            _builder.newLine();
            _builder.append("\t\t\t");
            _builder.append("}");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("}");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("return result;");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("}");
            _builder.newLine();
            _builder.newLine();
            _builder.append("\t");
            CharSequence _generatedMemberComment_1 = this._common.generatedMemberComment();
            _builder.append((Object)_generatedMemberComment_1, "\t");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("private java.util.Collection<?> getLinksTargetByType(java.util.Collection<?> edges, String type) {");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("java.util.Collection<?> result = new java.util.ArrayList<>();");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("for (java.util.Iterator<?> it = edges.iterator(); it.hasNext();) {");
            _builder.newLine();
            _builder.append("\t\t\t");
            _builder.append("org.eclipse.gmf.runtime.notation.Edge nextEdge = (org.eclipse.gmf.runtime.notation.Edge) it.next();");
            _builder.newLine();
            _builder.append("\t\t\t");
            _builder.append("org.eclipse.gmf.runtime.notation.View nextEdgeTarget = nextEdge.getTarget();");
            _builder.newLine();
            _builder.append("\t\t\t");
            _builder.append("if (type.equals(nextEdgeTarget.getType()) && isOwnView(nextEdgeTarget)) {");
            _builder.newLine();
            _builder.append("\t\t\t\t");
            _builder.append("result.add(nextEdgeTarget);");
            _builder.newLine();
            _builder.append("\t\t\t");
            _builder.append("}");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("}");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("return result;");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("}");
            _builder.newLine();
            _builder.newLine();
            _builder.append("\t");
            CharSequence _generatedMemberComment_2 = this._common.generatedMemberComment();
            _builder.append((Object)_generatedMemberComment_2, "\t");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("private java.util.Collection<?> getOutgoingLinksByType(java.util.Collection<?> nodes, String type) {");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("java.util.Collection<?> result = new java.util.ArrayList<>();");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("for (java.util.Iterator<?> it = nodes.iterator(); it.hasNext();) {");
            _builder.newLine();
            _builder.append("\t\t\t");
            _builder.append("org.eclipse.gmf.runtime.notation.View nextNode = (org.eclipse.gmf.runtime.notation.View) it.next();");
            _builder.newLine();
            _builder.append("\t\t\t");
            _builder.append("result.addAll(selectViewsByType(nextNode.getSourceEdges(), type));");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("}");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("return result;");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("}");
            _builder.newLine();
            _builder.newLine();
            _builder.append("\t");
            CharSequence _generatedMemberComment_3 = this._common.generatedMemberComment();
            _builder.append((Object)_generatedMemberComment_3, "\t");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("private java.util.Collection<?> getIncomingLinksByType(java.util.Collection<?> nodes, String type) {");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("java.util.Collection<?> result = new java.util.ArrayList<>();");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("for (java.util.Iterator<?> it = nodes.iterator(); it.hasNext();) {");
            _builder.newLine();
            _builder.append("\t\t\t");
            _builder.append("org.eclipse.gmf.runtime.notation.View nextNode = (org.eclipse.gmf.runtime.notation.View) it.next();");
            _builder.newLine();
            _builder.append("\t\t\t");
            _builder.append("result.addAll(selectViewsByType(nextNode.getTargetEdges(), type));");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("}");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("return result;");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("}");
            _builder.newLine();
            _builder.newLine();
            _builder.append("\t");
            CharSequence _generatedMemberComment_4 = this._common.generatedMemberComment();
            _builder.append((Object)_generatedMemberComment_4, "\t");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("private java.util.Collection<?> getChildrenByType(java.util.Collection<?> nodes, String type) {");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("java.util.Collection<?> result = new java.util.ArrayList<>();");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("for (java.util.Iterator<?> it = nodes.iterator(); it.hasNext();) {");
            _builder.newLine();
            _builder.append("\t\t\t");
            _builder.append("org.eclipse.gmf.runtime.notation.View nextNode = (org.eclipse.gmf.runtime.notation.View) it.next();");
            _builder.newLine();
            _builder.append("\t\t\t");
            _builder.append("result.addAll(selectViewsByType(nextNode.getChildren(), type));");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("}");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("return result;");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("}");
            _builder.newLine();
            _builder.newLine();
            _builder.append("\t");
            CharSequence _generatedMemberComment_5 = this._common.generatedMemberComment();
            _builder.append((Object)_generatedMemberComment_5, "\t");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("private java.util.Collection<?> getDiagramLinksByType(java.util.Collection<?> diagrams, String type) {");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("java.util.Collection<?> result = new java.util.ArrayList<>();");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("for (java.util.Iterator<?> it = diagrams.iterator(); it.hasNext();) {");
            _builder.newLine();
            _builder.append("\t\t\t");
            _builder.append("org.eclipse.gmf.runtime.notation.Diagram nextDiagram = (org.eclipse.gmf.runtime.notation.Diagram) it.next();");
            _builder.newLine();
            _builder.append("\t\t\t");
            _builder.append("result.addAll(selectViewsByType(nextDiagram.getEdges(), type));");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("}");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("return result;");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("}");
            _builder.newLine();
            _builder.newLine();
            _builder.append("\t");
            CharSequence _generatedMemberComment_6 = this._common.generatedMemberComment();
            _builder.append((Object)_generatedMemberComment_6, "\t");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("private java.util.Collection<?> selectViewsByType(java.util.Collection<?> views, String type) {");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("java.util.Collection<?> result = new java.util.ArrayList<>();");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("for (java.util.Iterator<?> it = views.iterator(); it.hasNext();) {");
            _builder.newLine();
            _builder.append("\t\t\t");
            _builder.append("org.eclipse.gmf.runtime.notation.View nextView = (org.eclipse.gmf.runtime.notation.View) it.next();");
            _builder.newLine();
            _builder.append("\t\t\t");
            _builder.append("if (type.equals(nextView.getType()) && isOwnView(nextView)) {");
            _builder.newLine();
            _builder.append("\t\t\t\t");
            _builder.append("result.add(nextView);");
            _builder.newLine();
            _builder.append("\t\t\t");
            _builder.append("}");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("}");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("return result;");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("}");
            _builder.newLine();
            _builder.newLine();
            _builder.append("\t");
            CharSequence _generatedMemberComment_7 = this._common.generatedMemberComment();
            _builder.append((Object)_generatedMemberComment_7, "\t");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("private java.util.Collection<?> createNavigatorItems(java.util.Collection<?> views, Object parent, boolean isLeafs) {");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("java.util.Collection<?> result = new java.util.ArrayList<>();");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("for (java.util.Iterator<?> it = views.iterator(); it.hasNext();) {");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("result.add(new ");
            String _navigatorItemQualifiedClassName = it.getNavigatorItemQualifiedClassName();
            _builder.append(_navigatorItemQualifiedClassName, "\t\t");
            _builder.append("((org.eclipse.gmf.runtime.notation.View) it.next(), parent, isLeafs));");
            _builder.newLineIfNotEmpty();
            _builder.append("\t\t");
            _builder.append("}");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("return result;");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("}");
            _builder.newLine();
        }
        CharSequence _generatedMemberComment_8 = this._common.generatedMemberComment();
        _builder.append((Object)_generatedMemberComment_8);
        _builder.newLineIfNotEmpty();
        _builder.append("private boolean isOwnView(org.eclipse.gmf.runtime.notation.View view) {");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("return ");
        CharSequence _modelID = VisualIDRegistry.modelID(it.getEditorGen().getDiagram());
        _builder.append((Object)_modelID, "\t");
        _builder.append(".equals(");
        CharSequence _modelIDMethodCall = this.xptVisualIDRegistry.getModelIDMethodCall(it.getEditorGen().getDiagram());
        _builder.append((Object)_modelIDMethodCall, "\t");
        _builder.append("(view));");
        _builder.newLineIfNotEmpty();
        _builder.append("}");
        _builder.newLine();
        CharSequence _foreignShortcuts = this.getForeignShortcuts(it);
        _builder.append((Object)_foreignShortcuts);
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    public CharSequence getForeignShortcuts(GenNavigator it) {
        StringConcatenation _builder = new StringConcatenation();
        if (it.getEditorGen().getDiagram().generateCreateShortcutAction() && this._common_qvto.notEmpty(this._utils_qvto.getChildReferencesFrom(it, (GenCommonBase)it.getEditorGen().getDiagram()))) {
            CharSequence _generatedMemberComment = this._common.generatedMemberComment();
            _builder.append((Object)_generatedMemberComment);
            _builder.newLineIfNotEmpty();
            _builder.append("private java.util.Collection<?> getForeignShortcuts(org.eclipse.gmf.runtime.notation.Diagram diagram, Object parent) {");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("java.util.Collection<?> result = new java.util.ArrayList<>();");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("for (java.util.Iterator<?> it = diagram.getChildren().iterator(); it.hasNext();) {");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("org.eclipse.gmf.runtime.notation.View nextView = (org.eclipse.gmf.runtime.notation.View) it.next();");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("if (!isOwnView(nextView) && nextView.getEAnnotation(\"Shortcut\") != null) { ");
            CharSequence _nonNLS = this._common.nonNLS();
            _builder.append((Object)_nonNLS, "\t\t");
            _builder.newLineIfNotEmpty();
            _builder.append("\t\t\t");
            _builder.append("result.add(nextView);");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("}");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("}");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("return createNavigatorItems(result, parent, false);");
            _builder.newLine();
            _builder.append("}");
            _builder.newLine();
        }
        return _builder;
    }

    public CharSequence createEditingDomain(GenNavigator it) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("org.eclipse.emf.workspace.WorkspaceEditingDomainFactory.INSTANCE.createEditingDomain()");
        return _builder;
    }

    public CharSequence genAllMethodNodeCase(GenNavigator it) {
        StringConcatenation _builder = new StringConcatenation();
        Iterable<GenCommonBase> _navigatorContainerNodes = this._utils_qvto.getNavigatorContainerNodes(it);
        for (GenCommonBase container : _navigatorContainerNodes) {
            CharSequence _caseMethodNodeNode = this.caseMethodNodeNode(container, it);
            _builder.append((Object)_caseMethodNodeNode);
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    public CharSequence initGroupVariables(String groupName, GenNavigator navigator, Iterable<GenNavigatorChildReference> references, String parentVarName, GenCommonBase contextElement) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _qualifiedClassName = this.navigatorGroup.qualifiedClassName(navigator);
        _builder.append((Object)_qualifiedClassName);
        _builder.append(" ");
        String _validJavaIdentifier = CodeGenUtil.validJavaIdentifier((String)groupName);
        _builder.append(_validJavaIdentifier);
        _builder.append(" = new ");
        CharSequence _qualifiedClassName_1 = this.navigatorGroup.qualifiedClassName(navigator);
        _builder.append((Object)_qualifiedClassName_1);
        _builder.append("(");
        CharSequence _accessorCall = this.xptExternalizer.accessorCall(navigator.getEditorGen(), this.i18nKeyForGroup(groupName, contextElement));
        _builder.append((Object)_accessorCall);
        _builder.append(", \"");
        String _groupIcon = this._utils_qvto.getNavigatorReference(groupName, references).getGroupIcon();
        _builder.append(_groupIcon);
        _builder.append("\", ");
        _builder.append(parentVarName);
        _builder.append("); ");
        CharSequence _nonNLS = this._common.nonNLS(1);
        _builder.append((Object)_nonNLS);
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    @Localization
    public String i18nKeyForGroup(String groupName, GenCommonBase contextElement) {
        String _xifexpression = null;
        _xifexpression = contextElement != null ? this._common.stringUniqueIdentifier(contextElement) : "File";
        String _plus = "NavigatorGroupName." + _xifexpression;
        String _plus_1 = String.valueOf(_plus) + ".";
        String _validJavaIdentifier = CodeGenUtil.validJavaIdentifier((String)groupName);
        return String.valueOf(_plus_1) + _validJavaIdentifier;
    }

    public CharSequence addNavigatorItemsPrefix(GenNavigatorChildReference it) {
        StringConcatenation _builder = new StringConcatenation();
        boolean _isInsideGroup = it.isInsideGroup();
        if (_isInsideGroup) {
            String _validJavaIdentifier = CodeGenUtil.validJavaIdentifier((String)it.getGroupName());
            _builder.append(_validJavaIdentifier);
            _builder.append(".addChildren(");
        } else {
            _builder.append("result.addAll(");
        }
        _builder.append("createNavigatorItems(");
        return _builder;
    }

    public CharSequence addNavigatorItemsSuffix(GenNavigatorChildReference it, String parentVarName, boolean isLeaf) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append(", ");
        boolean _isInsideGroup = it.isInsideGroup();
        if (_isInsideGroup) {
            String _validJavaIdentifier = CodeGenUtil.validJavaIdentifier((String)it.getGroupName());
            _builder.append(_validJavaIdentifier);
        } else {
            _builder.append(parentVarName);
        }
        _builder.append(", ");
        _builder.append((Object)isLeaf);
        _builder.append("));");
        return _builder;
    }

    public CharSequence addGroups(String groupName, Iterable<GenNavigatorChildReference> references) {
        StringConcatenation _builder = new StringConcatenation();
        GenNavigatorChildReference ref = this._utils_qvto.getNavigatorReference(groupName, references);
        _builder.newLineIfNotEmpty();
        boolean _isHideIfEmpty = ref.isHideIfEmpty();
        if (_isHideIfEmpty) {
            _builder.append("if (!");
            String _validJavaIdentifier = CodeGenUtil.validJavaIdentifier((String)groupName);
            _builder.append(_validJavaIdentifier);
            _builder.append(".isEmpty()) {");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("result.add(");
            String _validJavaIdentifier_1 = CodeGenUtil.validJavaIdentifier((String)groupName);
            _builder.append(_validJavaIdentifier_1, "\t");
            _builder.append(");");
            _builder.newLineIfNotEmpty();
            _builder.append("}");
            _builder.newLine();
        } else {
            _builder.append("result.add(");
            String _validJavaIdentifier_2 = CodeGenUtil.validJavaIdentifier((String)groupName);
            _builder.append(_validJavaIdentifier_2);
            _builder.append(");");
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    protected CharSequence _getChildViewType(GenDiagram it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _modelID = VisualIDRegistry.modelID(it);
        _builder.append((Object)_modelID);
        return _builder;
    }

    protected CharSequence _getChildViewType(GenCommonBase it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _typeMethodCall = this.xptVisualIDRegistry.typeMethodCall(it);
        _builder.append((Object)_typeMethodCall);
        return _builder;
    }

    public CharSequence caseNavigatorNode(GenCommonBase it, GenNavigator navigator) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("case ");
        CharSequence _visualID = VisualIDRegistry.visualID(it);
        _builder.append((Object)_visualID);
        _builder.append(": {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("//modification of the template to avoid mistake of 65kb.");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("return getViewChildrenFor");
        String _editPartClassName = it.getEditPartClassName();
        _builder.append(_editPartClassName, "\t\t");
        _builder.append("(view, parentElement);");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    protected CharSequence _nailedDownVariable(GenCommonBase it, String varName, String expressionToCast) {
        StringConcatenation _builder = new StringConcatenation();
        return _builder;
    }

    protected CharSequence _nailedDownVariable(GenLink it, String varName, String expressionToCast) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("org.eclipse.gmf.runtime.notation.Edge ");
        _builder.append(varName);
        _builder.append(" = (org.eclipse.gmf.runtime.notation.Edge) ");
        _builder.append(expressionToCast);
        _builder.append(";");
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    protected CharSequence _nailedDownVariable(GenNode it, String varName, String expressionToCast) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("org.eclipse.gmf.runtime.notation.Node ");
        _builder.append(varName);
        _builder.append(" = (org.eclipse.gmf.runtime.notation.Node) ");
        _builder.append(expressionToCast);
        _builder.append(";");
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    protected CharSequence _nailedDownVariable(GenDiagram it, String varName, String expressionToCast) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("org.eclipse.gmf.runtime.notation.Diagram ");
        _builder.append(varName);
        _builder.append(" = (org.eclipse.gmf.runtime.notation.Diagram) ");
        _builder.append(expressionToCast);
        _builder.append(";");
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    protected CharSequence _addForeignShortcuts(GenDiagram it) {
        StringConcatenation _builder = new StringConcatenation();
        boolean _generateCreateShortcutAction = it.generateCreateShortcutAction();
        if (_generateCreateShortcutAction) {
            _builder.append("result.addAll(getForeignShortcuts((org.eclipse.gmf.runtime.notation.Diagram) view, parentElement));");
            _builder.newLine();
        }
        return _builder;
    }

    protected CharSequence _addForeignShortcuts(GenCommonBase it) {
        StringConcatenation _builder = new StringConcatenation();
        return _builder;
    }

    protected CharSequence _childrenMethodName(GenLink it, GenNavigatorReferenceType referenceType, GenNavigatorPathSegment segment) {
        StringConcatenation _builder = new StringConcatenation();
        boolean _equals = Objects.equal((Object)referenceType, (Object)GenNavigatorReferenceType.OUT_TARGET_LITERAL);
        if (_equals) {
            _builder.append("getLinksTargetByType");
        } else {
            _builder.append("getLinksSourceByType");
        }
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    protected CharSequence _childrenMethodName(GenCommonBase it, GenNavigatorReferenceType referenceType, GenNavigatorPathSegment segment) {
        StringConcatenation _builder = new StringConcatenation();
        boolean _equals = Objects.equal((Object)referenceType, (Object)GenNavigatorReferenceType.OUT_TARGET_LITERAL);
        if (_equals) {
            _builder.append("getOutgoingLinksByType");
        } else {
            boolean _equals_1 = Objects.equal((Object)referenceType, (Object)GenNavigatorReferenceType.IN_SOURCE_LITERAL);
            if (_equals_1) {
                _builder.append("getIncomingLinksByType");
            } else if (this._common_qvto.oclIsKindOf(segment.getFrom(), GenDiagram.class) && this._common_qvto.oclIsKindOf(segment.getTo(), GenLink.class)) {
                _builder.append("getDiagramLinksByType");
            } else {
                _builder.append("getChildrenByType");
            }
        }
        return _builder;
    }

    @Localization
    public CharSequence i18nAccessors(GenNavigator it) {
        StringConcatenation _builder = new StringConcatenation();
        Set<String> _groupNames = this._utils_qvto.getGroupNames(this._utils_qvto.getChildReferencesFrom(it, null));
        for (String groupName : _groupNames) {
            CharSequence _internal_i18nAccessors = this.internal_i18nAccessors(groupName, null);
            _builder.append((Object)_internal_i18nAccessors);
            _builder.newLineIfNotEmpty();
        }
        Iterable<GenCommonBase> _navigatorContainerNodes = this._utils_qvto.getNavigatorContainerNodes(it);
        for (GenCommonBase contextElement : _navigatorContainerNodes) {
            Set<String> _groupNames_1 = this._utils_qvto.getGroupNames(this._utils_qvto.getChildReferencesFrom(it, contextElement));
            for (String groupName_1 : _groupNames_1) {
                CharSequence _internal_i18nAccessors_1 = this.internal_i18nAccessors(groupName_1, contextElement);
                _builder.append((Object)_internal_i18nAccessors_1);
                _builder.newLineIfNotEmpty();
            }
        }
        return _builder;
    }

    @Localization
    public CharSequence internal_i18nAccessors(String groupName, GenCommonBase contextElement) {
        StringConcatenation _builder = new StringConcatenation();
        if (groupName != null) {
            CharSequence _accessorField = this.xptExternalizer.accessorField(this.i18nKeyForGroup(groupName, contextElement));
            _builder.append((Object)_accessorField);
        }
        return _builder;
    }

    @Localization
    public CharSequence i18nValues(GenNavigator it) {
        StringConcatenation _builder = new StringConcatenation();
        Set<String> _groupNames = this._utils_qvto.getGroupNames(this._utils_qvto.getChildReferencesFrom(it, null));
        for (String groupName : _groupNames) {
            CharSequence _internal_i18nValues = this.internal_i18nValues(groupName, null);
            _builder.append((Object)_internal_i18nValues);
            _builder.newLineIfNotEmpty();
        }
        Iterable<GenCommonBase> _navigatorContainerNodes = this._utils_qvto.getNavigatorContainerNodes(it);
        for (GenCommonBase contextElement : _navigatorContainerNodes) {
            Set<String> _groupNames_1 = this._utils_qvto.getGroupNames(this._utils_qvto.getChildReferencesFrom(it, contextElement));
            for (String groupName_1 : _groupNames_1) {
                CharSequence _internal_i18nValues_1 = this.internal_i18nValues(groupName_1, contextElement);
                _builder.append((Object)_internal_i18nValues_1);
                _builder.newLineIfNotEmpty();
            }
        }
        return _builder;
    }

    @Localization
    public CharSequence internal_i18nValues(String groupName, GenCommonBase contextElement) {
        StringConcatenation _builder = new StringConcatenation();
        if (groupName != null) {
            CharSequence _messageEntry = this.xptExternalizer.messageEntry(this.i18nKeyForGroup(groupName, contextElement), groupName);
            _builder.append((Object)_messageEntry);
        }
        return _builder;
    }

    public CharSequence caseMethodNodeNode(GenCommonBase it, GenNavigator navigator) {
        boolean _not;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("/**");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*Papyrus Template");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*this method is a modification of gmf code in order to avoid  getViewChidreen() method becoming greater than 64kb.");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*@generated");
        _builder.newLine();
        _builder.append("**/");
        _builder.newLine();
        _builder.append("private Object[] getViewChildrenFor");
        String _editPartClassName = it.getEditPartClassName();
        _builder.append(_editPartClassName);
        _builder.append("(org.eclipse.gmf.runtime.notation.View view, Object parentElement){");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("java.util.Collection<?> result = new java.util.ArrayList<>();");
        _builder.newLine();
        _builder.append("\t");
        CharSequence _addForeignShortcuts = this.addForeignShortcuts(it);
        _builder.append((Object)_addForeignShortcuts, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        Iterable<GenNavigatorChildReference> _references = this._utils_qvto.getChildReferencesFrom(navigator, it);
        _builder.newLineIfNotEmpty();
        Set<String> _groupNames = this._utils_qvto.getGroupNames(_references);
        for (String groupNames : _groupNames) {
            _builder.append("\t");
            CharSequence _initGroupVariables = this.initGroupVariables(groupNames, navigator, _references, "parentElement", it);
            _builder.append((Object)_initGroupVariables, "\t");
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        boolean _isEmpty = IterableExtensions.isEmpty(_references);
        boolean bl = _not = !_isEmpty;
        if (_not) {
            int _size = IterableExtensions.size(_references);
            IntegerRange _upTo = new IntegerRange(1, _size);
            for (Integer referencesIterator : _upTo) {
                boolean _not_1;
                _builder.append("\t");
                Iterable<GenNavigatorChildReference> _converted__references = _references;
                GenNavigatorChildReference reference = ((GenNavigatorChildReference[])Conversions.unwrapArray(_converted__references, GenNavigatorChildReference.class))[referencesIterator - 1];
                _builder.newLineIfNotEmpty();
                boolean _isEmpty_1 = reference.findConnectionPaths().isEmpty();
                boolean bl2 = _not_1 = !_isEmpty_1;
                if (!_not_1) continue;
                int _size_1 = reference.findConnectionPaths().size();
                IntegerRange _upTo_1 = new IntegerRange(1, _size_1);
                for (Integer pathsIterator : _upTo_1) {
                    boolean _not_2;
                    _builder.append("\t");
                    GenNavigatorPath path = (GenNavigatorPath)reference.findConnectionPaths().get(pathsIterator - 1);
                    _builder.newLineIfNotEmpty();
                    boolean _isEmpty_2 = path.getSegments().isEmpty();
                    boolean bl3 = _not_2 = !_isEmpty_2;
                    if (_not_2) {
                        int _size_2 = path.getSegments().size();
                        IntegerRange _upTo_2 = new IntegerRange(1, _size_2);
                        for (Integer segmentsIterator : _upTo_2) {
                            _builder.append("\t");
                            GenNavigatorPathSegment segment = (GenNavigatorPathSegment)path.getSegments().get(segmentsIterator - 1);
                            _builder.newLineIfNotEmpty();
                            _builder.append("\t");
                            if (referencesIterator == 1 && pathsIterator == 1 && segmentsIterator == 1) {
                                _builder.append("java.util.Collection<?> ");
                            }
                            _builder.newLineIfNotEmpty();
                            _builder.append("\t");
                            _builder.append("\t");
                            _builder.append("connectedViews = ");
                            CharSequence _childrenMethodName = this.childrenMethodName(segment.getFrom(), reference.getReferenceType(), segment);
                            _builder.append((Object)_childrenMethodName, "\t\t");
                            _builder.append("(");
                            if (segmentsIterator == 1) {
                                _builder.append("java.util.Collections.singleton(view)");
                            } else {
                                _builder.append("connectedViews");
                            }
                            _builder.append(", ");
                            CharSequence _typeMethodCall = this.xptVisualIDRegistry.typeMethodCall(segment.getTo());
                            _builder.append((Object)_typeMethodCall, "\t\t");
                            _builder.append(");");
                            _builder.newLineIfNotEmpty();
                        }
                    }
                    _builder.append("\t");
                    CharSequence _addNavigatorItemsPrefix = this.addNavigatorItemsPrefix(reference);
                    _builder.append((Object)_addNavigatorItemsPrefix, "\t");
                    _builder.append("connectedViews");
                    GenNavigatorReferenceType _referenceType = reference.getReferenceType();
                    boolean _notEquals = !Objects.equal((Object)_referenceType, (Object)GenNavigatorReferenceType.CHILDREN_LITERAL);
                    CharSequence _addNavigatorItemsSuffix = this.addNavigatorItemsSuffix(reference, "parentElement", _notEquals);
                    _builder.append((Object)_addNavigatorItemsSuffix, "\t");
                    _builder.newLineIfNotEmpty();
                }
            }
        }
        _builder.newLine();
        Set<String> _groupNames_1 = this._utils_qvto.getGroupNames(_references);
        for (String groupNames_1 : _groupNames_1) {
            _builder.append("\t");
            CharSequence _addGroups = this.addGroups(groupNames_1, _references);
            _builder.append((Object)_addGroups, "\t");
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        _builder.append("\t");
        _builder.append("return result.toArray();");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence getChildViewType(GenCommonBase it) {
        if (it instanceof GenDiagram) {
            return this._getChildViewType((GenDiagram)it);
        }
        if (it != null) {
            return this._getChildViewType(it);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(it).toString());
    }

    public CharSequence nailedDownVariable(GenCommonBase it, String varName, String expressionToCast) {
        if (it instanceof GenNode) {
            return this._nailedDownVariable((GenNode)it, varName, expressionToCast);
        }
        if (it instanceof GenDiagram) {
            return this._nailedDownVariable((GenDiagram)it, varName, expressionToCast);
        }
        if (it instanceof GenLink) {
            return this._nailedDownVariable((GenLink)it, varName, expressionToCast);
        }
        if (it != null) {
            return this._nailedDownVariable(it, varName, expressionToCast);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(it, varName, expressionToCast).toString());
    }

    public CharSequence addForeignShortcuts(GenCommonBase it) {
        if (it instanceof GenDiagram) {
            return this._addForeignShortcuts((GenDiagram)it);
        }
        if (it != null) {
            return this._addForeignShortcuts(it);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(it).toString());
    }

    public CharSequence childrenMethodName(GenCommonBase it, GenNavigatorReferenceType referenceType, GenNavigatorPathSegment segment) {
        if (it instanceof GenLink) {
            return this._childrenMethodName((GenLink)it, referenceType, segment);
        }
        if (it != null) {
            return this._childrenMethodName(it, referenceType, segment);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(it, referenceType, segment).toString());
    }
}

