/**
 * Copyright (c) 2015 CEA LIST and others.
 * 
 *  All rights reserved. This program and the accompanying materials
 *  are made available under the terms of the Eclipse Public License 2.0
 *  which accompanies this distribution, and is available at
 *  https://www.eclipse.org/legal/epl-2.0/
 * 
 *  SPDX-License-Identifier: EPL-2.0
 * 
 *  Contributors:
 *   CEA LIST - Initial API and implementation
 */
package org.eclipse.papyrus.gmf.codegen.genextension.provider;

import java.util.ArrayList;
import java.util.Collection;

import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;

import org.eclipse.emf.edit.provider.ChangeNotifier;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IChangeNotifier;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;

import org.eclipse.papyrus.gmf.codegen.genextension.util.GenExtensionAdapterFactory;

/**
 * This is the factory that is used to provide the interfaces needed to support Viewers.
 * The adapters generated by this factory convert EMF adapter notifications into calls to {@link #fireNotifyChanged fireNotifyChanged}.
 * The adapters also support Eclipse property sheets.
 * Note that most of the adapters are shared among multiple instances.
 * <!-- begin-user-doc -->
 * <!-- end-user-doc -->
 * @generated
 */
public class GenExtensionItemProviderAdapterFactory extends GenExtensionAdapterFactory implements ComposeableAdapterFactory, IChangeNotifier {
	/**
	 * This keeps track of the root adapter factory that delegates to this adapter factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ComposedAdapterFactory parentAdapterFactory;

	/**
	 * This is used to implement {@link org.eclipse.emf.edit.provider.IChangeNotifier}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IChangeNotifier changeNotifier = new ChangeNotifier();

	/**
	 * This keeps track of all the supported types checked by {@link #isFactoryForType isFactoryForType}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Collection<Object> supportedTypes = new ArrayList<Object>();

	/**
	 * This constructs an instance.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public GenExtensionItemProviderAdapterFactory() {
		supportedTypes.add(IEditingDomainItemProvider.class);
		supportedTypes.add(IStructuredItemContentProvider.class);
		supportedTypes.add(ITreeItemContentProvider.class);
		supportedTypes.add(IItemLabelProvider.class);
		supportedTypes.add(IItemPropertySource.class);
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.gmf.codegen.genextension.ExtendedGenView} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ExtendedGenViewItemProvider extendedGenViewItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.gmf.codegen.genextension.ExtendedGenView}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createExtendedGenViewAdapter() {
		if (extendedGenViewItemProvider == null) {
			extendedGenViewItemProvider = new ExtendedGenViewItemProvider(this);
		}

		return extendedGenViewItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.gmf.codegen.genextension.CommentedElement} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected CommentedElementItemProvider commentedElementItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.gmf.codegen.genextension.CommentedElement}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createCommentedElementAdapter() {
		if (commentedElementItemProvider == null) {
			commentedElementItemProvider = new CommentedElementItemProvider(this);
		}

		return commentedElementItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.gmf.codegen.genextension.PropertyRefreshHook} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected PropertyRefreshHookItemProvider propertyRefreshHookItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.gmf.codegen.genextension.PropertyRefreshHook}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createPropertyRefreshHookAdapter() {
		if (propertyRefreshHookItemProvider == null) {
			propertyRefreshHookItemProvider = new PropertyRefreshHookItemProvider(this);
		}

		return propertyRefreshHookItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.gmf.codegen.genextension.ExternalHook} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ExternalHookItemProvider externalHookItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.gmf.codegen.genextension.ExternalHook}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createExternalHookAdapter() {
		if (externalHookItemProvider == null) {
			externalHookItemProvider = new ExternalHookItemProvider(this);
		}

		return externalHookItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.gmf.codegen.genextension.SpecificLocator} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected SpecificLocatorItemProvider specificLocatorItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.gmf.codegen.genextension.SpecificLocator}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createSpecificLocatorAdapter() {
		if (specificLocatorItemProvider == null) {
			specificLocatorItemProvider = new SpecificLocatorItemProvider(this);
		}

		return specificLocatorItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.gmf.codegen.genextension.PapyrusExtensionRootNode} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected PapyrusExtensionRootNodeItemProvider papyrusExtensionRootNodeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.gmf.codegen.genextension.PapyrusExtensionRootNode}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createPapyrusExtensionRootNodeAdapter() {
		if (papyrusExtensionRootNodeItemProvider == null) {
			papyrusExtensionRootNodeItemProvider = new PapyrusExtensionRootNodeItemProvider(this);
		}

		return papyrusExtensionRootNodeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.gmf.codegen.genextension.AlternateCanvas} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected AlternateCanvasItemProvider alternateCanvasItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.gmf.codegen.genextension.AlternateCanvas}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createAlternateCanvasAdapter() {
		if (alternateCanvasItemProvider == null) {
			alternateCanvasItemProvider = new AlternateCanvasItemProvider(this);
		}

		return alternateCanvasItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.gmf.codegen.genextension.AlternateGenTopLevelNode} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected AlternateGenTopLevelNodeItemProvider alternateGenTopLevelNodeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.gmf.codegen.genextension.AlternateGenTopLevelNode}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createAlternateGenTopLevelNodeAdapter() {
		if (alternateGenTopLevelNodeItemProvider == null) {
			alternateGenTopLevelNodeItemProvider = new AlternateGenTopLevelNodeItemProvider(this);
		}

		return alternateGenTopLevelNodeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.gmf.codegen.genextension.AlternateGenLink} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected AlternateGenLinkItemProvider alternateGenLinkItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.gmf.codegen.genextension.AlternateGenLink}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createAlternateGenLinkAdapter() {
		if (alternateGenLinkItemProvider == null) {
			alternateGenLinkItemProvider = new AlternateGenLinkItemProvider(this);
		}

		return alternateGenLinkItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.gmf.codegen.genextension.MutatingCanvas} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected MutatingCanvasItemProvider mutatingCanvasItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.gmf.codegen.genextension.MutatingCanvas}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createMutatingCanvasAdapter() {
		if (mutatingCanvasItemProvider == null) {
			mutatingCanvasItemProvider = new MutatingCanvasItemProvider(this);
		}

		return mutatingCanvasItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.gmf.codegen.genextension.OwnedEditpart} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected OwnedEditpartItemProvider ownedEditpartItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.gmf.codegen.genextension.OwnedEditpart}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createOwnedEditpartAdapter() {
		if (ownedEditpartItemProvider == null) {
			ownedEditpartItemProvider = new OwnedEditpartItemProvider(this);
		}

		return ownedEditpartItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.gmf.codegen.genextension.SpecificDiagramUpdater} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected SpecificDiagramUpdaterItemProvider specificDiagramUpdaterItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.gmf.codegen.genextension.SpecificDiagramUpdater}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createSpecificDiagramUpdaterAdapter() {
		if (specificDiagramUpdaterItemProvider == null) {
			specificDiagramUpdaterItemProvider = new SpecificDiagramUpdaterItemProvider(this);
		}

		return specificDiagramUpdaterItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.gmf.codegen.genextension.GenNodeConstraint} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected GenNodeConstraintItemProvider genNodeConstraintItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.gmf.codegen.genextension.GenNodeConstraint}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createGenNodeConstraintAdapter() {
		if (genNodeConstraintItemProvider == null) {
			genNodeConstraintItemProvider = new GenNodeConstraintItemProvider(this);
		}

		return genNodeConstraintItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.gmf.codegen.genextension.SpecificLocatorExternalLabel} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected SpecificLocatorExternalLabelItemProvider specificLocatorExternalLabelItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.gmf.codegen.genextension.SpecificLocatorExternalLabel}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createSpecificLocatorExternalLabelAdapter() {
		if (specificLocatorExternalLabelItemProvider == null) {
			specificLocatorExternalLabelItemProvider = new SpecificLocatorExternalLabelItemProvider(this);
		}

		return specificLocatorExternalLabelItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.gmf.codegen.genextension.AdditionalEditPartCandies} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected AdditionalEditPartCandiesItemProvider additionalEditPartCandiesItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.gmf.codegen.genextension.AdditionalEditPartCandies}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createAdditionalEditPartCandiesAdapter() {
		if (additionalEditPartCandiesItemProvider == null) {
			additionalEditPartCandiesItemProvider = new AdditionalEditPartCandiesItemProvider(this);
		}

		return additionalEditPartCandiesItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.gmf.codegen.genextension.EditPartUsingDeleteService} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected EditPartUsingDeleteServiceItemProvider editPartUsingDeleteServiceItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.gmf.codegen.genextension.EditPartUsingDeleteService}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createEditPartUsingDeleteServiceAdapter() {
		if (editPartUsingDeleteServiceItemProvider == null) {
			editPartUsingDeleteServiceItemProvider = new EditPartUsingDeleteServiceItemProvider(this);
		}

		return editPartUsingDeleteServiceItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.gmf.codegen.genextension.EditPartUsingReorientService} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected EditPartUsingReorientServiceItemProvider editPartUsingReorientServiceItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.gmf.codegen.genextension.EditPartUsingReorientService}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createEditPartUsingReorientServiceAdapter() {
		if (editPartUsingReorientServiceItemProvider == null) {
			editPartUsingReorientServiceItemProvider = new EditPartUsingReorientServiceItemProvider(this);
		}

		return editPartUsingReorientServiceItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.gmf.codegen.genextension.LabelVisibilityPreference} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected LabelVisibilityPreferenceItemProvider labelVisibilityPreferenceItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.gmf.codegen.genextension.LabelVisibilityPreference}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createLabelVisibilityPreferenceAdapter() {
		if (labelVisibilityPreferenceItemProvider == null) {
			labelVisibilityPreferenceItemProvider = new LabelVisibilityPreferenceItemProvider(this);
		}

		return labelVisibilityPreferenceItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.gmf.codegen.genextension.CompartmentVisibilityPreference} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected CompartmentVisibilityPreferenceItemProvider compartmentVisibilityPreferenceItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.gmf.codegen.genextension.CompartmentVisibilityPreference}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createCompartmentVisibilityPreferenceAdapter() {
		if (compartmentVisibilityPreferenceItemProvider == null) {
			compartmentVisibilityPreferenceItemProvider = new CompartmentVisibilityPreferenceItemProvider(this);
		}

		return compartmentVisibilityPreferenceItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.gmf.codegen.genextension.CompartmentTitleVisibilityPreference} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected CompartmentTitleVisibilityPreferenceItemProvider compartmentTitleVisibilityPreferenceItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.gmf.codegen.genextension.CompartmentTitleVisibilityPreference}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createCompartmentTitleVisibilityPreferenceAdapter() {
		if (compartmentTitleVisibilityPreferenceItemProvider == null) {
			compartmentTitleVisibilityPreferenceItemProvider = new CompartmentTitleVisibilityPreferenceItemProvider(this);
		}

		return compartmentTitleVisibilityPreferenceItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.gmf.codegen.genextension.ConstrainedByReferenceCompartmentItemSemanticEditPolicy} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ConstrainedByReferenceCompartmentItemSemanticEditPolicyItemProvider constrainedByReferenceCompartmentItemSemanticEditPolicyItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.gmf.codegen.genextension.ConstrainedByReferenceCompartmentItemSemanticEditPolicy}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createConstrainedByReferenceCompartmentItemSemanticEditPolicyAdapter() {
		if (constrainedByReferenceCompartmentItemSemanticEditPolicyItemProvider == null) {
			constrainedByReferenceCompartmentItemSemanticEditPolicyItemProvider = new ConstrainedByReferenceCompartmentItemSemanticEditPolicyItemProvider(this);
		}

		return constrainedByReferenceCompartmentItemSemanticEditPolicyItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.gmf.codegen.genextension.GenerateUsingElementTypeCreationCommand} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected GenerateUsingElementTypeCreationCommandItemProvider generateUsingElementTypeCreationCommandItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.gmf.codegen.genextension.GenerateUsingElementTypeCreationCommand}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createGenerateUsingElementTypeCreationCommandAdapter() {
		if (generateUsingElementTypeCreationCommandItemProvider == null) {
			generateUsingElementTypeCreationCommandItemProvider = new GenerateUsingElementTypeCreationCommandItemProvider(this);
		}

		return generateUsingElementTypeCreationCommandItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.gmf.codegen.genextension.CustomDiagramUpdaterSingleton} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected CustomDiagramUpdaterSingletonItemProvider customDiagramUpdaterSingletonItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.gmf.codegen.genextension.CustomDiagramUpdaterSingleton}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createCustomDiagramUpdaterSingletonAdapter() {
		if (customDiagramUpdaterSingletonItemProvider == null) {
			customDiagramUpdaterSingletonItemProvider = new CustomDiagramUpdaterSingletonItemProvider(this);
		}

		return customDiagramUpdaterSingletonItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.gmf.codegen.genextension.SpecificNodePlate} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected SpecificNodePlateItemProvider specificNodePlateItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.gmf.codegen.genextension.SpecificNodePlate}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createSpecificNodePlateAdapter() {
		if (specificNodePlateItemProvider == null) {
			specificNodePlateItemProvider = new SpecificNodePlateItemProvider(this);
		}

		return specificNodePlateItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.gmf.codegen.genextension.GenVisualTypeProvider} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected GenVisualTypeProviderItemProvider genVisualTypeProviderItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.gmf.codegen.genextension.GenVisualTypeProvider}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createGenVisualTypeProviderAdapter() {
		if (genVisualTypeProviderItemProvider == null) {
			genVisualTypeProviderItemProvider = new GenVisualTypeProviderItemProvider(this);
		}

		return genVisualTypeProviderItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.gmf.codegen.genextension.VisualIDOverride} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected VisualIDOverrideItemProvider visualIDOverrideItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.gmf.codegen.genextension.VisualIDOverride}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createVisualIDOverrideAdapter() {
		if (visualIDOverrideItemProvider == null) {
			visualIDOverrideItemProvider = new VisualIDOverrideItemProvider(this);
		}

		return visualIDOverrideItemProvider;
	}

	/**
	 * This returns the root adapter factory that contains this factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public ComposeableAdapterFactory getRootAdapterFactory() {
		return parentAdapterFactory == null ? this : parentAdapterFactory.getRootAdapterFactory();
	}

	/**
	 * This sets the composed adapter factory that contains this factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setParentAdapterFactory(ComposedAdapterFactory parentAdapterFactory) {
		this.parentAdapterFactory = parentAdapterFactory;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean isFactoryForType(Object type) {
		return supportedTypes.contains(type) || super.isFactoryForType(type);
	}

	/**
	 * This implementation substitutes the factory itself as the key for the adapter.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter adapt(Notifier notifier, Object type) {
		return super.adapt(notifier, this);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object adapt(Object object, Object type) {
		if (isFactoryForType(type)) {
			Object adapter = super.adapt(object, type);
			if (!(type instanceof Class<?>) || (((Class<?>)type).isInstance(adapter))) {
				return adapter;
			}
		}

		return null;
	}

	/**
	 * This adds a listener.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void addListener(INotifyChangedListener notifyChangedListener) {
		changeNotifier.addListener(notifyChangedListener);
	}

	/**
	 * This removes a listener.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void removeListener(INotifyChangedListener notifyChangedListener) {
		changeNotifier.removeListener(notifyChangedListener);
	}

	/**
	 * This delegates to {@link #changeNotifier} and to {@link #parentAdapterFactory}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void fireNotifyChanged(Notification notification) {
		changeNotifier.fireNotifyChanged(notification);

		if (parentAdapterFactory != null) {
			parentAdapterFactory.fireNotifyChanged(notification);
		}
	}

}
