/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.textedit.xtext.custom;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.common.ui.services.parser.IParser;
import org.eclipse.gmf.runtime.emf.core.util.EObjectAdapter;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.emf.gmf.command.GMFtoEMFCommandWrapper;
import org.eclipse.papyrus.infra.emf.utils.ServiceUtilsForEObject;
import org.eclipse.papyrus.infra.gmfdiag.extensionpoints.editors.configuration.ICustomDirectEditorConfiguration;
import org.eclipse.papyrus.infra.textedit.xtext.Activator;
import org.eclipse.papyrus.infra.textedit.xtext.custom.PapyrusXTextMarker;
import org.eclipse.papyrus.infra.textedit.xtext.nested.editor.NestedXTextEditorInput;
import org.eclipse.xtext.ui.editor.model.XtextDocumentProvider;

public class PapyrusXTextDocumentProvider
extends XtextDocumentProvider {
    protected void doSaveDocument(IProgressMonitor monitor, Object element, IDocument document, boolean overwrite) throws CoreException {
        if (element instanceof NestedXTextEditorInput) {
            this.doSaveDocument(monitor, (NestedXTextEditorInput)element, document, overwrite);
        }
    }

    protected void doSaveDocument(IProgressMonitor monitor, NestedXTextEditorInput editorInput, IDocument document, boolean overwrite) {
        String newText = document.get();
        NestedXTextEditorInput input = editorInput;
        EObject semanticElement = input.getEditedElement();
        String initialText = input.getTextToEdit();
        if (newText.equals(initialText)) {
            return;
        }
        ICommand cmd = this.getParseCommand(input.getDirectEditorConfiguration(), semanticElement, newText);
        TransactionalEditingDomain domain = this.getEditingDomain(semanticElement);
        domain.getCommandStack().execute((Command)new GMFtoEMFCommandWrapper(cmd));
    }

    protected ICommand getParseCommand(ICustomDirectEditorConfiguration configuration, EObject editedElement, String newText) {
        IParser parser = this.getParser(configuration, editedElement);
        return parser.getParseCommand((IAdaptable)new EObjectAdapter(editedElement), newText, 0);
    }

    protected IParser getParser(ICustomDirectEditorConfiguration configuration, EObject editedElement) {
        return configuration.createParser(editedElement);
    }

    protected final TransactionalEditingDomain getEditingDomain(EObject eobject) {
        try {
            return ServiceUtilsForEObject.getInstance().getTransactionalEditingDomain((Object)eobject);
        }
        catch (ServiceException e) {
            Activator.log.error((Throwable)e);
            return null;
        }
    }

    protected IAnnotationModel createAnnotationModel(Object element) throws CoreException {
        if (element instanceof NestedXTextEditorInput) {
            return new PapyrusXTextMarker();
        }
        return null;
    }
}

