/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.dev.types.handlers;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.handlers.HandlerUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class MigrateTypesConfigurations
extends AbstractHandler {
    final String FILE_EXTENSION = "elementtypesconfigurations";
    final String ELEMENTTYPECONFIGURATION_NAMESPACE_ATTRIBUTE = "xmlns:elementtypesconfigurations";
    final String ELEMENTTYPECONFIGURATION_NAMESPACE_OLD = "http://www.eclipse.org/papyrus/infra/elementtypesconfigurations/1.0";
    final String ELEMENTTYPECONFIGURATION_NAMESPACE_NEW = "http://www.eclipse.org/papyrus/infra/elementtypesconfigurations/1.1";
    final String APPLYSTEREOTYPEADVICECONFIGURATION_NAMESPACE = "applystereotypeadviceconfiguration";
    final String APPLYSTEREOTYPEADVICECONFIGURATION_NAMESPACENEW = "applystereotypeadvice";
    final String APPLYSTEREOTYPEADVICECONFIGURATION_NAMESPACE_ATTRIBUTE = "xmlns:applystereotypeadviceconfiguration";
    final String APPLYSTEREOTYPEADVICECONFIGURATION_NAMESPACE_ATTRIBUTE_NEW = "xmlns:applystereotypeadvice";
    final String APPLYSTEREOTYPEADVICECONFIGURATION_NAMESPACE_NEW_URL = "http://www.eclipse.org/papyrus/uml/types/applystereotypeadvice/1.1";
    final String INVARIANTSTEREOTYPERULECONFIGURATION_NAMESPACE = "invariantstereotyperuleconfiguration";
    final String INVARIANTSTEREOTYPERULECONFIGURATION_NAMESPACENEW = "invariantstereotyperule";
    final String INVARIANTSTEREOTYPERULECONFIGURATION_NAMESPACE_ATTRIBUTE = "xmlns:invariantstereotyperuleconfiguration";
    final String INVARIANTSTEREOTYPERULECONFIGURATION_NAMESPACE_ATTRIBUTE_NEW = "xmlns:invariantstereotyperule";
    final String INVARIANTSTEREOTYPERULECONFIGURATION_NAMESPACE_NEW_URL = "http://www.eclipse.org/papyrus/uml/types/invariantstereotyperule/1.1";
    final String SETTYPEADVICECONFIGURATION_NAMESPACE = "settypeadviceconfiguration";
    final String SETTYPEADVICECONFIGURATION_NAMESPACENEW = "settypeadvice";
    final String SETTYPEADVICECONFIGURATION_NAMESPACE_ATTRIBUTE = "xmlns:settypeadviceconfiguration";
    final String SETTYPEADVICECONFIGURATION_NAMESPACE_ATTRIBUTE_NEW = "xmlns:settypeadvice";
    final String SETTYPEADVICECONFIGURATION_NAMESPACE_NEW_URL = "http://www.eclipse.org/papyrus/uml/types/settypeadvice/1.1";
    final String STEREOTYPEAPPLICATIONMATCHERCONFIGURATION_NAMESPACE = "stereotypeapplicationmatcherconfiguration";
    final String STEREOTYPEAPPLICATIONMATCHERCONFIGURATION_NAMESPACENEW = "stereotypematcher";
    final String STEREOTYPEAPPLICATIONMATCHERCONFIGURATION_NAMESPACE_ATTRIBUTE = "xmlns:stereotypeapplicationmatcherconfiguration";
    final String STEREOTYPEAPPLICATIONMATCHERCONFIGURATION_NAMESPACE_ATTRIBUTE_NEW = "xmlns:stereotypematcher";
    final String STEREOTYPEAPPLICATIONMATCHERCONFIGURATION_NAMESPACE_NEW_URL = "http://www.eclipse.org/papyrus/uml/types/stereotypematcher/1.1";
    final String INVARIANTCONTAINERRULECONFIGURATION_NAMESPACE = "invariantcontainerruleconfiguration";
    final String INVARIANTCONTAINERRULECONFIGURATION_NAMESPACENEW = "invariantcontainerrule";
    final String INVARIANTCONTAINERRULECONFIGURATION_NAMESPACE_ATTRIBUTE = "xmlns:invariantcontainerruleconfiguration";
    final String INVARIANTCONTAINERRULECONFIGURATION_NAMESPACE_ATTRIBUTE_NEW = "xmlns:invariantcontainerrule";
    final String INVARIANTCONTAINERRULECONFIGURATION_NAMESPACE_NEW_URL = "http://www.eclipse.org/papyrus/emf/types/invariantcontainerrule/1.1";
    final String RUNTIMEVALUESEDITIONADVICECONFIGURATION_NAMESPACE = "runtimevalueseditionadviceconfiguration";
    final String RUNTIMEVALUESEDITIONADVICECONFIGURATION_NAMESPACENEW = "runtimevaluesadvice";
    final String RUNTIMEVALUESEDITIONADVICECONFIGURATION_NAMESPACE_ATTRIBUTE = "xmlns:runtimevalueseditionadviceconfiguration";
    final String RUNTIMEVALUESEDITIONADVICECONFIGURATION_NAMESPACE_ATTRIBUTE_NEW = "xmlns:runtimevaluesadvice";
    final String RUNTIMEVALUESEDITIONADVICECONFIGURATION_NAMESPACE_NEW_URL = "http://www.eclipse.org/papyrus/emf/types/runtimevaluesadvice/1.1";
    final String SETVALUESADVICECONFIGURATION_NAMESPACE = "setvaluesadviceconfiguration";
    final String SETVALUESADVICECONFIGURATION_NAMESPACENEW = "setvaluesadvice";
    final String SETVALUESADVICECONFIGURATION_NAMESPACE_ATTRIBUTE = "xmlns:setvaluesadviceconfiguration";
    final String SETVALUESADVICECONFIGURATION_NAMESPACE_ATTRIBUTE_NEW = "xmlns:setvaluesadvice";
    final String SETVALUESADVICECONFIGURATION_NAMESPACE_NEW_URL = "http://www.eclipse.org/papyrus/emf/types/setvaluesadvice/1.1";
    final String INVARIANTTYPECONFIGURATION_NAMESPACE = "invarianttypeconfiguration";
    final String INVARIANTTYPECONFIGURATION_NAMESPACENEW = "rulebased";
    final String INVARIANTTYPECONFIGURATION_NAMESPACE_ATTRIBUTE = "xmlns:invarianttypeconfiguration";
    final String INVARIANTTYPECONFIGURATION_NAMESPACE_ATTRIBUTE_NEW = "xmlns:rulebased";
    final String INVARIANTTYPECONFIGURATION_NAMESPACE_NEW_URL = "http://www.eclipse.org/papyrus/infra/types/rulebased/1.1";
    final String INVARIANTTYPECONFIGURATION = "InvariantTypeConfiguration";
    final String INVARIANTTYPECONFIGURATION_NEW = "RuleBasedTypeConfiguration";
    final String RUNTIMEVALUESEDITIONADVICECONFIGURATION = "RuntimeValuesEditionAdviceConfiguration";
    final String RUNTIMEVALUESADVICECONFIGURATION = "RuntimeValuesAdviceConfiguration";
    final String INHERITANCE_ATTRIBUTE = "inheritance";
    final String TYPE_ATTRIBUTE = "xsi:type";
    final String EDITHELPERADVICECONFIGURATION_TAG = "editHelperAdviceConfiguration";
    final String MATCHERCONFIGURATION_TAG = "matcherConfiguration";
    final String INVARIANTRULECONFIGURATION_TAG = "invariantRuleConfiguration";
    final String RULECONFIGURATION_TAG = "ruleConfiguration";
    final String NAME_ATTRIBUTE = "name";
    final String IDENTIFIER_ATTRIBUTE = "identifier";
    final String EDITHELPERADVICECLASSNAME_ATTRIBUTE = "editHelperAdviceClassName";
    final String ADVICEBINDINGSCONFIGURATIONS_TAG = "adviceBindingsConfigurations";
    final String MATCHER_TYPE = "elementtypesconfigurations:MatcherConfiguration";
    final String ADVICEBINDINGCONFIGURATION_TYPE = "elementtypesconfigurations:AdviceBindingConfiguration";
    final String EDITHELPERADVICECONFIGURATION_TYPE = "elementtypesconfigurations:EditHelperAdviceConfiguration";
    final String MATCHERCLASSNAME_ATTRIBUTE = "matcherClassName";

    public Object execute(ExecutionEvent event) throws ExecutionException {
        HashMap<String, String> mapMigration = new HashMap<String, String>();
        mapMigration.put("applystereotypeadviceconfiguration", "applystereotypeadvice");
        mapMigration.put("invariantstereotyperuleconfiguration", "invariantstereotyperule");
        mapMigration.put("settypeadviceconfiguration", "settypeadvice");
        mapMigration.put("stereotypeapplicationmatcherconfiguration", "stereotypematcher");
        mapMigration.put("invariantcontainerruleconfiguration", "invariantcontainerrule");
        mapMigration.put("runtimevalueseditionadviceconfiguration", "runtimevaluesadvice");
        mapMigration.put("setvaluesadviceconfiguration", "setvaluesadvice");
        mapMigration.put("invarianttypeconfiguration", "rulebased");
        mapMigration.put("InvariantTypeConfiguration", "RuleBasedTypeConfiguration");
        mapMigration.put("RuntimeValuesEditionAdviceConfiguration", "RuntimeValuesAdviceConfiguration");
        ISelection currentSelection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (!(currentSelection instanceof IStructuredSelection) || currentSelection.isEmpty()) {
            return null;
        }
        IStructuredSelection selection = (IStructuredSelection)currentSelection;
        for (Object selectedElement : selection) {
            if (!(selectedElement instanceof IFile) || !"elementtypesconfigurations".equals(((IFile)selectedElement).getFileExtension())) continue;
            IFile selectedFile = (IFile)selectedElement;
            URI uri = selectedFile.getLocationURI();
            if (selectedFile.isLinked()) {
                uri = selectedFile.getRawLocationURI();
            }
            try {
                File file = EFS.getStore((URI)uri).toLocalFile(0, (IProgressMonitor)new NullProgressMonitor());
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                DocumentBuilder builder = factory.newDocumentBuilder();
                Document doc = builder.parse(file);
                Element root = doc.getDocumentElement();
                root.setAttribute("xmlns:elementtypesconfigurations", "http://www.eclipse.org/papyrus/infra/elementtypesconfigurations/1.1");
                if (!root.getAttribute("xmlns:applystereotypeadviceconfiguration").isEmpty()) {
                    root.removeAttribute("xmlns:applystereotypeadviceconfiguration");
                    root.setAttribute("xmlns:applystereotypeadvice", "http://www.eclipse.org/papyrus/uml/types/applystereotypeadvice/1.1");
                }
                if (!root.getAttribute("xmlns:invariantstereotyperuleconfiguration").isEmpty()) {
                    root.removeAttribute("xmlns:invariantstereotyperuleconfiguration");
                    root.setAttribute("xmlns:invariantstereotyperule", "http://www.eclipse.org/papyrus/uml/types/invariantstereotyperule/1.1");
                }
                if (!root.getAttribute("xmlns:settypeadviceconfiguration").isEmpty()) {
                    root.removeAttribute("xmlns:settypeadviceconfiguration");
                    root.setAttribute("xmlns:settypeadvice", "http://www.eclipse.org/papyrus/uml/types/settypeadvice/1.1");
                }
                if (!root.getAttribute("xmlns:stereotypeapplicationmatcherconfiguration").isEmpty()) {
                    root.removeAttribute("xmlns:stereotypeapplicationmatcherconfiguration");
                    root.setAttribute("xmlns:stereotypematcher", "http://www.eclipse.org/papyrus/uml/types/stereotypematcher/1.1");
                }
                if (!root.getAttribute("xmlns:invariantcontainerruleconfiguration").isEmpty()) {
                    root.removeAttribute("xmlns:invariantcontainerruleconfiguration");
                    root.setAttribute("xmlns:invariantcontainerrule", "http://www.eclipse.org/papyrus/emf/types/invariantcontainerrule/1.1");
                }
                if (!root.getAttribute("xmlns:runtimevalueseditionadviceconfiguration").isEmpty()) {
                    root.removeAttribute("xmlns:runtimevalueseditionadviceconfiguration");
                    root.setAttribute("xmlns:runtimevaluesadvice", "http://www.eclipse.org/papyrus/emf/types/runtimevaluesadvice/1.1");
                }
                if (!root.getAttribute("xmlns:setvaluesadviceconfiguration").isEmpty()) {
                    root.removeAttribute("xmlns:setvaluesadviceconfiguration");
                    root.setAttribute("xmlns:setvaluesadvice", "http://www.eclipse.org/papyrus/emf/types/setvaluesadvice/1.1");
                }
                if (!root.getAttribute("xmlns:invarianttypeconfiguration").isEmpty()) {
                    root.removeAttribute("xmlns:invarianttypeconfiguration");
                    root.setAttribute("xmlns:rulebased", "http://www.eclipse.org/papyrus/infra/types/rulebased/1.1");
                }
                NodeList editHelperAdviceConfigurations = root.getElementsByTagName("editHelperAdviceConfiguration");
                int i = 0;
                while (i < editHelperAdviceConfigurations.getLength()) {
                    Element editHelperAdvice = (Element)editHelperAdviceConfigurations.item(i);
                    Node type = editHelperAdvice.getAttributes().getNamedItem("xsi:type");
                    if (type == null) {
                        editHelperAdvice.setAttribute("xsi:type", "elementtypesconfigurations:EditHelperAdviceConfiguration");
                    } else if (!type.getNodeValue().equals("elementtypesconfigurations:EditHelperAdviceConfiguration")) {
                        editHelperAdvice.removeAttribute("editHelperAdviceClassName");
                    }
                    editHelperAdvice.removeAttribute("name");
                    editHelperAdvice.removeAttribute("identifier");
                    editHelperAdvice.removeAttribute("inheritance");
                    ++i;
                }
                NodeList adviceBindingsConfigurations = root.getElementsByTagName("adviceBindingsConfigurations");
                int i2 = 0;
                while (i2 < adviceBindingsConfigurations.getLength()) {
                    Element adviceBinding = (Element)adviceBindingsConfigurations.item(i2);
                    Node type = adviceBinding.getAttributes().getNamedItem("xsi:type");
                    if (type == null) {
                        adviceBinding.setAttribute("xsi:type", "elementtypesconfigurations:AdviceBindingConfiguration");
                    } else if (!type.getNodeValue().equals("elementtypesconfigurations:AdviceBindingConfiguration")) {
                        adviceBinding.removeAttribute("editHelperAdviceClassName");
                    }
                    adviceBinding.removeAttribute("name");
                    ++i2;
                }
                NodeList matcherConfigurations = root.getElementsByTagName("matcherConfiguration");
                int i3 = 0;
                while (i3 < matcherConfigurations.getLength()) {
                    Element matcher = (Element)matcherConfigurations.item(i3);
                    Node type = matcher.getAttributes().getNamedItem("xsi:type");
                    if (type == null) {
                        matcher.setAttribute("xsi:type", "elementtypesconfigurations:MatcherConfiguration");
                    } else if (!type.getNodeValue().equals("elementtypesconfigurations:MatcherConfiguration")) {
                        matcher.removeAttribute("matcherClassName");
                    }
                    ++i3;
                }
                NodeList invariantRuleConfigurations = root.getElementsByTagName("invariantRuleConfiguration");
                int i4 = 0;
                while (i4 < invariantRuleConfigurations.getLength()) {
                    Element invariantRule = (Element)invariantRuleConfigurations.item(i4);
                    doc.renameNode(invariantRule, null, "ruleConfiguration");
                    ++i4;
                }
                this.migrate(root.getChildNodes(), mapMigration);
                Transformer transformer = TransformerFactory.newInstance().newTransformer();
                transformer.setOutputProperty("encoding", "UTF-8");
                StreamResult output = new StreamResult(file);
                DOMSource input = new DOMSource(doc);
                transformer.transform(input, output);
            }
            catch (ParserConfigurationException e) {
                e.printStackTrace();
            }
            catch (SAXException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
            catch (TransformerConfigurationException e) {
                e.printStackTrace();
            }
            catch (TransformerFactoryConfigurationError e) {
                e.printStackTrace();
            }
            catch (TransformerException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    void migrate(NodeList nodeList, Map<String, String> mapMigration) {
        int i = 0;
        while (i < nodeList.getLength()) {
            NodeList children;
            Node childNode = nodeList.item(i);
            NamedNodeMap attributes = childNode.getAttributes();
            if (attributes != null) {
                int j = 0;
                while (j < attributes.getLength()) {
                    Node childAttr = attributes.item(j);
                    if (childAttr.getNodeName().equals("xsi:type")) {
                        for (String old : mapMigration.keySet()) {
                            if (!childAttr.getNodeValue().contains(old)) continue;
                            String newNS = mapMigration.get(old);
                            String newValue = childAttr.getNodeValue().replace(old, newNS);
                            childAttr.setNodeValue(newValue);
                        }
                    }
                    ++j;
                }
            }
            if ((children = childNode.getChildNodes()) != null) {
                this.migrate(children, mapMigration);
            }
            ++i;
        }
    }
}

