/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.customization.properties.generation.generators;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.m2m.qvt.oml.BasicModelExtent;
import org.eclipse.m2m.qvt.oml.ModelExtent;
import org.eclipse.papyrus.customization.properties.generation.Activator;
import org.eclipse.papyrus.customization.properties.generation.generators.AbstractQVTGenerator;
import org.eclipse.papyrus.customization.properties.generation.messages.Messages;
import org.eclipse.papyrus.customization.properties.generation.wizard.widget.FileChooser;
import org.eclipse.papyrus.infra.properties.contexts.Context;
import org.eclipse.papyrus.infra.properties.contexts.DataContextElement;
import org.eclipse.papyrus.infra.widgets.providers.FileExtensions;
import org.eclipse.papyrus.views.properties.root.PropertiesRoot;
import org.eclipse.papyrus.views.properties.runtime.ConfigurationManager;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Enumeration;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.PackageImport;
import org.eclipse.uml2.uml.PrimitiveType;
import org.eclipse.uml2.uml.Profile;
import org.eclipse.uml2.uml.Property;

public class ProfileGenerator
extends AbstractQVTGenerator {
    private FileChooser sourceFileChooser;
    private Profile umlProfile;
    private List<Object> list;
    private List<EObject> listEObject;

    @Override
    public void createControls(Composite parent, IFile workbenchSelection) {
        IFile suggestion;
        Composite root = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        root.setLayout((Layout)layout);
        Label sourceLabel = new Label(root, 0);
        sourceLabel.setText(Messages.ProfileGenerator_source);
        GridData data = new GridData();
        data.widthHint = 100;
        sourceLabel.setLayoutData((Object)data);
        this.sourceFileChooser = new FileChooser(root, false);
        this.sourceFileChooser.setFilterExtensions(FileExtensions.umlProfileExtensions);
        this.sourceFileChooser.addListener(this);
        this.listEObject = new ArrayList<EObject>();
        if (workbenchSelection != null && (suggestion = this.getSourceFile(workbenchSelection)) != null) {
            this.sourceFileChooser.setFile(suggestion);
        }
    }

    @Override
    public String getDescription() {
        return Messages.ProfileGenerator_description;
    }

    @Override
    public boolean isReady() {
        return this.sourceFileChooser.getFilePath() != null;
    }

    @Override
    public String getName() {
        return Messages.ProfileGenerator_name;
    }

    @Override
    protected List<ModelExtent> getModelExtents() {
        LinkedList<ModelExtent> result = new LinkedList<ModelExtent>();
        BasicModelExtent inPackage = new BasicModelExtent();
        ArrayList<Object> liste = new ArrayList<Object>();
        if (!this.listEObject.isEmpty()) {
            for (EObject currentEObject : this.listEObject) {
                EObject tempEObject = null;
                try {
                    tempEObject = this.loadEMFModel(currentEObject.eResource().getURI());
                    liste.add(tempEObject);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        } else {
            liste.add(this.umlProfile);
        }
        inPackage.setContents(liste);
        URI umlURI = URI.createURI((String)"ppe:/context/org.eclipse.papyrus.uml.properties/Model/UML/UML.ctx", (boolean)true);
        Context umlContext = null;
        try {
            umlContext = (Context)this.loadEMFModel(umlURI);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (umlContext == null) {
            Activator.log.warn("Cannot find the UML Property View configuration");
        }
        BasicModelExtent inUml = new BasicModelExtent(Collections.singletonList(umlContext));
        PropertiesRoot root = ConfigurationManager.getInstance().getPropertiesRoot();
        BasicModelExtent inRoot = new BasicModelExtent(Collections.singletonList(root));
        result.add((ModelExtent)inPackage);
        result.add(this.getOutContextExtent());
        result.add((ModelExtent)inUml);
        result.add((ModelExtent)inRoot);
        return result;
    }

    @Override
    protected URI getTransformationURI() {
        return URI.createPlatformPluginURI((String)"org.eclipse.papyrus.uml.properties.generation/transforms/profile2datacontext.qvto", (boolean)true);
    }

    protected Classifier findClassifier(List<String> path, Package rootPackage) {
        NamedElement element = rootPackage.getOwnedMember(path.get(0));
        path.remove(0);
        if (path.size() == 0) {
            if (element instanceof Classifier) {
                return (Classifier)element;
            }
        } else if (element instanceof Package) {
            return this.findClassifier(path, (Package)element);
        }
        return null;
    }

    private List<String> getPath(org.eclipse.papyrus.infra.properties.contexts.Property property) {
        List<String> result = this.getPath(property.getContextElement());
        return result;
    }

    private List<String> getPath(DataContextElement element) {
        List<Object> result = element.getPackage() == null ? new LinkedList() : this.getPath((DataContextElement)element.getPackage());
        result.add(element.getName());
        return result;
    }

    public Property getAttribute(org.eclipse.papyrus.infra.properties.contexts.Property property) {
        List<String> path = this.getPath(property);
        Package propertyRootPackage = this.findPackage(path.remove(0));
        if (propertyRootPackage == null) {
            return null;
        }
        Classifier classifier = this.findClassifier(path, propertyRootPackage);
        if (classifier == null) {
            return null;
        }
        Property attribute = classifier.getAttribute(property.getName(), null);
        return attribute;
    }

    public Package findPackage(String name) {
        for (Resource resource : this.umlProfile.eResource().getResourceSet().getResources()) {
            for (Object rootElement : resource.getContents()) {
                Package rootPackage;
                if (!(rootElement instanceof Package) || !name.equals((rootPackage = (Package)rootElement).getName())) continue;
                return rootPackage;
            }
        }
        return null;
    }

    @Override
    public boolean isSelectedSingle(org.eclipse.papyrus.infra.properties.contexts.Property property) {
        Property attribute = this.getAttribute(property);
        if (attribute == null) {
            Activator.log.warn("Cannot find the Property corresponding to " + this.getPath(property));
            return false;
        }
        if (attribute.isDerived()) {
            return false;
        }
        return !attribute.isReadOnly();
    }

    @Override
    public boolean isSelectedMultiple(org.eclipse.papyrus.infra.properties.contexts.Property property) {
        if (!this.isSelectedSingle(property)) {
            return false;
        }
        Property attribute = this.getAttribute(property);
        HashSet<String> validDataTypes = new HashSet<String>(Arrays.asList("Integer", "Boolean", "Float", "Double"));
        if (attribute.getType() instanceof PrimitiveType) {
            return validDataTypes.contains(((PrimitiveType)attribute.getType()).getName());
        }
        return attribute.getType() instanceof Enumeration;
    }

    @Override
    public boolean isSelectedSingle(org.eclipse.papyrus.infra.properties.contexts.Property property, DataContextElement element) {
        return this.isSelectedSingle(property);
    }

    @Override
    public boolean isSelectedMultiple(org.eclipse.papyrus.infra.properties.contexts.Property property, DataContextElement element) {
        return this.isSelectedMultiple(property);
    }

    @Override
    public IObservableValue getObservableValue() {
        return this.sourceFileChooser.getObservableValue();
    }

    @Override
    public List<Object> getExternalReference() {
        URI packageURI = URI.createPlatformResourceURI((String)this.sourceFileChooser.getFilePath(), (boolean)true);
        try {
            this.umlProfile = (Profile)this.loadEMFModel(packageURI);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.list = new ArrayList<Object>();
        this.list.add(this.umlProfile);
        TreeIterator tree = this.umlProfile.eAllContents();
        while (tree.hasNext()) {
            PackageImport currentPackage;
            Object obj = tree.next();
            if (!(obj instanceof PackageImport) || this.list.contains((currentPackage = (PackageImport)obj).getImportedPackage())) continue;
            this.list.add(currentPackage.getImportedPackage());
        }
        return this.list;
    }

    @Override
    public void addCheckElement(Object obj) {
        EObject current;
        if (obj instanceof EObject && !this.listEObject.contains(current = (EObject)obj)) {
            this.listEObject.add(current);
        }
    }

    @Override
    protected List<ModelExtent> getModelExtents(int i) {
        try {
            URI umlURI;
            Context umlContext;
            BasicModelExtent inProfile = null;
            if (this.listEObject.get(i) instanceof Package) {
                Package currentPackage = (Package)this.listEObject.get(i);
                this.setProfile((Profile)this.loadEMFModel(currentPackage.eResource().getURI()));
                inProfile = new BasicModelExtent(Collections.singletonList(this.umlProfile));
            }
            if ((umlContext = (Context)this.loadEMFModel(umlURI = URI.createURI((String)"ppe:/context/org.eclipse.papyrus.uml.properties/Model/UML/UML.ctx", (boolean)true))) == null) {
                Activator.log.warn("Cannot find the UML Property View configuration");
            }
            BasicModelExtent inUml = new BasicModelExtent(Collections.singletonList(umlContext));
            PropertiesRoot root = ConfigurationManager.getInstance().getPropertiesRoot();
            BasicModelExtent inRoot = new BasicModelExtent(Collections.singletonList(root));
            LinkedList<ModelExtent> result = new LinkedList<ModelExtent>();
            result.add((ModelExtent)inProfile);
            result.add(this.getOutContextExtent());
            result.add((ModelExtent)inUml);
            result.add((ModelExtent)inRoot);
            return result;
        }
        catch (Exception ex) {
            Activator.log.error((Throwable)ex);
            return null;
        }
    }

    @Override
    public IFile getSourceFile(IFile file, IContentType contentType) {
        IContentType uml;
        IFile result = null;
        if ("di".equals(file.getFileExtension())) {
            IFile umlFile = file.getProject().getFile(file.getProjectRelativePath().removeFileExtension().addFileExtension("uml"));
            if (umlFile != null && umlFile.isAccessible()) {
                result = this.getSourceFile(umlFile);
            }
        } else if (contentType != null && (uml = Platform.getContentTypeManager().getContentType("org.eclipse.uml2.uml")) != null && contentType.isKindOf(uml)) {
            result = file;
        }
        return result;
    }

    protected void setProfile(Profile profile) {
        this.umlProfile = profile;
    }
}

