/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.toolsmiths.validation.common.checkers;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.papyrus.toolsmiths.validation.common.checkers.DiagnosticEquivalence;
import org.eclipse.papyrus.toolsmiths.validation.common.checkers.IPluginChecker;
import org.eclipse.papyrus.toolsmiths.validation.common.checkers.IPluginChecker2;
import org.eclipse.papyrus.toolsmiths.validation.common.utils.CheckerDiagnosticChain;
import org.eclipse.papyrus.toolsmiths.validation.common.utils.MarkersService;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.PluginRegistry;

public abstract class AbstractPluginChecker
implements IPluginChecker,
IPluginChecker2 {
    private final IProject project;
    private final IFile modelFile;
    private final String markerType;
    private DiagnosticEquivalence diagnosticEquivalence = DiagnosticEquivalence.DEFAULT;

    public AbstractPluginChecker(IProject project, IFile modelFile) {
        this(project, modelFile, "org.eclipse.pde.core.problem");
    }

    public AbstractPluginChecker(IProject project, IFile modelFile, String markerType) {
        this.project = project;
        this.modelFile = modelFile;
        this.markerType = markerType;
    }

    public void setDiagnosticEquivalence(DiagnosticEquivalence diagnosticEquivalence) {
        this.diagnosticEquivalence = diagnosticEquivalence == null ? DiagnosticEquivalence.DEFAULT : diagnosticEquivalence;
    }

    public final IProject getProject() {
        return this.project;
    }

    public final IFile getModelFile() {
        return this.modelFile;
    }

    public final String getMarkerType() {
        return this.markerType;
    }

    @Override
    public void check(IProgressMonitor monitor) {
        CheckerDiagnosticChain diagnostics = new CheckerDiagnosticChain(this.diagnosticEquivalence);
        this.check(diagnostics, monitor);
        if (diagnostics.getSeverity() > 0) {
            this.wrap(diagnostics.stream()).distinct().forEach(this::createMarker);
        }
    }

    protected Diagnostic createDiagnostic(int severity, int code, String message, Object ... data) {
        return this.createDiagnostic(this.getProject(), this.getModelFile(), severity, code, message, data);
    }

    protected Diagnostic createDiagnostic(IFile file, int severity, int code, String message, Object ... data) {
        return this.createDiagnostic(this.getProject(), file, severity, code, message, data);
    }

    protected Diagnostic createDiagnostic(IProject project, IFile file, int severity, int code, String message, Object ... data) {
        List diagnosticData = file == null ? Lists.asList((Object)project, (Object[])data) : Lists.asList((Object)project, (Object)file, (Object[])data);
        return new BasicDiagnostic(severity, this.getClass().getName(), code, message, diagnosticData.toArray());
    }

    protected void createMarker(Diagnostic diagnostic) {
        IResource resource = IPluginChecker2.getFile(diagnostic).map(IResource.class::cast).or(() -> Optional.ofNullable(this.modelFile)).orElse((IResource)this.project);
        IMarker marker = MarkersService.createMarker(resource, IPluginChecker2.getMarkerType(diagnostic).orElse(this.markerType), diagnostic);
        IPluginChecker2.setAttributes(diagnostic, marker);
    }

    protected final Diagnostic wrap(Diagnostic diagnostic) {
        return IPluginChecker2.getMarkerType(diagnostic).isEmpty() ? this.diagnosticEquivalence.wrap(diagnostic, IPluginChecker2.markerType(this.getMarkerType())) : this.diagnosticEquivalence.wrap(diagnostic, new Object[0]);
    }

    private Stream<Diagnostic> wrap(Stream<Diagnostic> diagnostics) {
        return diagnostics.map(this::wrap);
    }

    protected final String getBundleName(IProject bundleProject) {
        return Optional.ofNullable(PluginRegistry.findModel((IProject)bundleProject)).map(IPluginModelBase::getBundleDescription).map(BundleDescription::getSymbolicName).orElse(bundleProject.getName());
    }
}

