/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.search.ui.query;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.core.resource.NotFoundException;
import org.eclipse.papyrus.uml.search.ui.Activator;
import org.eclipse.papyrus.uml.search.ui.Messages;
import org.eclipse.papyrus.uml.search.ui.query.AbstractPapyrusQuery;
import org.eclipse.papyrus.uml.search.ui.results.PapyrusSearchResult;
import org.eclipse.papyrus.uml.search.ui.validator.ParticipantValidator;
import org.eclipse.papyrus.uml.tools.model.UmlModel;
import org.eclipse.papyrus.views.search.regex.PatternHelper;
import org.eclipse.papyrus.views.search.results.AbstractResultEntry;
import org.eclipse.papyrus.views.search.results.AttributeMatch;
import org.eclipse.papyrus.views.search.results.ViewerMatch;
import org.eclipse.papyrus.views.search.scope.ScopeEntry;
import org.eclipse.search.ui.ISearchResult;
import org.eclipse.search.ui.text.Match;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.UMLPackage;

public class PapyrusQuery
extends AbstractPapyrusQuery {
    private String searchQueryText;
    private boolean isCaseSensitive;
    private boolean isRegularExpression;
    private Collection<ScopeEntry> scopeEntries;
    private Object[] participantsTypes;
    private PapyrusSearchResult results;
    private boolean searchAllStringAttributes;
    protected Set<AbstractResultEntry> fResults = null;

    @Override
    public boolean isCaseSensitive() {
        return this.isCaseSensitive;
    }

    @Override
    public boolean isRegularExpression() {
        return this.isRegularExpression;
    }

    public PapyrusQuery(String searchQueryText, boolean isCaseSensitive, boolean isRegularExpression, Collection<ScopeEntry> scopeEntries, Object[] participantsTypes, boolean searchAllStringAttributes) {
        this.searchQueryText = searchQueryText;
        this.isCaseSensitive = isCaseSensitive;
        this.isRegularExpression = isRegularExpression;
        this.scopeEntries = scopeEntries;
        this.participantsTypes = participantsTypes;
        this.searchAllStringAttributes = searchAllStringAttributes;
        this.results = new PapyrusSearchResult(this);
        this.fResults = new HashSet<AbstractResultEntry>();
    }

    public IStatus run(IProgressMonitor monitor) throws OperationCanceledException {
        this.progressMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)(this.scopeEntries.size() * 3));
        this.progressMonitor.subTask("Searching");
        this.results.removeAll();
        this.fResults.clear();
        for (ScopeEntry scopeEntry : this.scopeEntries) {
            try {
                if (scopeEntry.getModelSet() == null) continue;
                UmlModel umlModel = (UmlModel)scopeEntry.getModelSet().getModelChecked("org.eclipse.papyrus.infra.core.resource.uml.UmlModel");
                EObject root = umlModel.lookupRoot();
                Collection<EObject> participants = ParticipantValidator.getInstance().getParticipants(root, this.participantsTypes);
                this.progressMonitor.worked(1);
                this.evaluate(participants, scopeEntry);
                this.progressMonitor.worked(1);
            }
            catch (NotFoundException e) {
                Activator.log.error(String.valueOf(Messages.PapyrusQuery_0) + scopeEntry.getModelSet(), (Throwable)e);
            }
        }
        this.progressMonitor.done();
        return Status.OK_STATUS;
    }

    /*
     * Unable to fully structure code
     */
    protected void evaluateAndAddToResult(String value, Object attribute, Pattern pattern, Object participant, ScopeEntry scopeEntry, Stereotype stereotype) {
        block3: {
            value = value != null ? value : "";
            m = pattern.matcher(value);
            if (!this.isRegularExpression) ** GOTO lbl16
            if (!m.matches()) break block3;
            start = m.start();
            end = m.end();
            match = new AttributeMatch(start, end, participant, scopeEntry, attribute, stereotype);
            this.fResults.add((AbstractResultEntry)match);
            break block3;
lbl-1000:
            // 1 sources

            {
                offset = m.start();
                length = m.end() - m.start();
                match = new AttributeMatch(offset, length, participant, scopeEntry, attribute, stereotype);
                this.fResults.add((AbstractResultEntry)match);
lbl16:
                // 2 sources

                ** while (m.find())
            }
        }
    }

    protected void evaluate(Collection<EObject> participants, ScopeEntry scopeEntry) {
        for (EObject participant : participants) {
            Pattern pattern;
            String query = this.searchQueryText;
            if (this.searchQueryText.equals("")) {
                query = ".*";
            }
            if ((pattern = PatternHelper.getInstance().createPattern(query, this.isCaseSensitive, this.isRegularExpression)) == null) continue;
            if (this.searchAllStringAttributes) {
                for (EAttribute attribute : participant.eClass().getEAllAttributes()) {
                    Object value = participant.eGet((EStructuralFeature)attribute);
                    if (!(value instanceof String)) continue;
                    String stringValue = (String)value;
                    this.evaluateAndAddToResult(stringValue, attribute, pattern, participant, scopeEntry, null);
                }
                if (!(participant instanceof Element)) continue;
                EList stereotypes = ((Element)participant).getAppliedStereotypes();
                for (Stereotype stereotype : stereotypes) {
                    for (Property stereotypeProperty : stereotype.getAllAttributes()) {
                        Object value;
                        if (stereotypeProperty.getName().startsWith("base_") || !((value = ((Element)participant).getValue(stereotype, stereotypeProperty.getName())) instanceof String)) continue;
                        String stringValue = (String)value;
                        this.evaluateAndAddToResult(stringValue, stereotypeProperty, pattern, participant, scopeEntry, stereotype);
                    }
                }
                continue;
            }
            if (!(participant instanceof NamedElement)) continue;
            String umlElementName = ((NamedElement)participant).getName();
            umlElementName = umlElementName != null ? umlElementName : "";
            this.evaluateAndAddToResult(umlElementName, UMLPackage.eINSTANCE.getNamedElement_Name(), pattern, participant, scopeEntry, null);
        }
        HashSet<ViewerMatch> viewResults = new HashSet<ViewerMatch>();
        for (AbstractResultEntry match : this.fResults) {
            List<View> views;
            Object source = match.getSource();
            if (!(source instanceof Element) || (views = this.getViews((Element)source)) == null || views.isEmpty()) continue;
            for (View view : views) {
                ViewerMatch viewMatch = new ViewerMatch((Object)view, scopeEntry, source);
                viewResults.add(viewMatch);
            }
        }
        this.fResults.addAll(viewResults);
    }

    public Set<AbstractResultEntry> getResults() {
        return this.fResults;
    }

    public String getLabel() {
        return Messages.PapyrusQuery_6;
    }

    public boolean canRerun() {
        return false;
    }

    public boolean canRunInBackground() {
        return true;
    }

    public ISearchResult getSearchResult() {
        if (this.progressMonitor != null) {
            this.progressMonitor.setWorkRemaining(this.fResults.size());
            this.progressMonitor.subTask("Displaying Results");
        }
        for (AbstractResultEntry match : this.fResults) {
            this.results.addMatch((Match)match);
            if (this.progressMonitor == null) continue;
            this.progressMonitor.worked(1);
        }
        if (this.progressMonitor != null) {
            this.progressMonitor.done();
        }
        return this.results;
    }

    @Override
    public String getSearchQueryText() {
        return this.searchQueryText;
    }
}

