/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.activity.edit.part;

import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef.Request;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.papyrus.uml.diagram.activity.edit.parts.ControlFlowNameEditPart;
import org.eclipse.papyrus.uml.diagram.activity.part.UMLDiagramEditorPlugin;

public class CustomControlFlowNameEditPart
extends ControlFlowNameEditPart {
    private final IPreferenceStore preferenceStore = UMLDiagramEditorPlugin.getInstance().getPreferenceStore();
    private IPropertyChangeListener preferenceListener = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent event) {
            if ("org.eclipse.papyrus.uml.diagram.activity.ActivityEdge.showNameLabel".equals(event.getProperty())) {
                CustomControlFlowNameEditPart.this.refreshLabel();
            }
        }
    };

    public CustomControlFlowNameEditPart(View view) {
        super(view);
    }

    public void activate() {
        super.activate();
        this.preferenceStore.addPropertyChangeListener(this.preferenceListener);
    }

    public void deactivate() {
        this.preferenceStore.removePropertyChangeListener(this.preferenceListener);
        super.deactivate();
    }

    protected String getLabelText() {
        boolean showName = this.preferenceStore.getBoolean("org.eclipse.papyrus.uml.diagram.activity.ActivityEdge.showNameLabel");
        if (showName) {
            return super.getLabelText();
        }
        return "";
    }

    public String getEditText() {
        boolean showName = this.preferenceStore.getBoolean("org.eclipse.papyrus.uml.diagram.activity.ActivityEdge.showNameLabel");
        if (!showName) {
            return "";
        }
        return super.getEditText();
    }

    protected void performDirectEdit() {
        boolean showName = this.preferenceStore.getBoolean("org.eclipse.papyrus.uml.diagram.activity.ActivityEdge.showNameLabel");
        if (showName) {
            super.performDirectEdit();
        }
    }

    protected void performDirectEdit(Point eventLocation) {
        boolean showName = this.preferenceStore.getBoolean("org.eclipse.papyrus.uml.diagram.activity.ActivityEdge.showNameLabel");
        if (showName) {
            super.performDirectEdit(eventLocation);
        }
    }

    protected void performDirectEdit(char initialCharacter) {
        boolean showName = this.preferenceStore.getBoolean("org.eclipse.papyrus.uml.diagram.activity.ActivityEdge.showNameLabel");
        if (showName) {
            super.performDirectEdit(initialCharacter);
        } else {
            this.performDirectEdit();
        }
    }

    protected void performDirectEditRequest(Request request) {
        boolean showName = this.preferenceStore.getBoolean("org.eclipse.papyrus.uml.diagram.activity.ActivityEdge.showNameLabel");
        if (!showName) {
            return;
        }
        super.performDirectEditRequest(request);
    }
}

