/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.textedit.xtext.nested.editor;

import java.io.IOException;
import java.util.EventObject;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.command.CommandStackListener;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.core.sasheditor.editor.IPageChangedListener;
import org.eclipse.papyrus.infra.core.sasheditor.editor.ISashWindowsContainer;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.services.ServicesRegistry;
import org.eclipse.papyrus.infra.core.utils.ServiceUtils;
import org.eclipse.papyrus.infra.gmfdiag.extensionpoints.editors.configuration.ICustomDirectEditorConfiguration;
import org.eclipse.papyrus.infra.textedit.textdocument.TextDocument;
import org.eclipse.papyrus.infra.textedit.textdocument.TextDocumentPackage;
import org.eclipse.papyrus.infra.textedit.xtext.Activator;
import org.eclipse.papyrus.infra.textedit.xtext.internal.listeners.SaveTextOnFocusLostPageLifeCycleEventsListener;
import org.eclipse.papyrus.infra.textedit.xtext.internal.listeners.SaveTextOnFocusLostPartListener;
import org.eclipse.papyrus.infra.textedit.xtext.nested.editor.NestedXTextEditorInput;
import org.eclipse.papyrus.infra.textedit.xtext.nested.editor.NestedXTextEditorStorage;
import org.eclipse.papyrus.infra.ui.lifecycleevents.ISaveAndDirtyService;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.ISaveablePart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.xtext.ui.editor.XtextEditor;

public class PapyrusXTextEditor
extends XtextEditor {
    private final CommandStackListener listener = new CommandStackListener(){

        public void commandStackChanged(EventObject event) {
            PapyrusXTextEditor.this.resetInput();
        }
    };
    private final Adapter textDocumentListener = new AdapterImpl(){

        public void notifyChanged(Notification msg) {
            if (TextDocumentPackage.eINSTANCE.getTextDocument_SemanticContext().equals(msg.getFeature())) {
                PapyrusXTextEditor.this.resetInput();
            }
        }
    };
    private IPartListener2 partListener;
    protected ServicesRegistry registry;
    protected TextDocument textDocument;
    protected TransactionalEditingDomain domain;
    protected ModelSet modelSet;
    protected ISaveAndDirtyService saveAndDirtyService;
    protected ICustomDirectEditorConfiguration editorConfiguration;
    private String fileExtension;
    private NestedXTextEditorStorage storage = null;
    private NestedXTextEditorInput input = null;
    private ISashWindowsContainer sashWindowsContainer = null;
    private SaveTextOnFocusLostPageLifeCycleEventsListener sashWindowsContainerListener = null;

    protected IPartListener2 createPartListener() {
        return new SaveTextOnFocusLostPartListener(this);
    }

    public void configureXTextEditor(ServicesRegistry servicesRegistry, TextDocument textDocument, ICustomDirectEditorConfiguration editorConfiguration, String fileExtension) {
        this.registry = servicesRegistry;
        this.textDocument = textDocument;
        this.editorConfiguration = editorConfiguration;
        this.fileExtension = fileExtension;
        try {
            this.modelSet = (ModelSet)this.registry.getService(ModelSet.class);
        }
        catch (ServiceException e1) {
            Activator.log.error("We can't find the ModelSet", (Throwable)e1);
        }
        try {
            this.saveAndDirtyService = (ISaveAndDirtyService)this.registry.getService(ISaveAndDirtyService.class);
        }
        catch (ServiceException e) {
            Activator.log.error("We can find the ISaveAndDirtyService", (Throwable)e);
        }
        this.partListener = this.createPartListener();
        this.storage = new NestedXTextEditorStorage(this.editorConfiguration, this.textDocument, this.fileExtension);
        this.input = new NestedXTextEditorInput(this.storage, this.textDocument, this.editorConfiguration);
    }

    public void doSave(IProgressMonitor progressMonitor) {
        super.doSave(progressMonitor);
        try {
            this.modelSet.save(progressMonitor);
        }
        catch (IOException e) {
            Activator.log.error("We can't save the modelSet", (Throwable)e);
        }
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (adapter == EObject.class) {
            return adapter.cast(this.textDocument);
        }
        if (adapter == TextDocument.class) {
            return adapter.cast(this.textDocument);
        }
        return (T)super.getAdapter(adapter);
    }

    private void resetInput() {
        int currentCaretOffset = -1;
        if (this.getSourceViewer() != null && this.getSourceViewer().getTextWidget() != null && !this.getSourceViewer().getTextWidget().isDisposed()) {
            currentCaretOffset = this.getSourceViewer().getTextWidget().getCaretOffset();
        }
        try {
            this.doSetInput(null);
        }
        catch (CoreException e) {
            Activator.log.error((Throwable)e);
        }
        if (currentCaretOffset != -1 && this.getSourceViewer() != null && this.getSourceViewer().getTextWidget() != null && !this.getSourceViewer().getTextWidget().isDisposed()) {
            this.getSourceViewer().getTextWidget().setCaretOffset(currentCaretOffset);
        }
    }

    public void saveTextInEditedModel() {
        this.performSave(true, (IProgressMonitor)new NullProgressMonitor());
    }

    protected void registerListeners() {
        this.domain.getCommandStack().addCommandStackListener(this.listener);
        this.textDocument.eAdapters().add((Object)this.textDocumentListener);
        if (this.saveAndDirtyService != null) {
            this.saveAndDirtyService.registerIsaveablePart((ISaveablePart)this);
        }
        IWorkbenchPage page = this.getEditorSite().getPage();
        page.addPartListener(this.partListener);
    }

    protected void unregisterListeners() {
        this.unregisterSashWindowsContainerListener();
        IWorkbenchPage page = this.getEditorSite().getPage();
        page.removePartListener(this.partListener);
        this.domain.getCommandStack().removeCommandStackListener(this.listener);
        this.textDocument.eAdapters().remove((Object)this.textDocumentListener);
        if (this.saveAndDirtyService != null) {
            this.saveAndDirtyService.removeIsaveablePart((ISaveablePart)this);
        }
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        Assert.isNotNull((Object)this.registry, (String)"The service registry must be set calling the method configureXTextEditor");
        try {
            this.domain = ServiceUtils.getInstance().getTransactionalEditingDomain((Object)this.registry);
        }
        catch (ServiceException e) {
            Activator.log.error("We can't find the editing domain", (Throwable)e);
        }
        super.init(site, input);
        this.registerListeners();
    }

    public void dispose() {
        this.unregisterListeners();
        this.saveTextInEditedModel();
        super.dispose();
    }

    protected void doSetInput(IEditorInput input) throws CoreException {
        if (this.textDocument != null && this.textDocument.eResource() != null) {
            super.doSetInput((IEditorInput)this.input);
        }
    }

    public void setFocus() {
        this.registerSashWindowsContainerListener();
        super.setFocus();
    }

    protected final void registerSashWindowsContainerListener() {
        if (this.sashWindowsContainer == null) {
            try {
                this.sashWindowsContainer = (ISashWindowsContainer)this.registry.getService(ISashWindowsContainer.class);
                this.sashWindowsContainerListener = new SaveTextOnFocusLostPageLifeCycleEventsListener(this);
                this.sashWindowsContainer.addPageChangedListener((IPageChangedListener)this.sashWindowsContainerListener);
            }
            catch (ServiceException e) {
                Activator.log.error((Throwable)e);
            }
        }
    }

    protected final void unregisterSashWindowsContainerListener() {
        if (this.sashWindowsContainer == null && this.sashWindowsContainerListener != null) {
            this.sashWindowsContainer.removePageChangedListener((IPageChangedListener)this.sashWindowsContainerListener);
        }
        this.sashWindowsContainer = null;
        this.sashWindowsContainerListener = null;
    }
}

