/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.views.properties.toolsmiths.editor;

import org.eclipse.emf.common.ui.URIEditorInput;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IPersistableElement;

public class ResourceEditorInput
extends URIEditorInput {
    private final Resource resource;
    private String name;

    public ResourceEditorInput(Resource resource) {
        this(resource, null);
    }

    public ResourceEditorInput(Resource resource, String name) {
        super(resource.getURI(), name);
        this.resource = resource;
        this.name = name;
    }

    public final Resource getResource() {
        return this.resource;
    }

    public boolean exists() {
        ResourceSet rset = this.resource.getResourceSet();
        return rset != null && rset.getURIConverter().exists(this.resource.getURI(), null);
    }

    public ImageDescriptor getImageDescriptor() {
        return null;
    }

    public String getName() {
        if (this.name == null) {
            this.name = this.resource.getURI().lastSegment();
        }
        return this.name;
    }

    public IPersistableElement getPersistable() {
        return null;
    }

    public String getToolTipText() {
        return this.resource.getURI().toString();
    }
}

