/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.common.locator;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PrecisionRectangle;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.papyrus.infra.gmfdiag.common.figure.node.IRoundedRectangleFigure;
import org.eclipse.papyrus.infra.gmfdiag.common.figure.node.RoundedRectangleNodePlateFigure;
import org.eclipse.papyrus.infra.gmfdiag.common.figure.node.SVGNodePlateFigure;
import org.eclipse.papyrus.infra.gmfdiag.common.figure.node.SlidableRoundedRectangleAnchor;
import org.eclipse.papyrus.infra.gmfdiag.common.utils.FigureUtils;
import org.eclipse.papyrus.infra.gmfdiag.common.utils.PortPositionEnum;
import org.eclipse.papyrus.uml.diagram.common.locator.ISideAffixedNodeBorderItemLocator;

public class PortPositionLocator
implements ISideAffixedNodeBorderItemLocator {
    private static final int DEFAULT_HEIGHT = 20;
    private static final int DEFAULT_WIDTH = 20;
    protected IFigure parentFigure = null;
    private PortPositionEnum position = PortPositionEnum.INSIDE;
    protected int borderItemOffset = 10;
    protected Rectangle constraint = new Rectangle(0, 0, 0, 0);
    private IFigure figure;

    @Deprecated
    public PortPositionLocator(IFigure parentFigure, int preferredSide) {
        this.parentFigure = parentFigure;
    }

    public PortPositionLocator(IFigure parentFigure) {
        this.parentFigure = parentFigure;
    }

    public int getBorderItemOffset() {
        return this.borderItemOffset;
    }

    public void setBorderItemOffset(int borderItemOffset) {
        this.borderItemOffset = borderItemOffset;
    }

    @Deprecated
    public void setPortPosition(String position) {
        this.position = PortPositionEnum.valueOf((String)position.toUpperCase());
    }

    public void setPosition(PortPositionEnum position) {
        this.position = position;
    }

    public IFigure getParentFigure() {
        return this.parentFigure;
    }

    public void setConstraint(Rectangle constraint) {
        if (constraint.getSize().equals(-1, -1)) {
            constraint.setSize(20, 20);
        }
        this.constraint = constraint;
    }

    public Rectangle getConstraint() {
        return this.constraint;
    }

    public Rectangle getValidLocation(Rectangle proposedLocation, IFigure borderItem) {
        return this.getPreferredLocation(proposedLocation);
    }

    @Override
    public Rectangle getPreferredLocation(Rectangle proposedLocation) {
        if (this.parentFigure instanceof SVGNodePlateFigure && ((SVGNodePlateFigure)this.parentFigure).getConnectionAnchor("") instanceof SlidableRoundedRectangleAnchor) {
            return this.getSVGPreferredLocation(proposedLocation, (SVGNodePlateFigure)this.parentFigure, (SlidableRoundedRectangleAnchor)((SVGNodePlateFigure)this.parentFigure).getConnectionAnchor(""));
        }
        return this.getPreferedLocationOldWay(proposedLocation);
    }

    private Rectangle getSVGPreferredLocation(Rectangle proposedLocation, SVGNodePlateFigure svgNodePlateFigure, SlidableRoundedRectangleAnchor slidableRoundedRectangleAnchor) {
        Rectangle parentRec = this.getParentFigure().getBounds().getCopy();
        Dimension proposedOffset = this.getPortOffset(proposedLocation.getSize());
        Rectangle realLocation = new Rectangle(proposedLocation);
        realLocation.translate(realLocation.width / 2, realLocation.height / 2);
        PrecisionRectangle preciseLocation = new PrecisionRectangle(realLocation);
        svgNodePlateFigure.translateToAbsolute((Translatable)preciseLocation);
        slidableRoundedRectangleAnchor.setOffset(proposedOffset);
        Point location = new Point((int)Math.round(preciseLocation.preciseX()), (int)Math.round(preciseLocation.preciseY()));
        Point locationForPort = slidableRoundedRectangleAnchor.getLocation(location);
        slidableRoundedRectangleAnchor.setOffset(new Dimension());
        if (locationForPort != null) {
            preciseLocation.setLocation(locationForPort);
        }
        svgNodePlateFigure.translateToRelative((Translatable)preciseLocation);
        realLocation.setLocation((int)Math.round(preciseLocation.preciseX()), (int)Math.round(preciseLocation.preciseY()));
        if (realLocation.x == parentRec.x - 1) {
            realLocation.x = parentRec.x;
        } else if (realLocation.y == parentRec.y - 1) {
            realLocation.y = parentRec.y;
        } else if (realLocation.x == parentRec.x + parentRec.width - 1) {
            realLocation.x = parentRec.x + parentRec.width;
        } else if (realLocation.y == parentRec.y + parentRec.height - 1) {
            realLocation.y = parentRec.y + parentRec.height - 1;
        }
        realLocation.translate(-realLocation.width / 2, -realLocation.height / 2);
        return realLocation;
    }

    @Deprecated
    private Rectangle getPreferedLocationOldWay(Rectangle proposedLocation) {
        Rectangle realLocation = new Rectangle(proposedLocation);
        Rectangle parentRec = this.getParentFigure().getBounds().getCopy();
        int xMin = parentRec.x - this.borderItemOffset;
        int xMax = parentRec.x - this.borderItemOffset + parentRec.width;
        int yMin = parentRec.y - this.borderItemOffset;
        int yMax = parentRec.y - this.borderItemOffset + parentRec.height;
        if (realLocation.x < xMin) {
            realLocation.x = xMin;
        }
        if (realLocation.x > xMax) {
            realLocation.x = xMax;
        }
        if (realLocation.y < yMin) {
            realLocation.y = yMin;
        }
        if (realLocation.y > yMax) {
            realLocation.y = yMax;
        }
        Rectangle maxRect = parentRec.getCopy();
        maxRect.shrink(-this.borderItemOffset, -this.borderItemOffset);
        while (maxRect.contains(realLocation.getLocation())) {
            maxRect.shrink(1, 1);
        }
        int pos = maxRect.getPosition(realLocation.getLocation());
        switch (pos) {
            case 1: {
                realLocation.y = yMin;
                break;
            }
            case 4: {
                realLocation.y = yMax;
                break;
            }
            case 16: {
                realLocation.x = xMax;
                break;
            }
            case 8: {
                realLocation.x = xMin;
                break;
            }
            case 17: {
                realLocation.x = xMax;
                realLocation.y = yMin;
                break;
            }
            case 9: {
                realLocation.x = xMin;
                realLocation.y = yMin;
                break;
            }
            case 20: {
                realLocation.x = xMax;
                realLocation.y = yMax;
                break;
            }
            case 12: {
                realLocation.x = xMin;
                realLocation.y = yMax;
            }
        }
        return realLocation;
    }

    protected Dimension getCornerDimension() {
        Dimension cornerDimension = null;
        IRoundedRectangleFigure roundedFigure = (IRoundedRectangleFigure)FigureUtils.findChildFigureInstance((IFigure)this.parentFigure, IRoundedRectangleFigure.class);
        if (roundedFigure != null) {
            cornerDimension = roundedFigure.getCornerDimensions().getCopy();
        }
        if (cornerDimension.width * 2 > this.parentFigure.getBounds().width) {
            cornerDimension.setWidth(this.parentFigure.getBounds().width / 2);
        }
        if (cornerDimension.height * 2 > this.parentFigure.getBounds().height()) {
            cornerDimension.setHeight(this.parentFigure.getBounds().height / 2);
        }
        return cornerDimension;
    }

    private Dimension getPortOffset(Dimension bounds) {
        Dimension portOffset = new Dimension();
        if (this.figure != null) {
            if (PortPositionEnum.INSIDE.equals((Object)this.position)) {
                portOffset.width = -bounds.width / 2;
                portOffset.height = -bounds.height / 2;
            } else if (PortPositionEnum.OUTSIDE.equals((Object)this.position)) {
                portOffset.width = bounds.width / 2 - 1;
                portOffset.height = bounds.height / 2 - 1;
            }
        }
        return portOffset;
    }

    public int getCurrentSideOfParent() {
        int defaultSkink = 10;
        Rectangle basisRectangle = new Rectangle(0, 0, this.parentFigure.getBounds().width, this.parentFigure.getBounds().height);
        int skink_width = this.constraint.width / 2;
        int skink_height = this.constraint.height / 2;
        if (skink_width <= 0) {
            skink_width = defaultSkink;
        }
        if (skink_height <= 0) {
            skink_height = defaultSkink;
        }
        Rectangle internalRectangle = basisRectangle.getShrinked(new Insets(skink_height, skink_width, skink_height, skink_width));
        int position = internalRectangle.getPosition(this.constraint.getTopLeft());
        return position;
    }

    public void relocate(IFigure target) {
        if (this.figure == null) {
            this.figure = target;
        }
        Rectangle proposedLocation = this.constraint.getCopy();
        proposedLocation.setLocation(this.constraint.getLocation().translate(this.parentFigure.getBounds().getTopLeft()));
        Point validLocation = this.getValidLocation(proposedLocation, target).getLocation();
        Rectangle rect = new Rectangle(validLocation, target.getPreferredSize());
        target.setBounds(rect);
        RoundedRectangleNodePlateFigure nodePlateFigure = (RoundedRectangleNodePlateFigure)FigureUtils.findChildFigureInstance((IFigure)this.figure, RoundedRectangleNodePlateFigure.class);
        if (nodePlateFigure != null) {
            if (this.figure instanceof RoundedRectangleNodePlateFigure) {
                for (Object child : nodePlateFigure.getChildren()) {
                    if (!(child instanceof IFigure)) continue;
                    ((IFigure)child).setBounds(rect);
                }
            }
            nodePlateFigure.invalidate();
        }
    }
}

