/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.emf.facet.efacet.sdk.ui.internal.wizard.page;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.papyrus.emf.facet.efacet.sdk.ui.internal.Messages;
import org.eclipse.papyrus.emf.facet.efacet.sdk.ui.internal.exported.wizard.page.ICreateFacetSetWizardPage;
import org.eclipse.ui.dialogs.WizardNewFileCreationPage;

public class CreateFacetSetWizardPage
extends WizardNewFileCreationPage
implements ICreateFacetSetWizardPage {
    private static final String FILE_EXTENSION = "efacet";
    private static final String MODEL_BASE = "My";

    public CreateFacetSetWizardPage(String pageId, IStructuredSelection selection) {
        super(pageId, selection);
        this.setTitle(Messages.CreateFacetSetWizardImpl_FacetModel);
        this.setDescription(Messages.CreateFacetSetWizardImpl_Create_new_facet_Set);
        this.setFileName("My.efacet");
        if (selection != null && !selection.isEmpty()) {
            this.getResource(selection);
        }
    }

    private void getResource(IStructuredSelection selection) {
        Object selectedElement = selection.iterator().next();
        if (selectedElement instanceof IResource) {
            IResource selectedResource = (IResource)selectedElement;
            if (selectedResource.getType() == 1) {
                selectedResource = selectedResource.getParent();
            }
            if (selectedResource instanceof IFolder || selectedResource instanceof IProject) {
                this.setContainerFullPath(selectedResource.getFullPath());
                String modelFileExt = FILE_EXTENSION;
                String modelFilename = "My.efacet";
                int i = 1;
                while (((IContainer)selectedResource).findMember(modelFilename) != null) {
                    modelFilename = MODEL_BASE + i + "." + FILE_EXTENSION;
                    ++i;
                }
                this.setFileName(modelFilename);
            }
        }
    }

    protected boolean validatePage() {
        boolean valid = super.validatePage();
        if (valid) {
            String extension = new Path(this.getFileName()).getFileExtension();
            if (extension == null || !FILE_EXTENSION.equalsIgnoreCase(extension)) {
                this.setErrorMessage(Messages.CreateFacetSetWizardImpl_File_extension_restriction);
                valid = false;
            }
            IPath iPath = this.getContainerFullPath();
        }
        return valid;
    }

    @Override
    public IFile getModelFile() {
        return ResourcesPlugin.getWorkspace().getRoot().getFile(this.getContainerFullPath().append(this.getFileName()));
    }
}

