/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.core.internal.architecture.merger;

import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.papyrus.infra.core.architecture.ArchitectureContext;
import org.eclipse.papyrus.infra.core.architecture.ArchitectureDescriptionLanguage;
import org.eclipse.papyrus.infra.core.architecture.ArchitectureFactory;
import org.eclipse.papyrus.infra.core.architecture.ArchitectureFramework;
import org.eclipse.papyrus.infra.core.architecture.ArchitecturePackage;
import org.eclipse.papyrus.infra.core.architecture.ArchitectureViewpoint;
import org.eclipse.papyrus.infra.core.architecture.RepresentationKind;
import org.eclipse.papyrus.infra.core.architecture.TreeViewerConfiguration;
import org.eclipse.papyrus.infra.core.internal.architecture.merger.ArchitectureExtensions;
import org.eclipse.papyrus.infra.core.internal.architecture.merger.ArchitectureViewpointRule;
import org.eclipse.papyrus.infra.core.internal.architecture.merger.RepresentationKindRule;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;

@Singleton
public class ArchitectureContextRule {
    @Extension
    private static ArchitectureFactory factory = ArchitectureFactory.eINSTANCE;
    @Inject
    @Extension
    private ArchitectureExtensions _architectureExtensions;
    @Inject
    @Extension
    private ArchitectureViewpointRule _architectureViewpointRule;
    @Inject
    @Extension
    private RepresentationKindRule _representationKindRule;
    private final HashMap<ArrayList<?>, ArchitectureDescriptionLanguage> _createCache_merged = CollectionLiterals.newHashMap();
    private final HashMap<ArrayList<?>, ArchitectureFramework> _createCache_merged_1 = CollectionLiterals.newHashMap();

    public boolean hasExtensions(ArchitectureContext context) {
        return this._architectureExtensions.isReferenced((EObject)context, ArchitecturePackage.Literals.ARCHITECTURE_CONTEXT__EXTENDED_CONTEXTS);
    }

    public boolean canExtend(ArchitectureContext extending, ArchitectureContext extended) {
        EClass _eClass_1;
        EClass _eClass = extending.eClass();
        return _eClass == (_eClass_1 = extended.eClass());
    }

    public <T extends ArchitectureContext> Iterable<T> extensions(T context) {
        Iterable _xifexpression = null;
        boolean _inExtensionsPhase = this._architectureExtensions.inExtensionsPhase();
        if (_inExtensionsPhase) {
            Functions.Function1 _function = it -> this.canExtend(context, (ArchitectureContext)it);
            _xifexpression = IterableExtensions.filter(this._architectureExtensions.invert((EObject)context, ArchitecturePackage.Literals.ARCHITECTURE_CONTEXT__EXTENDED_CONTEXTS), (Functions.Function1)_function);
        } else {
            _xifexpression = CollectionLiterals.emptyList();
        }
        return _xifexpression;
    }

    public <T extends ArchitectureContext> List<T> allExtensions(T context) {
        List _xifexpression = null;
        boolean _inExtensionsPhase = this._architectureExtensions.inExtensionsPhase();
        _xifexpression = _inExtensionsPhase ? IterableExtensions.toList(this.allExtensionsHelper(context, CollectionLiterals.newLinkedHashSet())) : CollectionLiterals.emptyList();
        return _xifexpression;
    }

    private <T extends ArchitectureContext> Iterable<T> allExtensionsHelper(T context, Set<T> result) {
        Set _xblockexpression = null;
        Functions.Function1 _function = it -> result.contains(it);
        Consumer<ArchitectureContext> _function_1 = it -> {
            result.add(it);
            this.allExtensionsHelper(it, result);
        };
        IterableExtensions.reject(this.extensions(context), (Functions.Function1)_function).forEach(_function_1);
        _xblockexpression = result;
        return _xblockexpression;
    }

    protected ArchitectureContext _merged(ArchitectureDescriptionLanguage context) {
        return this.merged(context, this._architectureExtensions.currentScope());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArchitectureDescriptionLanguage merged(ArchitectureDescriptionLanguage context, Object scope) {
        ArchitectureDescriptionLanguage _result;
        ArrayList _cacheKey = CollectionLiterals.newArrayList((Object[])new Object[]{context, scope});
        HashMap<ArrayList<?>, ArchitectureDescriptionLanguage> hashMap = this._createCache_merged;
        synchronized (hashMap) {
            ArchitectureDescriptionLanguage _createArchitectureDescriptionLanguage;
            if (this._createCache_merged.containsKey(_cacheKey)) {
                return this._createCache_merged.get(_cacheKey);
            }
            _result = _createArchitectureDescriptionLanguage = factory.createArchitectureDescriptionLanguage();
            this._createCache_merged.put(_cacheKey, _result);
        }
        this._init_merged(_result, context, scope);
        return _result;
    }

    private void _init_merged(ArchitectureDescriptionLanguage it, ArchitectureDescriptionLanguage context, Object scope) {
        this.merge(it, context);
    }

    <T extends ArchitectureContext> Set<T> merge(T target, T source) {
        Set<T> _of = Set.of(source);
        List<T> _allExtensions = this.allExtensions(source);
        Set _set = IterableExtensions.toSet((Iterable)Iterables.concat(_of, _allExtensions));
        Procedures.Procedure1 _function = it -> {
            Consumer<ArchitectureContext> _function_1 = it_1 -> this.copyContext(target, (ArchitectureContext)it_1);
            it.forEach(_function_1);
            this.mergeViewpoints(target, (Set<? extends ArchitectureContext>)it);
            ArchitectureExtensions.logf("Merged %s into %s", source, target);
        };
        return (Set)ObjectExtensions.operator_doubleArrow((Object)_set, (Procedures.Procedure1)_function);
    }

    private ArchitectureContext mergeViewpoints(ArchitectureContext target, Set<? extends ArchitectureContext> sources) {
        Procedures.Procedure1 _function = it -> {
            boolean _not;
            Functions.Function1 _function_1 = it_1 -> it_1.getViewpoints();
            Iterable allViewpoints = IterableExtensions.flatMap((Iterable)sources, (Functions.Function1)_function_1);
            EList _viewpoints = it.getViewpoints();
            Functions.Function1 _function_2 = it_1 -> it_1.getName();
            Functions.Function1 _function_3 = it_1 -> this._architectureViewpointRule.mergedViewpoint((String)it_1, sources);
            Iterable _map = IterableExtensions.map(this._architectureExtensions.mapUnique(allViewpoints, _function_2), (Functions.Function1)_function_3);
            Iterables.addAll((Collection)_viewpoints, (Iterable)_map);
            Functions.Function1 _function_4 = it_1 -> it_1.getDefaultViewpoints();
            Iterable allDefaults = IterableExtensions.flatMap((Iterable)sources, (Functions.Function1)_function_4);
            boolean _isEmpty = IterableExtensions.isEmpty((Iterable)allDefaults);
            boolean bl = _not = !_isEmpty;
            if (_not) {
                Functions.Function1 _function_5 = it_1 -> it_1.getName();
                Functions.Function1 _function_6 = it_1 -> it_1;
                Map viewpointsByName = IterableExtensions.toMap((Iterable)it.getViewpoints(), (Functions.Function1)_function_5, (Functions.Function1)_function_6);
                EList _defaultViewpoints = it.getDefaultViewpoints();
                Functions.Function1 _function_7 = it_1 -> it_1.getName();
                Functions.Function1 _function_8 = it_1 -> (ArchitectureViewpoint)viewpointsByName.get(it_1);
                Iterable _filterNull = IterableExtensions.filterNull((Iterable)IterableExtensions.map(this._architectureExtensions.mapUnique(allDefaults, _function_7), (Functions.Function1)_function_8));
                Iterables.addAll((Collection)_defaultViewpoints, (Iterable)_filterNull);
            }
        };
        return (ArchitectureContext)ObjectExtensions.operator_doubleArrow((Object)target, (Procedures.Procedure1)_function);
    }

    protected ArchitectureContext _merged(ArchitectureFramework context) {
        return this.merged(context, this._architectureExtensions.currentScope());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArchitectureFramework merged(ArchitectureFramework context, Object scope) {
        ArchitectureFramework _result;
        ArrayList _cacheKey = CollectionLiterals.newArrayList((Object[])new Object[]{context, scope});
        HashMap<ArrayList<?>, ArchitectureFramework> hashMap = this._createCache_merged_1;
        synchronized (hashMap) {
            ArchitectureFramework _createArchitectureFramework;
            if (this._createCache_merged_1.containsKey(_cacheKey)) {
                return this._createCache_merged_1.get(_cacheKey);
            }
            _result = _createArchitectureFramework = factory.createArchitectureFramework();
            this._createCache_merged_1.put(_cacheKey, _result);
        }
        this._init_merged_1(_result, context, scope);
        return _result;
    }

    private void _init_merged_1(ArchitectureFramework it, ArchitectureFramework context, Object scope) {
        this.merge(it, context);
    }

    private ArchitectureContext copyContext(ArchitectureContext target, ArchitectureContext source) {
        return this.copyContext(target, source, this.contextCopier(target));
    }

    private <T extends ArchitectureContext> T copyContext(T target, T source, Consumer<? super T> extensionMerger) {
        Procedures.Procedure1 _function = it -> {
            String _extensionPrefix_1;
            String _conversionCommandClass_1;
            String _creationCommandClass_1;
            this._architectureExtensions.copy(it, source);
            String _elvis = null;
            String _creationCommandClass = it.getCreationCommandClass();
            _elvis = _creationCommandClass != null ? _creationCommandClass : (_creationCommandClass_1 = source.getCreationCommandClass());
            it.setCreationCommandClass(_elvis);
            String _elvis_1 = null;
            String _conversionCommandClass = it.getConversionCommandClass();
            _elvis_1 = _conversionCommandClass != null ? _conversionCommandClass : (_conversionCommandClass_1 = source.getConversionCommandClass());
            it.setConversionCommandClass(_elvis_1);
            String _elvis_2 = null;
            String _extensionPrefix = it.getExtensionPrefix();
            _elvis_2 = _extensionPrefix != null ? _extensionPrefix : (_extensionPrefix_1 = source.getExtensionPrefix());
            it.setExtensionPrefix(_elvis_2);
            EList _elementTypes = it.getElementTypes();
            EList _elementTypes_1 = source.getElementTypes();
            Iterables.addAll((Collection)_elementTypes, (Iterable)_elementTypes_1);
            if (extensionMerger != null) {
                extensionMerger.accept((Object)source);
            }
        };
        return (T)((ArchitectureContext)ObjectExtensions.operator_doubleArrow(target, (Procedures.Procedure1)_function));
    }

    private Consumer<? super ArchitectureContext> _contextCopier(ArchitectureDescriptionLanguage adl) {
        Consumer<ArchitectureContext> _function = source -> {
            boolean _matched = false;
            if (source instanceof ArchitectureDescriptionLanguage && com.google.common.base.Objects.equal((Object)source, (Object)((ArchitectureDescriptionLanguage)source))) {
                _matched = true;
                Procedures.Procedure1 _function_1 = it -> {
                    EPackage _metamodel_1;
                    EList _representationKinds = it.getRepresentationKinds();
                    Functions.Function1 _function_2 = it_1 -> this._representationKindRule.merged((RepresentationKind)it_1);
                    List _map = ListExtensions.map((List)((ArchitectureDescriptionLanguage)source).getRepresentationKinds(), (Functions.Function1)_function_2);
                    Iterables.addAll((Collection)_representationKinds, (Iterable)_map);
                    EList _treeViewerConfigurations = it.getTreeViewerConfigurations();
                    Functions.Function1 _function_3 = it_1 -> this._architectureExtensions.merged((TreeViewerConfiguration)it_1);
                    List _map_1 = ListExtensions.map((List)((ArchitectureDescriptionLanguage)source).getTreeViewerConfigurations(), (Functions.Function1)_function_3);
                    Iterables.addAll((Collection)_treeViewerConfigurations, (Iterable)_map_1);
                    EPackage _elvis = null;
                    EPackage _metamodel = it.getMetamodel();
                    _elvis = _metamodel != null ? _metamodel : (_metamodel_1 = ((ArchitectureDescriptionLanguage)source).getMetamodel());
                    it.setMetamodel(_elvis);
                    EList _profiles = it.getProfiles();
                    EList _profiles_1 = ((ArchitectureDescriptionLanguage)source).getProfiles();
                    Iterables.addAll((Collection)_profiles, (Iterable)_profiles_1);
                };
                ObjectExtensions.operator_doubleArrow((Object)adl, (Procedures.Procedure1)_function_1);
            }
        };
        return _function;
    }

    private Consumer<? super ArchitectureContext> _contextCopier(ArchitectureContext context) {
        Consumer<ArchitectureContext> _function = source -> {
            Procedures.Procedure1 _function_1 = it -> {};
            ObjectExtensions.operator_doubleArrow((Object)context, (Procedures.Procedure1)_function_1);
        };
        return _function;
    }

    public void inferExtensions(ArchitectureContext context) {
        Functions.Function1 _function = it -> this.canExtend(context, (ArchitectureContext)it);
        Consumer<ArchitectureContext> _function_1 = it -> {
            EList _extendedContexts = context.getExtendedContexts();
            _extendedContexts.add(it);
        };
        IterableExtensions.take(this._architectureExtensions.excluding(IterableExtensions.filter(this.sortedInstances(context.getClass(), context.getQualifiedName()), (Functions.Function1)_function), context), (int)1).forEach(_function_1);
    }

    private List<? extends ArchitectureContext> sortedInstances(Class<? extends ArchitectureContext> type, String name) {
        Functions.Function1 _function = it -> it.getContexts();
        Functions.Function1 _function_1 = it -> {
            String _qualifiedName = it.getQualifiedName();
            return Objects.equals(_qualifiedName, name);
        };
        Functions.Function1 _function_2 = it -> this.allExtensions(it).size();
        return ListExtensions.reverseView((List)IterableExtensions.sortBy((Iterable)IterableExtensions.filter((Iterable)Iterables.filter((Iterable)IterableExtensions.flatMap(this._architectureExtensions.currentScope(), (Functions.Function1)_function), type), (Functions.Function1)_function_1), (Functions.Function1)_function_2));
    }

    public ArchitectureContext merged(ArchitectureContext context) {
        if (context instanceof ArchitectureDescriptionLanguage) {
            return this._merged((ArchitectureDescriptionLanguage)context);
        }
        if (context instanceof ArchitectureFramework) {
            return this._merged((ArchitectureFramework)context);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(context).toString());
    }

    private Consumer<? super ArchitectureContext> contextCopier(ArchitectureContext adl) {
        if (adl instanceof ArchitectureDescriptionLanguage) {
            return this._contextCopier((ArchitectureDescriptionLanguage)adl);
        }
        if (adl != null) {
            return this._contextCopier(adl);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(adl).toString());
    }
}

