/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.types.core.matchers.stereotype;

import java.util.HashSet;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.emf.type.core.IElementMatcher;
import org.eclipse.papyrus.uml.types.core.matchers.stereotype.StereotypeApplicationMatcherConfiguration;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Profile;

public class StereotypeApplicationMatcher
implements IElementMatcher {
    private List<String> stereotypesQualifiedNames;
    private String profileUri;

    public StereotypeApplicationMatcher(StereotypeApplicationMatcherConfiguration configuration) {
        this.profileUri = configuration.getProfileUri();
        this.stereotypesQualifiedNames = configuration.getStereotypesQualifiedNames();
    }

    public boolean matches(EObject eObject) {
        if (!(eObject instanceof Element)) {
            return false;
        }
        Element element = (Element)eObject;
        if (this.profileUri != null && !StereotypeApplicationMatcher.isProfileApplied(element, this.profileUri)) {
            return false;
        }
        if (element.getAppliedStereotypes().isEmpty()) {
            return false;
        }
        for (String stereotypeQualifiedName : this.stereotypesQualifiedNames) {
            if (element.getAppliedStereotype(stereotypeQualifiedName) != null) continue;
            return false;
        }
        return true;
    }

    public List<String> getStereotypesQualifiedNames() {
        return this.stereotypesQualifiedNames;
    }

    public void setStereotypesQualifiedNames(List<String> stereotypeQualifiedName) {
        this.stereotypesQualifiedNames = stereotypeQualifiedName;
    }

    public static boolean isProfileApplied(Element element, String profileURI) {
        Package package_ = element.getNearestPackage();
        if (package_ == null) {
            return false;
        }
        HashSet<String> appliedProfileByURI = new HashSet<String>();
        for (Profile appliedProfile : package_.getAllAppliedProfiles()) {
            appliedProfileByURI.add(appliedProfile.getURI());
        }
        return appliedProfileByURI.contains(profileURI);
    }
}

