/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.example.uml.nattable.empty.line.cell.editor;

import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.nebula.widgets.nattable.NatTable;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.ui.action.IMouseAction;
import org.eclipse.nebula.widgets.nattable.ui.binding.UiBindingRegistry;
import org.eclipse.nebula.widgets.nattable.ui.matcher.IMouseEventMatcher;
import org.eclipse.papyrus.infra.emf.gmf.command.GMFtoEMFCommandWrapper;
import org.eclipse.papyrus.infra.nattable.celleditor.config.ICellAxisConfiguration;
import org.eclipse.papyrus.infra.nattable.manager.table.INattableModelManager;
import org.eclipse.papyrus.infra.nattable.model.nattable.Table;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxis.IAxis;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxis.ITreeItemAxis;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisconfiguration.TreeFillingConfiguration;
import org.eclipse.papyrus.infra.nattable.mouse.action.AbstractCellMouseAction;
import org.eclipse.papyrus.infra.nattable.mouse.action.EmptyLineRowHeaderEventMatch;
import org.eclipse.papyrus.infra.nattable.utils.AxisUtils;
import org.eclipse.papyrus.infra.nattable.utils.NattableConfigAttributes;
import org.eclipse.papyrus.infra.services.edit.service.ElementEditServiceUtils;
import org.eclipse.papyrus.infra.services.edit.service.IElementEditService;
import org.eclipse.papyrus.uml.service.types.element.UMLElementTypes;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.UMLPackage;

public class CreateClassFromHeaderCellEditorConfiguration
implements ICellAxisConfiguration {
    public String getConfigurationId() {
        return "org.eclipse.papyrus.example.uml.nattable.empty.line.cell.editor.CreateClassFromHeaderCellEditorConfiguration";
    }

    public String getConfigurationDescription() {
        return "Create new Class on empty line";
    }

    public boolean handles(Table table, Object axisElement) {
        return false;
    }

    public void configureCellEditor(IConfigRegistry configRegistry, Object axis, String configLabel) {
        INattableModelManager manager = (INattableModelManager)configRegistry.getConfigAttribute(NattableConfigAttributes.NATTABLE_MODEL_MANAGER_CONFIG_ATTRIBUTE, "NORMAL", new String[]{"nattable_model_manager_id"});
        NatTable natTable = (NatTable)manager.getAdapter(NatTable.class);
        UiBindingRegistry uiBindingRegistry = natTable.getUiBindingRegistry();
        uiBindingRegistry.registerSingleClickBinding(this.getMouseEventMatcher(), this.getMouseAction());
    }

    private IMouseEventMatcher getMouseEventMatcher() {
        return new EmptyLineRowHeaderEventMatch(0, "ROW_HEADER", 1);
    }

    private IMouseAction getMouseAction() {
        return new CreateElementCellMouseAction();
    }

    private class CreateElementCellMouseAction
    extends AbstractCellMouseAction {
        private CreateElementCellMouseAction() {
        }

        public void doRun(NatTable natTable, MouseEvent event, Object rowElement, Object columnElement) {
            ITreeItemAxis currentAxis;
            ITreeItemAxis parentAxis;
            Object parentElement;
            if (rowElement instanceof ITreeItemAxis && ((ITreeItemAxis)rowElement).getElement() == null && (parentElement = (parentAxis = (currentAxis = (ITreeItemAxis)rowElement).getParent()).getElement()) instanceof TreeFillingConfiguration) {
                INattableModelManager manager;
                EObject creationParent;
                IAxis axisProvider = ((TreeFillingConfiguration)parentElement).getAxisUsedAsAxisProvider();
                Object representedElement = AxisUtils.getRepresentedElement((Object)axisProvider);
                if (UMLPackage.eINSTANCE.getPackage_PackagedElement().equals(representedElement) && (creationParent = (manager = (INattableModelManager)natTable.getConfigRegistry().getConfigAttribute(NattableConfigAttributes.NATTABLE_MODEL_MANAGER_CONFIG_ATTRIBUTE, "NORMAL", new String[]{"nattable_model_manager_id"})).getTable().getContext()) instanceof Package) {
                    CreateElementRequest request = new CreateElementRequest(creationParent, (IElementType)UMLElementTypes.CLASS);
                    IElementEditService service = ElementEditServiceUtils.getCommandProvider((EObject)creationParent);
                    ICommand cmd = service.getEditCommand((IEditCommandRequest)request);
                    request.getEditingDomain().getCommandStack().execute((Command)new GMFtoEMFCommandWrapper(cmd));
                }
            }
        }
    }
}

