/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.types.core.notification;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.gmf.runtime.emf.type.core.edithelper.IEditHelper;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.papyrus.infra.types.core.notification.events.AbstractTypesEvent;
import org.eclipse.papyrus.infra.types.core.notification.events.AdviceApprovedEvent;
import org.eclipse.papyrus.infra.types.core.notification.events.AdviceDisapprovedEvent;
import org.eclipse.papyrus.infra.types.core.notification.events.AdviceRequestEvent;
import org.eclipse.papyrus.infra.types.core.notification.events.EditHelperApprovedEvent;
import org.eclipse.papyrus.infra.types.core.notification.events.EditHelperDisapprovedEvent;
import org.eclipse.papyrus.infra.types.core.notification.events.ExecutableAdviceEvent;
import org.eclipse.papyrus.infra.types.core.notification.events.ExecutableEditHelperEvent;
import org.eclipse.papyrus.infra.types.core.notification.events.IdentityAdviceEvent;
import org.eclipse.papyrus.infra.types.core.notification.events.IdentityEditHelperEvent;
import org.eclipse.papyrus.infra.types.core.notification.events.UnexecutableAdviceEvent;
import org.eclipse.papyrus.infra.types.core.notification.events.UnexecutableEditHelperEvent;

public class TypesEventsChain {
    private long timestamp;
    private IEditHelper editHelper;
    private IEditCommandRequest req;
    private List<AbstractTypesEvent> adviceRequestConfigurationEvents = new ArrayList<AbstractTypesEvent>();
    private AbstractTypesEvent editHelperRequestConfigurationEvent = null;
    private List<AbstractTypesEvent> adviceApprovalEvents = new ArrayList<AbstractTypesEvent>();
    private AbstractTypesEvent editHelperApprovalEvent = null;
    private List<AbstractTypesEvent> beforeAdvicesCommandsEvents = new ArrayList<AbstractTypesEvent>();
    private List<AbstractTypesEvent> afterAdvicesCommandsEvents = new ArrayList<AbstractTypesEvent>();
    private AbstractTypesEvent editHelperCommandEvent = null;

    TypesEventsChain(IEditHelper editHelper, IEditCommandRequest req) {
        this.timestamp = System.currentTimeMillis();
        this.editHelper = editHelper;
        this.req = req;
    }

    public List<AbstractTypesEvent> getAdviceApprovalEvents() {
        return this.adviceApprovalEvents;
    }

    public void addAdviceApprovalEvent(AbstractTypesEvent adviceApprovalEvent) {
        if (adviceApprovalEvent instanceof AdviceDisapprovedEvent || adviceApprovalEvent instanceof AdviceApprovedEvent) {
            this.adviceApprovalEvents.add(adviceApprovalEvent);
        }
    }

    public AbstractTypesEvent getEditHelperApprovalEvent() {
        return this.editHelperApprovalEvent;
    }

    public void setEditHelperApprovalEvent(AbstractTypesEvent editHelperApprovalEvent) {
        if (editHelperApprovalEvent instanceof EditHelperDisapprovedEvent || editHelperApprovalEvent instanceof EditHelperApprovedEvent) {
            this.editHelperApprovalEvent = editHelperApprovalEvent;
        }
    }

    public List<AbstractTypesEvent> getBeforeAdvicesCommandsEvents() {
        return this.beforeAdvicesCommandsEvents;
    }

    public void addBeforeAdvicesCommandsEvent(AbstractTypesEvent beforeAdvicesCommandEvent) {
        if (beforeAdvicesCommandEvent instanceof ExecutableAdviceEvent || beforeAdvicesCommandEvent instanceof UnexecutableAdviceEvent || beforeAdvicesCommandEvent instanceof IdentityAdviceEvent) {
            this.beforeAdvicesCommandsEvents.add(beforeAdvicesCommandEvent);
        }
    }

    public List<AbstractTypesEvent> getAfterAdvicesCommandsEvents() {
        return this.afterAdvicesCommandsEvents;
    }

    public void addAfterAdvicesCommandsEvent(AbstractTypesEvent afterAdvicesCommandEvent) {
        if (afterAdvicesCommandEvent instanceof ExecutableAdviceEvent || afterAdvicesCommandEvent instanceof UnexecutableAdviceEvent || afterAdvicesCommandEvent instanceof IdentityAdviceEvent) {
            this.afterAdvicesCommandsEvents.add(afterAdvicesCommandEvent);
        }
    }

    public AbstractTypesEvent getEditHelperCommandEvent() {
        return this.editHelperCommandEvent;
    }

    public void setEditHelperCommandEvent(AbstractTypesEvent editHelperCommandEvent) {
        if (editHelperCommandEvent instanceof ExecutableEditHelperEvent || editHelperCommandEvent instanceof UnexecutableEditHelperEvent || editHelperCommandEvent instanceof IdentityEditHelperEvent) {
            this.editHelperCommandEvent = editHelperCommandEvent;
        }
    }

    public List<AbstractTypesEvent> getAllEvents() {
        ArrayList<AbstractTypesEvent> result = new ArrayList<AbstractTypesEvent>();
        if (!this.adviceRequestConfigurationEvents.isEmpty()) {
            result.addAll(this.adviceRequestConfigurationEvents);
        }
        if (this.editHelperRequestConfigurationEvent != null) {
            result.add(this.editHelperRequestConfigurationEvent);
        }
        if (!this.adviceApprovalEvents.isEmpty()) {
            result.addAll(this.adviceApprovalEvents);
        }
        if (this.editHelperApprovalEvent != null) {
            result.add(this.editHelperApprovalEvent);
        }
        if (!this.beforeAdvicesCommandsEvents.isEmpty()) {
            result.addAll(this.beforeAdvicesCommandsEvents);
        }
        if (this.editHelperCommandEvent != null) {
            result.add(this.editHelperCommandEvent);
        }
        if (!this.afterAdvicesCommandsEvents.isEmpty()) {
            result.addAll(this.afterAdvicesCommandsEvents);
        }
        return result;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public IEditCommandRequest getRequest() {
        return this.req;
    }

    public String getName() {
        return this.editHelper.getClass().getSimpleName();
    }

    public List<AbstractTypesEvent> getAdviceRequestConfigurationEvents() {
        return this.adviceRequestConfigurationEvents;
    }

    public void addAdviceRequestConfigurationEvent(AdviceRequestEvent adviceConfigureEvent) {
        this.adviceRequestConfigurationEvents.add(adviceConfigureEvent);
    }

    public AbstractTypesEvent getEditHelperRequestConfigurationEvent() {
        return this.editHelperRequestConfigurationEvent;
    }

    public void setEditHelperRequestConfigurationEvent(AbstractTypesEvent editHelperRequestConfigurationEvent) {
        this.editHelperRequestConfigurationEvent = editHelperRequestConfigurationEvent;
    }
}

