/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.navigation.ui;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.papyrus.infra.emf.utils.ServiceUtilsForEObject;
import org.eclipse.papyrus.infra.gmfdiag.navigation.Activator;
import org.eclipse.papyrus.infra.services.navigation.service.ExtendedNavigableElement;
import org.eclipse.papyrus.infra.services.navigation.service.NavigableElement;
import org.eclipse.papyrus.infra.services.navigation.service.NavigationService;
import org.eclipse.papyrus.infra.services.openelement.service.OpenElementService;
import org.eclipse.papyrus.infra.services.viewersearch.impl.ViewerSearchService;

public abstract class DynamicNavigate
extends ContributionItem {
    NavigationService navigationService;

    protected abstract EObject getSelection();

    public void showInModelExplorer(NavigableElement navigableElement) {
        Object semanticElement = null;
        if (navigableElement instanceof ExtendedNavigableElement) {
            semanticElement = ((ExtendedNavigableElement)navigableElement).getSemanticElement();
        }
        if (semanticElement != null) {
            try {
                this.navigationService.navigate(semanticElement, "org.eclipse.papyrus.views.modelexplorer.navigation.target");
            }
            catch (Exception e) {
                Activator.log.error((Throwable)e);
            }
        }
    }

    public void revealObject(Object object) {
        if (object instanceof EObject) {
            try {
                OpenElementService service = (OpenElementService)ServiceUtilsForEObject.getInstance().getService(OpenElementService.class, (Object)((EObject)object));
                service.openElement((EObject)object);
            }
            catch (Exception e) {
                Activator.log.error((Throwable)e);
            }
        }
    }

    public List<Object> getViewsToSelect(NavigableElement navElement, boolean onlyOpened) {
        if (navElement == null) {
            return null;
        }
        EObject element = null;
        if (navElement instanceof ExtendedNavigableElement && ((ExtendedNavigableElement)navElement).getSemanticElement() instanceof EObject) {
            element = (EObject)((ExtendedNavigableElement)navElement).getSemanticElement();
        }
        if (element != null) {
            ViewerSearchService viewerSearchService = null;
            try {
                viewerSearchService = (ViewerSearchService)ServiceUtilsForEObject.getInstance().getService(ViewerSearchService.class, element);
            }
            catch (Exception e) {
                Activator.log.error((Throwable)e);
            }
            if (viewerSearchService != null) {
                return viewerSearchService.getViewersInCurrentModel(element, null, false, onlyOpened);
            }
        }
        return new LinkedList<Object>();
    }
}

