/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.common.commands;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.editparts.AbstractConnectionEditPart;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.util.EditPartUtil;
import org.eclipse.papyrus.infra.gmfdiag.common.Activator;
import org.eclipse.papyrus.infra.gmfdiag.common.commands.AbstractFixEdgeAnchorDeferredCommand;
import org.eclipse.papyrus.infra.gmfdiag.common.commands.AbstractRefreshConnectionElementsRunnable;

public class FixEdgeAnchorsDeferredCommand
extends AbstractFixEdgeAnchorDeferredCommand {
    private Collection<?> connectionsEditPartToRefresh;

    public FixEdgeAnchorsDeferredCommand(TransactionalEditingDomain editingDomain, IGraphicalEditPart containerEP, Collection<?> connectionsEditPartToRefresh) {
        super(editingDomain, "Fix Edge Anchors", containerEP);
        this.connectionsEditPartToRefresh = new ArrayList(connectionsEditPartToRefresh);
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
        RefreshConnectionElementsRunnable refreshRunnable = new RefreshConnectionElementsRunnable(this.connectionsEditPartToRefresh, this.getContainerEP());
        EditPartUtil.synchronizeRunnableToMainThread((IGraphicalEditPart)this.getContainerEP(), (Runnable)((Object)refreshRunnable));
        Collection toRefresh = (Collection)refreshRunnable.getResult();
        Iterator iter = toRefresh.iterator();
        while (iter.hasNext()) {
            CompoundCommand cc = new CompoundCommand("Fix connections anchors");
            AbstractConnectionEditPart current = (AbstractConnectionEditPart)iter.next();
            this.addFixAnchorCommand(current, cc);
            if (cc.canExecute()) {
                cc.execute();
                continue;
            }
            Activator.log.warn("Command to fix the anchors is null");
        }
        return CommandResult.newOKCommandResult();
    }

    @Override
    protected void cleanup() {
        super.cleanup();
        this.connectionsEditPartToRefresh.clear();
    }

    private static class RefreshConnectionElementsRunnable
    extends AbstractRefreshConnectionElementsRunnable<Collection<AbstractConnectionEditPart>> {
        private Collection<?> connectionsEditPartToRefresh;

        public RefreshConnectionElementsRunnable(Collection<?> connectionsEditPartToRefresh, IGraphicalEditPart containerEP) {
            super(containerEP);
            this.connectionsEditPartToRefresh = connectionsEditPartToRefresh;
        }

        public void run() {
            this.getContainerEditPart().refresh();
            this.getContainerFigure().invalidate();
            this.getContainerFigure().validate();
            Iterator<?> iter = this.connectionsEditPartToRefresh.iterator();
            HashSet<AbstractConnectionEditPart> connectionsEP = new HashSet<AbstractConnectionEditPart>();
            this.setResult(connectionsEP);
            while (iter.hasNext()) {
                Object object = iter.next();
                if (!(object instanceof AbstractConnectionEditPart)) continue;
                connectionsEP.add((AbstractConnectionEditPart)object);
                this.refreshConnection((AbstractConnectionEditPart)object);
            }
            this.setStatus(Status.OK_STATUS);
        }
    }
}

