/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.emf.types.constraints.provider;

import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.IChildCreationExtender;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.emf.edit.provider.ItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.ItemProviderAdapter;
import org.eclipse.emf.edit.provider.ViewerNotification;
import org.eclipse.papyrus.infra.emf.types.constraints.ConstraintAdvicePackage;
import org.eclipse.papyrus.infra.emf.types.constraints.ElementTypeFilter;
import org.eclipse.papyrus.infra.filters.FiltersPackage;
import org.eclipse.papyrus.infra.types.ElementTypeConfiguration;

public class ElementTypeFilterItemProvider
extends ItemProviderAdapter
implements IEditingDomainItemProvider,
IStructuredItemContentProvider,
ITreeItemContentProvider,
IItemLabelProvider,
IItemPropertySource {
    public ElementTypeFilterItemProvider(AdapterFactory adapterFactory) {
        super(adapterFactory);
    }

    public List<IItemPropertyDescriptor> getPropertyDescriptors(Object object) {
        if (this.itemPropertyDescriptors == null) {
            super.getPropertyDescriptors(object);
            this.addNamePropertyDescriptor(object);
            this.addElementTypePropertyDescriptor(object);
            this.addRelationshipPropertyDescriptor(object);
        }
        return this.itemPropertyDescriptors;
    }

    protected void addNamePropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_Filter_name_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_Filter_name_feature", "_UI_Filter_type"), (EStructuralFeature)FiltersPackage.Literals.FILTER__NAME, true, false, false, ItemPropertyDescriptor.GENERIC_VALUE_IMAGE, null, null));
    }

    protected void addElementTypePropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_ElementTypeFilter_elementType_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_ElementTypeFilter_elementType_feature", "_UI_ElementTypeFilter_type"), (EStructuralFeature)ConstraintAdvicePackage.Literals.ELEMENT_TYPE_FILTER__ELEMENT_TYPE, true, false, true, null, null, null));
    }

    protected void addRelationshipPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_ElementTypeFilter_relationship_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_ElementTypeFilter_relationship_feature", "_UI_ElementTypeFilter_type"), (EStructuralFeature)ConstraintAdvicePackage.Literals.ELEMENT_TYPE_FILTER__RELATIONSHIP, true, false, false, ItemPropertyDescriptor.GENERIC_VALUE_IMAGE, null, null));
    }

    public Object getImage(Object object) {
        return this.overlayImage(object, this.getResourceLocator().getImage("full/obj16/ElementTypeFilter"));
    }

    protected boolean shouldComposeCreationImage() {
        return true;
    }

    public String getText(Object object) {
        String label;
        String operator;
        ElementTypeFilter filter = (ElementTypeFilter)object;
        switch (filter.getRelationship()) {
            case SPECIALIZATION_TYPE: {
                operator = " ~= ";
                break;
            }
            case SUBTYPE: {
                operator = " <= ";
                break;
            }
            case SUPERTYPE: {
                operator = " >= ";
                break;
            }
            default: {
                operator = " = ";
            }
        }
        ElementTypeConfiguration elementType = filter.getElementType();
        String string = label = elementType == null ? null : elementType.getIdentifier();
        if (label == null || label.isBlank()) {
            label = this.getString("_UI_ElementTypeFilter_type_noType");
        }
        return String.valueOf(this.getString("_UI_ElementTypeFilter_type")) + operator + label;
    }

    public void notifyChanged(Notification notification) {
        this.updateChildren(notification);
        switch (notification.getFeatureID(ElementTypeFilter.class)) {
            case 0: 
            case 1: 
            case 2: {
                this.fireNotifyChanged((Notification)new ViewerNotification(notification, notification.getNotifier(), false, true));
                return;
            }
        }
        super.notifyChanged(notification);
    }

    protected void collectNewChildDescriptors(Collection<Object> newChildDescriptors, Object object) {
        super.collectNewChildDescriptors(newChildDescriptors, object);
    }

    public ResourceLocator getResourceLocator() {
        return ((IChildCreationExtender)this.adapterFactory).getResourceLocator();
    }
}

