/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.internationalization.utils.utils;

import java.util.Locale;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.papyrus.infra.internationalization.common.utils.InternationalizationPreferencesUtils;
import org.eclipse.papyrus.infra.internationalization.utils.QualifiedNameUtils;
import org.eclipse.papyrus.infra.internationalization.utils.utils.LabelInternationalizationUtils;
import org.eclipse.papyrus.infra.nattable.model.nattable.Table;

public class LabelInternationalization {
    private static LabelInternationalization instance;

    protected LabelInternationalization() {
    }

    public static LabelInternationalization getInstance() {
        if (instance == null) {
            instance = new LabelInternationalization();
        }
        return instance;
    }

    public String getDiagramLabelWithoutName(Diagram diagram) {
        return this.getDiagramLabelWithoutName(diagram, true);
    }

    public String getDiagramLabelWithoutName(Diagram diagram, boolean localize) {
        return LabelInternationalizationUtils.getLabelWithoutSubstract((EObject)diagram, localize);
    }

    public String getDiagramLabel(Diagram diagram) {
        return this.getDiagramLabel(diagram, true);
    }

    public String getDiagramLabel(Diagram diagram, boolean localize) {
        String result = null;
        if (diagram.eResource() != null && this.getInternationalizationPreference(diagram)) {
            result = this.getDiagramLabelWithoutName(diagram, localize);
        }
        return result != null ? result : diagram.getName();
    }

    public void setDiagramLabel(Diagram diagram, String value, Locale locale) {
        LabelInternationalizationUtils.setLabel((EObject)diagram, value, locale);
    }

    public void setInternationalizationPreference(Diagram diagram, boolean value) {
        InternationalizationPreferencesUtils.setInternationalizationPreference((EObject)QualifiedNameUtils.getOwner((Diagram)diagram), (boolean)value);
    }

    public boolean getInternationalizationPreference(Diagram diagram) {
        return InternationalizationPreferencesUtils.getInternationalizationPreference((EObject)QualifiedNameUtils.getOwner((Diagram)diagram));
    }

    public Command getSetDiagramLabelCommand(EditingDomain domain, Diagram diagram, String value, Locale locale) {
        return LabelInternationalizationUtils.getSetLabelCommand(domain, (EObject)diagram, value, locale);
    }

    public String getTableLabelWithoutName(Table table) {
        return this.getTableLabelWithoutName(table, true);
    }

    public String getTableLabelWithoutName(Table table, boolean localize) {
        return LabelInternationalizationUtils.getLabelWithoutSubstract((EObject)table, localize);
    }

    public String getTableLabel(Table table) {
        return this.getTableLabel(table, true);
    }

    public String getTableLabel(Table table, boolean localize) {
        String result = null;
        if (table.eResource() != null && this.getInternationalizationPreference(table)) {
            result = this.getTableLabelWithoutName(table, localize);
        }
        return result != null ? result : table.getName();
    }

    public void setTableLabel(Table table, String value, Locale locale) {
        LabelInternationalizationUtils.setLabel((EObject)table, value, locale);
    }

    public void setInternationalizationPreference(Table table, boolean value) {
        EObject tableOwner = table.getOwner();
        if (tableOwner == null) {
            tableOwner = table.getContext();
        }
        InternationalizationPreferencesUtils.setInternationalizationPreference((EObject)tableOwner, (boolean)value);
    }

    public boolean getInternationalizationPreference(Table table) {
        EObject tableOwner = table.getOwner();
        if (tableOwner == null) {
            tableOwner = table.getContext();
        }
        return InternationalizationPreferencesUtils.getInternationalizationPreference((EObject)tableOwner);
    }

    public Command getSetTableLabelCommand(EditingDomain domain, Table table, String value, Locale locale) {
        return LabelInternationalizationUtils.getSetLabelCommand(domain, (EObject)table, value, locale);
    }
}

