/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.tools.commands;

import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.eclipse.emf.common.command.AbstractCommand;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.util.UMLUtil;

public class ReorderStereotypeApplicationsCommand
extends AbstractCommand {
    private final Element element;
    private final List<Stereotype> stereotypeOrdering;
    private EList<EObject> resourceContents;
    private int[] positions;
    private EList<EObject> oldOrdering;
    private EList<EObject> newOrdering;

    public ReorderStereotypeApplicationsCommand(Element element, List<? extends Stereotype> newOrdering) {
        super("Reorder Applied Stereotypes");
        this.element = element;
        this.stereotypeOrdering = List.copyOf(newOrdering);
    }

    protected boolean prepare() {
        boolean result = true;
        this.oldOrdering = new BasicEList.FastCompare((Collection)this.element.getStereotypeApplications());
        if (this.stereotypeOrdering.size() != this.oldOrdering.size() || this.oldOrdering.stream().map(EObject::eResource).distinct().count() != 1L) {
            result = false;
        } else {
            this.resourceContents = ((EObject)this.oldOrdering.get(0)).eResource().getContents();
            this.newOrdering = (EList)this.stereotypeOrdering.stream().map(arg_0 -> ((Element)this.element).getStereotypeApplication(arg_0)).filter(Objects::nonNull).collect(Collectors.toCollection(BasicEList.FastCompare::new));
            if (this.newOrdering.size() != this.oldOrdering.size()) {
                result = false;
            } else {
                this.positions = this.oldOrdering.stream().mapToInt(arg_0 -> this.resourceContents.indexOf(arg_0)).filter(index -> index >= 0).sorted().toArray();
            }
        }
        return result;
    }

    public void execute() {
        EObject[] dummies = (EObject[])IntStream.range(0, this.oldOrdering.size()).mapToObj(__ -> EcoreFactory.eINSTANCE.createEObject()).toArray(EObject[]::new);
        int i = 0;
        while (i < dummies.length) {
            this.resourceContents.set(this.positions[i], (Object)dummies[i]);
            ++i;
        }
        this.oldOrdering.forEach(sa -> UMLUtil.setBaseElement((EObject)sa, null));
        i = 0;
        while (i < this.positions.length) {
            this.resourceContents.set(this.positions[i], (Object)((EObject)this.newOrdering.get(i)));
            UMLUtil.setBaseElement((EObject)((EObject)this.newOrdering.get(i)), (Element)this.element);
            ++i;
        }
    }

    public void undo() {
        this.swapOrderings();
        this.execute();
    }

    private void swapOrderings() {
        EList<EObject> swap = this.oldOrdering;
        this.oldOrdering = this.newOrdering;
        this.newOrdering = swap;
    }

    public void redo() {
        this.swapOrderings();
        this.execute();
    }

    public Collection<?> getAffectedObjects() {
        BasicEList.FastCompare result = new BasicEList.FastCompare(this.newOrdering.size() + 1);
        result.add(this.element);
        result.addAll(this.newOrdering);
        return result;
    }
}

