/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.hyperlink.ui;

import java.util.Collection;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.emf.utils.ServiceUtilsForEObject;
import org.eclipse.papyrus.infra.hyperlink.Activator;
import org.eclipse.papyrus.infra.hyperlink.helper.AbstractHyperLinkHelper;
import org.eclipse.papyrus.infra.hyperlink.helper.CompositeHyperlinkHelper;
import org.eclipse.papyrus.infra.hyperlink.messages.Messages;
import org.eclipse.papyrus.infra.hyperlink.object.HyperLinkObject;
import org.eclipse.papyrus.infra.hyperlink.object.HyperLinkSpecificObject;
import org.eclipse.papyrus.infra.hyperlink.ui.AbstractHyperLinkTab;
import org.eclipse.papyrus.infra.services.labelprovider.service.LabelProviderService;
import org.eclipse.papyrus.infra.widgets.providers.CollectionContentProvider;
import org.eclipse.papyrus.infra.widgets.util.PopupButtonMenu;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Table;

public class HyperLinkTab
extends AbstractHyperLinkTab {
    protected TabItem hyperlinksTab;
    protected Table hyperLinkListTable;
    protected Button newHyperLinkbutton;
    protected Button modifyHyperLinkButton;
    protected Button removeHyperLinkButton;
    protected Button upHyperLinkButton;
    protected Button downHyperLinkButton;
    protected TableViewer tableViewer;

    public HyperLinkTab() {
    }

    public HyperLinkTab(String tabId, Collection<? extends AbstractHyperLinkHelper> helpers) {
        super(tabId, helpers.size() == 1 ? helpers.iterator().next() : new CompositeHyperlinkHelper(helpers));
    }

    public TableViewer getTableViewer() {
        return this.tableViewer;
    }

    public void setHyperlinkObjects(List<HyperLinkObject> hyperlinkObjects) {
        this.getHyperlinkObjects().clear();
        this.getHyperlinkObjects().addAll(hyperlinkObjects);
    }

    @Override
    public void init(TabFolder tabFolder, List<HyperLinkObject> hyperlinkObjects, EObject element) {
        super.init(tabFolder, hyperlinkObjects, element);
        this.hyperlinksTab = new TabItem(tabFolder, 0);
        this.hyperlinksTab.setText(Messages.HyperLinkTab_title);
        Composite diagramComposite = new Composite((Composite)tabFolder, 0);
        this.hyperlinksTab.setControl((Control)diagramComposite);
        GridData gridData4 = new GridData();
        gridData4.horizontalAlignment = 4;
        gridData4.verticalAlignment = 2;
        GridData gridData3 = new GridData();
        gridData3.horizontalAlignment = 4;
        gridData3.verticalAlignment = 2;
        GridData gridData2 = new GridData();
        gridData2.horizontalAlignment = 4;
        gridData2.verticalAlignment = 2;
        GridData gridData1 = new GridData();
        gridData1.verticalAlignment = 4;
        gridData1.grabExcessHorizontalSpace = true;
        gridData1.grabExcessVerticalSpace = true;
        gridData1.verticalSpan = 6;
        gridData1.horizontalAlignment = 4;
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.makeColumnsEqualWidth = false;
        diagramComposite.setLayout((Layout)gridLayout);
        CLabel listLabel = new CLabel(diagramComposite, 32);
        listLabel.setText(Messages.HyperLinkTab_Listof);
        listLabel.setEnabled(false);
        new Label(diagramComposite, 0);
        this.hyperLinkListTable = new Table(diagramComposite, 2050);
        this.tableViewer = new TableViewer(this.hyperLinkListTable);
        this.newHyperLinkbutton = new Button(diagramComposite, 8);
        this.newHyperLinkbutton.setText("");
        this.newHyperLinkbutton.setImage(org.eclipse.papyrus.infra.widgets.Activator.getDefault().getImage("/icons/Add_16x16.gif"));
        this.newHyperLinkbutton.setLayoutData((Object)gridData4);
        this.newHyperLinkbutton.setToolTipText("New hyperlink");
        this.hyperLinkListTable.setHeaderVisible(false);
        this.hyperLinkListTable.setToolTipText(Messages.HyperLinkTab_SetOf);
        this.hyperLinkListTable.setLayoutData((Object)gridData1);
        this.hyperLinkListTable.setLinesVisible(false);
        this.modifyHyperLinkButton = new Button(diagramComposite, 8);
        this.modifyHyperLinkButton.setImage(org.eclipse.papyrus.infra.widgets.Activator.getDefault().getImage("/icons/Edit_16x16.gif"));
        this.modifyHyperLinkButton.setToolTipText("Edit hyperlink");
        this.removeHyperLinkButton = new Button(diagramComposite, 8);
        this.removeHyperLinkButton.setText("");
        this.removeHyperLinkButton.setImage(org.eclipse.papyrus.infra.widgets.Activator.getDefault().getImage("/icons/Delete_16x16.gif"));
        this.removeHyperLinkButton.setToolTipText("Remove hyperlink");
        this.upHyperLinkButton = new Button(diagramComposite, 8);
        this.upHyperLinkButton.setImage(org.eclipse.papyrus.infra.widgets.Activator.getDefault().getImage("/icons/ArrowUp_16x16.gif"));
        this.upHyperLinkButton.setToolTipText("Move hyperlink up");
        this.upHyperLinkButton.setLayoutData((Object)gridData2);
        this.downHyperLinkButton = new Button(diagramComposite, 8);
        this.downHyperLinkButton.setImage(org.eclipse.papyrus.infra.widgets.Activator.getDefault().getImage("/icons/ArrowDown_16x16.gif"));
        this.downHyperLinkButton.setToolTipText("Move hyperlink down");
        this.downHyperLinkButton.setLayoutData((Object)gridData3);
        this.addListeners();
        this.tableViewer.setContentProvider((IContentProvider)CollectionContentProvider.instance);
        this.setHyperlinkObjects(this.getHyperLinkHelper().getFilteredObject(hyperlinkObjects));
        this.updateButtonEnablement(null);
        LabelProvider provider = null;
        if (element != null) {
            try {
                provider = ((LabelProviderService)ServiceUtilsForEObject.getInstance().getService(LabelProviderService.class, (Object)element)).getLabelProvider();
            }
            catch (ServiceException ex) {
                Activator.log.error((Throwable)ex);
            }
        }
        if (provider == null) {
            provider = new LabelProvider();
        }
        this.tableViewer.setLabelProvider((IBaseLabelProvider)provider);
        this.getTableViewer().setInput(this.getHyperlinkObjects());
    }

    private void updateButtonEnablement(SelectionChangedEvent event) {
        IStructuredSelection selection;
        IStructuredSelection iStructuredSelection = selection = event == null ? (IStructuredSelection)this.tableViewer.getSelection() : (IStructuredSelection)event.getSelection();
        if (selection == null) {
            this.getRemoveHyperLinkButton().setEnabled(false);
            this.getModifyHyperLinkButton().setEnabled(false);
            this.getUpHyperLinkButton().setEnabled(false);
            this.getDownHyperLinkButton().setEnabled(false);
        } else {
            int index = this.getTableViewer().getTable().getSelectionIndex();
            this.getUpHyperLinkButton().setEnabled(index > 0);
            this.getDownHyperLinkButton().setEnabled(index >= 0 && index < this.getHyperlinkObjects().size() - 1);
            this.getRemoveHyperLinkButton().setEnabled(true);
            this.getModifyHyperLinkButton().setEnabled(!selection.toList().stream().anyMatch(HyperLinkSpecificObject.class::isInstance));
        }
    }

    protected void addListeners() {
        this.getTableViewer().addSelectionChangedListener(this::updateButtonEnablement);
        this.getRemoveHyperLinkButton().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (HyperLinkTab.this.getTableViewer().getTable().getSelection().length != 0) {
                    for (Object object : (IStructuredSelection)HyperLinkTab.this.getTableViewer().getSelection()) {
                        HyperLinkTab.this.getHyperlinkObjects().remove(object);
                        HyperLinkTab.this.getTableViewer().setInput(HyperLinkTab.this.getHyperlinkObjects());
                    }
                }
            }
        });
        this.getUpHyperLinkButton().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (HyperLinkTab.this.getTableViewer().getTable().getSelection().length != 0) {
                    Object elt = ((IStructuredSelection)HyperLinkTab.this.getTableViewer().getSelection()).getFirstElement();
                    if (HyperLinkTab.this.getHyperlinkObjects().indexOf(elt) == 0) {
                        return;
                    }
                    for (HyperLinkObject currentHyperLinkDoc : (IStructuredSelection)HyperLinkTab.this.getTableViewer().getSelection()) {
                        int index = HyperLinkTab.this.getHyperlinkObjects().indexOf(currentHyperLinkDoc);
                        HyperLinkTab.this.getHyperlinkObjects().remove(currentHyperLinkDoc);
                        HyperLinkTab.this.getHyperlinkObjects().add(index - 1, currentHyperLinkDoc);
                        HyperLinkTab.this.getTableViewer().setInput(HyperLinkTab.this.getHyperlinkObjects());
                    }
                    HyperLinkTab.this.updateButtonEnablement(null);
                }
            }
        });
        this.getDownHyperLinkButton().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (HyperLinkTab.this.getTableViewer().getTable().getSelection().length != 0) {
                    Object[] block = ((IStructuredSelection)HyperLinkTab.this.getTableViewer().getSelection()).toArray();
                    if (HyperLinkTab.this.getHyperlinkObjects().indexOf(block[block.length - 1]) == HyperLinkTab.this.getHyperlinkObjects().size() - 1) {
                        return;
                    }
                    int i = block.length - 1;
                    while (i >= 0) {
                        HyperLinkObject currentobject = (HyperLinkObject)block[i];
                        int index = HyperLinkTab.this.getHyperlinkObjects().indexOf(currentobject);
                        HyperLinkTab.this.getHyperlinkObjects().remove(currentobject);
                        HyperLinkTab.this.getHyperlinkObjects().add(index + 1, currentobject);
                        HyperLinkTab.this.getTableViewer().setInput(HyperLinkTab.this.getHyperlinkObjects());
                        --i;
                    }
                    HyperLinkTab.this.updateButtonEnablement(null);
                }
            }
        });
        final Runnable addHandler = new Runnable(){

            @Override
            public void run() {
                HyperLinkTab.this.getHyperLinkHelper().executeNewMousePressed(HyperLinkTab.this.hyperlinksTab.getControl().getShell(), HyperLinkTab.this.getHyperlinkObjects(), HyperLinkTab.this.getElement());
                HyperLinkTab.this.setInput(HyperLinkTab.this.getHyperlinkObjects());
            }
        };
        if (!this.isCompositeHelper()) {
            this.getNewHyperLinkbutton().addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    addHandler.run();
                }
            });
        } else {
            this.addNewHyperLinkMenuActions(addHandler);
        }
        this.getModifyHyperLinkButton().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (HyperLinkTab.this.getTableViewer().getTable().getSelection().length != 0) {
                    HyperLinkObject hyperLinkObject = (HyperLinkObject)((IStructuredSelection)HyperLinkTab.this.getTableViewer().getSelection()).getFirstElement();
                    HyperLinkTab.this.getHyperLinkHelper().executeEditMousePressed(HyperLinkTab.this.hyperlinksTab.getControl().getShell(), HyperLinkTab.this.getHyperlinkObjects(), hyperLinkObject, HyperLinkTab.this.getElement());
                    HyperLinkTab.this.setInput(HyperLinkTab.this.getHyperlinkObjects());
                }
            }
        });
    }

    private void addNewHyperLinkMenuActions(final Runnable addNewHyperlinkHandler) {
        PopupButtonMenu menu = new PopupButtonMenu(this.getNewHyperLinkbutton());
        for (final AbstractHyperLinkHelper abstractHyperLinkHelper : ((CompositeHyperlinkHelper)this.getHyperLinkHelper()).getHelpers()) {
            Action action = new Action(abstractHyperLinkHelper.getNameofManagedHyperLink()){

                public void run() {
                    ((CompositeHyperlinkHelper)HyperLinkTab.this.getHyperLinkHelper()).setActiveHelper(abstractHyperLinkHelper);
                    addNewHyperlinkHandler.run();
                }
            };
            action.setToolTipText(NLS.bind((String)Messages.HyperLinkTab_addTooltip, (Object)abstractHyperLinkHelper.getNameofManagedHyperLink()));
            menu.addAction((IAction)action);
        }
    }

    private Button getNewHyperLinkbutton() {
        return this.newHyperLinkbutton;
    }

    protected boolean isCompositeHelper() {
        return this.getHyperLinkHelper() instanceof CompositeHyperlinkHelper;
    }

    private Button getModifyHyperLinkButton() {
        return this.modifyHyperLinkButton;
    }

    private Button getRemoveHyperLinkButton() {
        return this.removeHyperLinkButton;
    }

    private Button getUpHyperLinkButton() {
        return this.upHyperLinkButton;
    }

    private Button getDownHyperLinkButton() {
        return this.downHyperLinkButton;
    }

    @Override
    public void setInput(List<HyperLinkObject> hyperlinkObjects) {
        if (!this.getTableViewer().getControl().isDisposed()) {
            this.setHyperlinkObjects(this.getHyperLinkHelper().getFilteredObject(hyperlinkObjects));
            this.getTableViewer().setInput(this.getHyperlinkObjects());
        } else {
            Activator.log.warn("This hyperlink tab has been disposed");
        }
    }
}

