/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cbi.p2repo.p2.util;

import java.io.File;
import java.net.URI;
import org.eclipse.cbi.p2repo.p2.util.BackgroundProvisioningAgent;
import org.eclipse.cbi.p2repo.util.P2RepoUtil;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.equinox.internal.p2.metadata.expression.LDAPFilter;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.core.IProvisioningAgentProvider;
import org.eclipse.equinox.p2.core.spi.IAgentServiceFactory;
import org.eclipse.equinox.p2.engine.IProfileRegistry;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.VersionRange;
import org.eclipse.equinox.p2.metadata.expression.ExpressionUtil;
import org.eclipse.equinox.p2.metadata.expression.IExpression;
import org.eclipse.equinox.p2.metadata.expression.IMatchExpression;
import org.eclipse.equinox.p2.planner.IPlanner;
import org.eclipse.equinox.p2.repository.IRepositoryManager;

public class P2Utils {
    public static IProvisioningAgent createDedicatedProvisioningAgent(URI location) throws CoreException {
        IProvisioningAgentProvider agentProvider = null;
        try {
            agentProvider = (IProvisioningAgentProvider)P2RepoUtil.getPlugin().getService(IProvisioningAgentProvider.class);
            IProvisioningAgent agent = agentProvider.createAgent(location);
            BackgroundProvisioningAgent backgroundProvisioningAgent = new BackgroundProvisioningAgent(agent);
            return backgroundProvisioningAgent;
        }
        finally {
            P2RepoUtil.getPlugin().ungetService((Object)agentProvider);
        }
    }

    public static String filterToString(IMatchExpression<IInstallableUnit> filter) {
        IExpression lhs;
        IExpression expr;
        Object param;
        if (filter == null) {
            return null;
        }
        Object[] params = filter.getParameters();
        if (params.length == 1 && (param = params[0]) instanceof LDAPFilter && (expr = ExpressionUtil.getOperand(filter)).getExpressionType() == 12 && (lhs = ExpressionUtil.getLHS((IExpression)expr)).getExpressionType() == 13 && "properties".equals(ExpressionUtil.getName((IExpression)lhs)) && ExpressionUtil.getRHS((IExpression)expr).getExpressionType() == 17) {
            return "LDAP Filter: " + param.toString();
        }
        return filter.toString();
    }

    public static IProvisioningAgent getDefaultProvisioningAgent() throws CoreException {
        String filter = null;
        File defaultLocation = P2Utils.getDefaultProvisioningAgentLocation();
        URI defaultLocationURI = null;
        if (defaultLocation != null) {
            defaultLocationURI = defaultLocation.toURI();
            filter = "(locationURI=" + defaultLocationURI + ')';
        }
        try {
            return (IProvisioningAgent)P2RepoUtil.getPlugin().getService(IProvisioningAgent.class, filter);
        }
        catch (CoreException coreException) {
            IProvisioningAgentProvider agentProvider = (IProvisioningAgentProvider)P2RepoUtil.getPlugin().getService(IProvisioningAgentProvider.class);
            try {
                IProvisioningAgent iProvisioningAgent = agentProvider.createAgent(defaultLocationURI);
                return iProvisioningAgent;
            }
            finally {
                P2RepoUtil.getPlugin().ungetService((Object)agentProvider);
            }
        }
    }

    public static File getDefaultProvisioningAgentLocation() {
        String userHome = System.getProperty("user.home");
        if (userHome == null) {
            return null;
        }
        File home = new File(userHome);
        File cbiP2RepoHome = new File(home, ".cbiP2Repo");
        if (!cbiP2RepoHome.isDirectory() && !cbiP2RepoHome.mkdirs()) {
            return null;
        }
        File agentLocation = new File(cbiP2RepoHome, "p2agent");
        if (!agentLocation.isDirectory() && !agentLocation.mkdirs()) {
            return null;
        }
        return agentLocation;
    }

    private static <T> T getP2Service(IProvisioningAgent agent, Class<T> clazz) {
        try {
            Object service;
            IProvisioningAgent agentParam = agent;
            if (agent == null) {
                agent = P2Utils.getDefaultProvisioningAgent();
            }
            if ((service = agent.getService(clazz.getName())) == null) {
                String filter = "(p2.agent.servicename=" + clazz.getName() + ")";
                IAgentServiceFactory serviceFactory = (IAgentServiceFactory)P2RepoUtil.getPlugin().getService(IAgentServiceFactory.class, filter);
                service = serviceFactory.createService(agent);
                P2RepoUtil.getPlugin().ungetService((Object)serviceFactory);
            }
            T result = clazz.cast(service);
            P2RepoUtil.getPlugin().ungetService((Object)agent);
            if (result != null) {
                if (agentParam != null && agentParam instanceof BackgroundProvisioningAgent) {
                    ((BackgroundProvisioningAgent)agentParam).registerTask();
                }
                return result;
            }
        }
        catch (RuntimeException t) {
            throw t;
        }
        catch (Exception t) {
            throw new RuntimeException(t);
        }
        throw new RuntimeException("p2 service " + clazz.getName() + "not available");
    }

    public static IPlanner getPlanner(IProvisioningAgent agent) {
        return P2Utils.getP2Service(agent, IPlanner.class);
    }

    public static IProfileRegistry getProfileRegistry(IProvisioningAgent agent) {
        return P2Utils.getP2Service(agent, IProfileRegistry.class);
    }

    public static <T extends IRepositoryManager<?>> T getRepositoryManager(Class<T> clazz) {
        return (T)((IRepositoryManager)P2Utils.getP2Service(null, clazz));
    }

    public static <T extends IRepositoryManager<?>> T getRepositoryManager(IProvisioningAgent agent, Class<T> clazz) {
        return (T)((IRepositoryManager)P2Utils.getP2Service(agent, clazz));
    }

    public static void stopProvisioningAgent(IProvisioningAgent agent) {
        if (agent != null) {
            agent.stop();
        }
    }

    public static void ungetPlanner(IProvisioningAgent agent, IPlanner planner) {
        if (agent != null && agent instanceof BackgroundProvisioningAgent) {
            ((BackgroundProvisioningAgent)agent).unregisterTask();
        }
    }

    public static void ungetProfileRegistry(IProvisioningAgent agent, IProfileRegistry registry) {
        if (agent != null && agent instanceof BackgroundProvisioningAgent) {
            ((BackgroundProvisioningAgent)agent).unregisterTask();
        }
    }

    public static void ungetRepositoryManager(IProvisioningAgent agent, IRepositoryManager<?> manager) {
        if (agent != null && agent instanceof BackgroundProvisioningAgent) {
            ((BackgroundProvisioningAgent)agent).unregisterTask();
        }
    }

    public static String versionRangeToString(VersionRange versionRange) {
        if (versionRange == null) {
            return null;
        }
        StringBuffer bld = new StringBuffer();
        if (versionRange.getIncludeMinimum() && versionRange.getIncludeMaximum() && versionRange.getMinimum().equals(versionRange.getMaximum())) {
            bld.append('[');
            versionRange.getMinimum().toString(bld);
            bld.append(']');
        } else {
            versionRange.toString(bld);
        }
        return bld.toString();
    }
}

