/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.common.parser;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.common.core.command.UnexecutableCommand;
import org.eclipse.gmf.runtime.common.ui.services.parser.IParser;
import org.eclipse.gmf.runtime.common.ui.services.parser.IParserEditStatus;
import org.eclipse.gmf.runtime.common.ui.services.parser.ParserEditStatus;
import org.eclipse.gmf.runtime.emf.commands.core.command.CompositeTransactionalCommand;
import org.eclipse.gmf.runtime.emf.type.core.commands.SetValueCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.SetRequest;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.uml.diagram.common.parser.HTMLCleaner;
import org.eclipse.papyrus.uml.tools.namereferences.NameReferencesHelper;
import org.eclipse.uml2.uml.Comment;
import org.eclipse.uml2.uml.UMLPackage;

public class CommentParser
implements IParser {
    public boolean areSemanticElementsAffected(EObject listener, Object notification) {
        return false;
    }

    public List getSemanticElementsBeingParsed(EObject element) {
        ArrayList<EObject> list = new ArrayList<EObject>();
        list.add(element);
        return list;
    }

    public IContentAssistProcessor getCompletionProcessor(IAdaptable element) {
        return null;
    }

    public String getEditString(IAdaptable element, int flags) {
        Comment comment = this.doAdapt(element);
        if (comment == null) {
            return "<NULL COMMENT>";
        }
        try {
            return HTMLCleaner.removeHTMLTags(HTMLCleaner.preClean(comment.getBody()));
        }
        catch (Exception e) {
            return comment.getBody();
        }
    }

    public ICommand getParseCommand(IAdaptable element, String newString, int flags) {
        Comment comment = this.doAdapt(element);
        if (comment == null) {
            return UnexecutableCommand.INSTANCE;
        }
        TransactionalEditingDomain editingDomain = TransactionUtil.getEditingDomain((EObject)comment);
        if (editingDomain == null) {
            return UnexecutableCommand.INSTANCE;
        }
        CompositeTransactionalCommand command = new CompositeTransactionalCommand(editingDomain, "Set Body");
        SetRequest request = new SetRequest((EObject)comment, (EStructuralFeature)UMLPackage.eINSTANCE.getComment_Body(), (Object)newString);
        command.compose((IUndoableOperation)new SetValueCommand(request));
        return command;
    }

    public String getPrintString(IAdaptable element, int flags) {
        Comment comment = this.doAdapt(element);
        if (comment == null) {
            return "<NULL COMMENT>";
        }
        String roughBody = comment.getBody();
        if (roughBody == null || roughBody.length() == 0) {
            return "";
        }
        Resource resource = comment.eResource();
        NameReferencesHelper helper = new NameReferencesHelper(resource);
        String displayText = helper.replaceReferences(roughBody);
        return displayText;
    }

    public boolean isAffectingEvent(Object event, int flags) {
        if (event instanceof Notification) {
            Object source = ((Notification)event).getFeature();
            if (UMLPackage.eINSTANCE.getComment_Body().equals(source)) {
                return true;
            }
        }
        return false;
    }

    public IParserEditStatus isValidEditString(IAdaptable element, String editString) {
        return ParserEditStatus.EDITABLE_STATUS;
    }

    protected Comment doAdapt(IAdaptable element) {
        EObject obj = EMFHelper.getEObject((Object)element);
        if (obj instanceof Comment) {
            return (Comment)obj;
        }
        return null;
    }
}

