/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.profile.types.generator;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.gmf.runtime.emf.type.core.ElementTypeRegistry;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.IMetamodelType;
import org.eclipse.gmf.runtime.emf.type.core.ISpecializationType;
import org.eclipse.papyrus.infra.types.ElementTypeConfiguration;
import org.eclipse.papyrus.infra.types.ElementTypeSetConfiguration;
import org.eclipse.papyrus.infra.types.ElementTypesConfigurationsFactory;
import org.eclipse.papyrus.infra.types.IconEntry;
import org.eclipse.papyrus.infra.types.MetamodelTypeConfiguration;
import org.eclipse.papyrus.infra.types.SpecializationTypeConfiguration;
import org.eclipse.papyrus.infra.types.core.registries.ElementTypeSetConfigurationRegistry;
import org.eclipse.papyrus.uml.profile.types.generator.Identifiers;
import org.eclipse.papyrus.uml.profile.types.generator.UML;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xbase.lib.StringExtensions;

@Singleton
public class UMLElementTypes {
    private static final Pattern VISUAL_ID_PATTERN = Pattern.compile("\\d{4}");
    @Extension
    private static ElementTypesConfigurationsFactory elementtypesconfigurationsFactory = ElementTypesConfigurationsFactory.eINSTANCE;
    @Inject
    @Extension
    private Identifiers _identifiers;
    @Inject
    @Extension
    private UML _uML;

    public String getElementTypeID(Class metaclass) {
        String _name = metaclass.getName();
        return "org.eclipse.papyrus.uml." + _name;
    }

    public ElementTypeConfiguration getElementTypeConfiguration(Class metaclass) {
        Functions.Function1 _function = it -> {
            String _identifier = it.getIdentifier();
            String _elementTypeID = this.getElementTypeID(metaclass);
            return Objects.equal((Object)_identifier, (Object)_elementTypeID);
        };
        return (ElementTypeConfiguration)IterableExtensions.findFirst((Iterable)this.getBaseUMLElementTypeSet().getElementTypeConfigurations(), (Functions.Function1)_function);
    }

    public ElementTypeSetConfiguration getBaseUMLElementTypeSet() {
        return (ElementTypeSetConfiguration)((Map)ElementTypeSetConfigurationRegistry.getInstance().getElementTypeSetConfigurations().get(this._identifiers.getContextId())).get(this._identifiers.getUmlElementTypesSet());
    }

    public Iterable<IElementType> getBaseUMLElementTypes() {
        Functions.Function1 _function = it -> ElementTypeRegistry.getInstance().getType(it.getIdentifier());
        return IterableExtensions.filterNull((Iterable)ListExtensions.map((List)this.getBaseUMLElementTypeSet().getElementTypeConfigurations(), (Functions.Function1)_function));
    }

    public EClass getEClass(Class metaclass) {
        EClassifier _eClassifier = UMLPackage.eINSTANCE.getEClassifier(metaclass.getName());
        return (EClass)_eClassifier;
    }

    public IconEntry getIconEntry(Class metaclass) {
        ElementTypeConfiguration _elementTypeConfiguration = this.getElementTypeConfiguration(metaclass);
        IconEntry _iconEntry = null;
        if (_elementTypeConfiguration != null) {
            _iconEntry = _elementTypeConfiguration.getIconEntry();
        }
        return this.copy(_iconEntry);
    }

    private IconEntry copy(IconEntry prototype) {
        IconEntry _createIconEntry = elementtypesconfigurationsFactory.createIconEntry();
        Procedures.Procedure1 _function = it -> {
            it.setBundleId(prototype.getBundleId());
            it.setIconPath(prototype.getIconPath());
        };
        return (IconEntry)ObjectExtensions.operator_doubleArrow((Object)_createIconEntry, (Procedures.Procedure1)_function);
    }

    public ElementTypeSetConfiguration getBaseElementTypeSet() {
        ElementTypeSetConfiguration _get;
        ElementTypeSetConfiguration _elvis = null;
        ElementTypeSetConfiguration _baseElementTypesSetConfiguration = this._identifiers.getBaseElementTypesSetConfiguration();
        _elvis = _baseElementTypesSetConfiguration != null ? _baseElementTypesSetConfiguration : (_get = (ElementTypeSetConfiguration)((Map)ElementTypeSetConfigurationRegistry.getInstance().getElementTypeSetConfigurations().get(this._identifiers.getContextId())).get(this._identifiers.getBaseElementTypesSet()));
        return _elvis;
    }

    public Iterable<ElementTypeConfiguration> getBaseElementTypes() {
        Functions.Function1 _function = it -> this.validType((ElementTypeConfiguration)it);
        return IterableExtensions.filter((Iterable)this.getBaseElementTypeSet().getElementTypeConfigurations(), (Functions.Function1)_function);
    }

    public boolean validType(ElementTypeConfiguration elementType) {
        EClass _metaclass = this.getMetaclass(elementType);
        return !Objects.equal((Object)_metaclass, null);
    }

    private boolean isDiagramSpecific() {
        ElementTypeSetConfiguration _baseUMLElementTypeSet;
        ElementTypeSetConfiguration _baseElementTypeSet = this.getBaseElementTypeSet();
        return !Objects.equal((Object)_baseElementTypeSet, (Object)(_baseUMLElementTypeSet = this.getBaseUMLElementTypeSet()));
    }

    public boolean isDiagramSpecific(ElementTypeConfiguration type) {
        return this.isVisualID(type.getHint());
    }

    public boolean hasSemanticSupertype(ElementTypeConfiguration type) {
        return this.isDiagramSpecific(type) && !this._identifiers.isSuppressSemanticSuperElementTypes();
    }

    private boolean isVisualID(String string) {
        return !StringExtensions.isNullOrEmpty((String)string) && (VISUAL_ID_PATTERN.matcher(string).matches() || string.contains("Diagram") || string.contains("Shape") || string.contains("Edge") || string.contains("Label") || string.contains("Compartment"));
    }

    public Iterable<? extends ElementTypeConfiguration> getDiagramSpecificElementTypes(Class metaclass) {
        boolean _not;
        Iterable _xifexpression = null;
        boolean _isDiagramSpecific = this.isDiagramSpecific();
        boolean bl = _not = !_isDiagramSpecific;
        if (_not) {
            Functions.Function1 _function = it -> this.validType((ElementTypeConfiguration)it) && Objects.equal((Object)it.getIdentifier(), (Object)this.getElementTypeID(metaclass));
            _xifexpression = IterableExtensions.filter((Iterable)this.getBaseUMLElementTypeSet().getElementTypeConfigurations(), (Functions.Function1)_function);
        } else {
            Functions.Function1 _function_1 = it -> this.validType((ElementTypeConfiguration)it) && this.containsId((List<ElementTypeConfiguration>)it.getSpecializedTypes(), this.getElementTypeID(metaclass));
            _xifexpression = IterableExtensions.filter((Iterable)Iterables.filter((Iterable)this.getBaseElementTypeSet().getElementTypeConfigurations(), SpecializationTypeConfiguration.class), (Functions.Function1)_function_1);
        }
        return _xifexpression;
    }

    private boolean containsId(List<ElementTypeConfiguration> elementTypeConfigurations, String id) {
        for (ElementTypeConfiguration elementTypeConfiguration : elementTypeConfigurations) {
            boolean _equals = elementTypeConfiguration.getIdentifier().equals(id);
            if (!_equals) continue;
            return true;
        }
        return false;
    }

    private boolean canContain(IElementType containerType, EClass containedEClass) {
        Functions.Function1 _function = it -> it.getEReferenceType().isSuperTypeOf(containedEClass);
        return IterableExtensions.exists((Iterable)containerType.getEClass().getEAllContainments(), (Functions.Function1)_function);
    }

    private boolean canContain(ElementTypeConfiguration containerType, EClass containedEClass) {
        IElementType _type = ElementTypeRegistry.getInstance().getType(containerType.getIdentifier());
        boolean _canContain = false;
        if (_type != null) {
            _canContain = this.canContain(_type, containedEClass);
        }
        return _canContain;
    }

    protected boolean _canContainType(ElementTypeConfiguration containerType, ElementTypeConfiguration containedTypeConfiguration) {
        return false;
    }

    protected boolean _canContainType(ElementTypeConfiguration containerType, MetamodelTypeConfiguration containedTypeConfiguration) {
        return this.canContain(containerType, containedTypeConfiguration.getEClass());
    }

    protected boolean _canContainType(ElementTypeConfiguration containerType, SpecializationTypeConfiguration containedTypeConfiguration) {
        Functions.Function1 _function = supertype -> this.canContain(containerType, ElementTypeRegistry.getInstance().getType(supertype.getIdentifier()).getEClass());
        return IterableExtensions.exists((Iterable)containedTypeConfiguration.getSpecializedTypes(), (Functions.Function1)_function);
    }

    public boolean isRelationship(IElementType elementType) {
        return Objects.equal((Object)elementType.getEClass(), null) || this._uML.isRelationship(elementType.getEClass());
    }

    public boolean isRelationship(ElementTypeConfiguration elementType) {
        return Objects.equal((Object)this.getMetaclass(elementType), null) || this._uML.isRelationship(this.getMetaclass(elementType));
    }

    private EClass _getMetaclass(ElementTypeConfiguration elementType) {
        return null;
    }

    private EClass _getMetaclass(SpecializationTypeConfiguration elementType) {
        boolean _notEquals;
        EClass _xblockexpression = null;
        IElementType registered = ElementTypeRegistry.getInstance().getType(elementType.getIdentifier());
        EClass _xifexpression = null;
        boolean bl = _notEquals = !Objects.equal((Object)registered, null);
        if (_notEquals) {
            _xifexpression = this.getMetaclass(registered);
        } else {
            Functions.Function1 _function = it -> ElementTypeRegistry.getInstance().getType(it.getIdentifier());
            IElementType _head = (IElementType)IterableExtensions.head((Iterable)IterableExtensions.filterNull((Iterable)ListExtensions.map((List)elementType.getSpecializedTypes(), (Functions.Function1)_function)));
            EClass _eClass = null;
            if (_head != null) {
                _eClass = _head.getEClass();
            }
            _xifexpression = _eClass;
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    private EClass _getMetaclass(MetamodelTypeConfiguration elementType) {
        return elementType.getEClass();
    }

    private EClass _getMetaclass(IElementType elementType) {
        return null;
    }

    private EClass _getMetaclass(IMetamodelType elementType) {
        return elementType.getEClass();
    }

    private EClass _getMetaclass(ISpecializationType elementType) {
        IMetamodelType _metamodelType = elementType.getMetamodelType();
        EClass _eClass = null;
        if (_metamodelType != null) {
            _eClass = _metamodelType.getEClass();
        }
        return _eClass;
    }

    private boolean canSourceTo(IElementType sourceType, EClass relationshipEClass) {
        Functions.Function1 _function = it -> it.getEReferenceType().isSuperTypeOf(sourceType.getEClass());
        return IterableExtensions.exists(this._uML.getSourceReferences(relationshipEClass), (Functions.Function1)_function);
    }

    private boolean canSourceTo(ElementTypeConfiguration sourceType, EClass relationshipEClass) {
        ElementTypeRegistry _instance = ElementTypeRegistry.getInstance();
        String _identifier = null;
        if (sourceType != null) {
            _identifier = sourceType.getIdentifier();
        }
        IElementType _type = _instance.getType(_identifier);
        boolean _canSourceTo = false;
        if (_type != null) {
            _canSourceTo = this.canSourceTo(_type, relationshipEClass);
        }
        return _canSourceTo;
    }

    protected boolean _canSourceToType(ElementTypeConfiguration sourceType, ElementTypeConfiguration relationshipTypeConfiguration) {
        return false;
    }

    protected boolean _canSourceToType(ElementTypeConfiguration sourceType, MetamodelTypeConfiguration relationshipTypeConfiguration) {
        return this.canSourceTo(sourceType, relationshipTypeConfiguration.getEClass());
    }

    protected boolean _canSourceToType(ElementTypeConfiguration sourceType, SpecializationTypeConfiguration relationshipTypeConfiguration) {
        Functions.Function1 _function = supertypeConfiguration -> {
            boolean _xblockexpression = false;
            IElementType supertype = ElementTypeRegistry.getInstance().getType(supertypeConfiguration.getIdentifier());
            _xblockexpression = !Objects.equal((Object)supertype, null) && this._uML.isRelationship(supertype.getEClass()) && this.canSourceTo(sourceType, supertype.getEClass());
            return _xblockexpression;
        };
        return IterableExtensions.exists((Iterable)relationshipTypeConfiguration.getSpecializedTypes(), (Functions.Function1)_function);
    }

    private boolean canTargetFrom(IElementType targetType, EClass relationshipEClass) {
        Functions.Function1 _function = it -> it.getEReferenceType().isSuperTypeOf(targetType.getEClass());
        return IterableExtensions.exists(this._uML.getTargetReferences(relationshipEClass), (Functions.Function1)_function);
    }

    private boolean canTargetFrom(ElementTypeConfiguration targetType, EClass relationshipEClass) {
        ElementTypeRegistry _instance = ElementTypeRegistry.getInstance();
        String _identifier = null;
        if (targetType != null) {
            _identifier = targetType.getIdentifier();
        }
        IElementType _type = _instance.getType(_identifier);
        boolean _canTargetFrom = false;
        if (_type != null) {
            _canTargetFrom = this.canTargetFrom(_type, relationshipEClass);
        }
        return _canTargetFrom;
    }

    protected boolean _canTargetFromType(ElementTypeConfiguration targetType, ElementTypeConfiguration relationshipTypeConfiguration) {
        return false;
    }

    protected boolean _canTargetFromType(ElementTypeConfiguration targetType, MetamodelTypeConfiguration relationshipTypeConfiguration) {
        return this.canTargetFrom(targetType, relationshipTypeConfiguration.getEClass());
    }

    protected boolean _canTargetFromType(ElementTypeConfiguration targetType, SpecializationTypeConfiguration relationshipTypeConfiguration) {
        Functions.Function1 _function = supertypeConfiguration -> {
            boolean _xblockexpression = false;
            IElementType supertype = ElementTypeRegistry.getInstance().getType(supertypeConfiguration.getIdentifier());
            _xblockexpression = !Objects.equal((Object)supertype, null) && this._uML.isRelationship(supertype.getEClass()) && this.canTargetFrom(targetType, supertype.getEClass());
            return _xblockexpression;
        };
        return IterableExtensions.exists((Iterable)relationshipTypeConfiguration.getSpecializedTypes(), (Functions.Function1)_function);
    }

    public boolean canContainType(ElementTypeConfiguration containerType, ElementTypeConfiguration containedTypeConfiguration) {
        if (containedTypeConfiguration instanceof MetamodelTypeConfiguration) {
            return this._canContainType(containerType, (MetamodelTypeConfiguration)containedTypeConfiguration);
        }
        if (containedTypeConfiguration instanceof SpecializationTypeConfiguration) {
            return this._canContainType(containerType, (SpecializationTypeConfiguration)containedTypeConfiguration);
        }
        if (containedTypeConfiguration != null) {
            return this._canContainType(containerType, containedTypeConfiguration);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(containerType, containedTypeConfiguration).toString());
    }

    private EClass getMetaclass(Object elementType) {
        if (elementType instanceof MetamodelTypeConfiguration) {
            return this._getMetaclass((MetamodelTypeConfiguration)elementType);
        }
        if (elementType instanceof SpecializationTypeConfiguration) {
            return this._getMetaclass((SpecializationTypeConfiguration)elementType);
        }
        if (elementType instanceof ElementTypeConfiguration) {
            return this._getMetaclass((ElementTypeConfiguration)elementType);
        }
        if (elementType instanceof IMetamodelType) {
            return this._getMetaclass((IMetamodelType)elementType);
        }
        if (elementType instanceof ISpecializationType) {
            return this._getMetaclass((ISpecializationType)elementType);
        }
        if (elementType instanceof IElementType) {
            return this._getMetaclass((IElementType)elementType);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(elementType).toString());
    }

    public boolean canSourceToType(ElementTypeConfiguration sourceType, ElementTypeConfiguration relationshipTypeConfiguration) {
        if (relationshipTypeConfiguration instanceof MetamodelTypeConfiguration) {
            return this._canSourceToType(sourceType, (MetamodelTypeConfiguration)relationshipTypeConfiguration);
        }
        if (relationshipTypeConfiguration instanceof SpecializationTypeConfiguration) {
            return this._canSourceToType(sourceType, (SpecializationTypeConfiguration)relationshipTypeConfiguration);
        }
        if (relationshipTypeConfiguration != null) {
            return this._canSourceToType(sourceType, relationshipTypeConfiguration);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(sourceType, relationshipTypeConfiguration).toString());
    }

    public boolean canTargetFromType(ElementTypeConfiguration targetType, ElementTypeConfiguration relationshipTypeConfiguration) {
        if (relationshipTypeConfiguration instanceof MetamodelTypeConfiguration) {
            return this._canTargetFromType(targetType, (MetamodelTypeConfiguration)relationshipTypeConfiguration);
        }
        if (relationshipTypeConfiguration instanceof SpecializationTypeConfiguration) {
            return this._canTargetFromType(targetType, (SpecializationTypeConfiguration)relationshipTypeConfiguration);
        }
        if (relationshipTypeConfiguration != null) {
            return this._canTargetFromType(targetType, relationshipTypeConfiguration);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(targetType, relationshipTypeConfiguration).toString());
    }
}

