/**
 * Copyright (c) 2010, 2020 Artem Tikhomirov, CEA LIST, Artal and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *    Artem Tikhomirov (independent) - Initial API and implementation
 *    Michael Golubev (Montages) - #386838 - migrate to Xtend2
 *    Aurelien Didier (ARTAL) - aurelien.didier51@gmail.com - Bug 569174
 *    Etienne Allogo (ARTAL) - etienne.allogo@artal.fr - Bug 569174 : L1.2 clean up parsers
 */
package impl.parsers;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Arrays;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenConstraint;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenExpressionInterpreter;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenExpressionProviderBase;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenJavaExpressionProvider;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenLanguage;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenLiteralExpressionProvider;
import org.eclipse.papyrus.gmf.codegen.gmfgen.ValueExpression;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.StringExtensions;
import xpt.Common;
import xpt.Common_qvto;
import xpt.expressions.getExpression;

@Singleton
@SuppressWarnings("all")
public class ExpressionLabelParser {
  @Inject
  @Extension
  private Common _common;

  @Inject
  @Extension
  private Common_qvto _common_qvto;

  @Inject
  @Extension
  private parsers.ExpressionLabelParser _expressionLabelParser;

  @Inject
  private getExpression xptGetExpression;

  public CharSequence constructor(final org.eclipse.papyrus.gmf.codegen.gmfgen.ExpressionLabelParser it, final String name) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("public ");
    CharSequence _className = this._expressionLabelParser.className(it);
    _builder.append(_className);
    _builder.append("() {");
    _builder.newLineIfNotEmpty();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }

  public CharSequence accessEditExpression(final org.eclipse.papyrus.gmf.codegen.gmfgen.ExpressionLabelParser it) {
    StringConcatenation _builder = new StringConcatenation();
    {
      if (((it.getEditExpression() == null) || (it.getEditExpression().getProvider() == null))) {
        _builder.append("return getPrintString(element, flags);");
        _builder.newLine();
      } else {
        CharSequence _evaluateAndReturnExpressionResult = this.evaluateAndReturnExpressionResult(it.getEditExpression().getProvider(), it, "evaluateEditExpression", it.getEditExpression());
        _builder.append(_evaluateAndReturnExpressionResult);
        _builder.newLineIfNotEmpty();
      }
    }
    return _builder;
  }

  public CharSequence accessViewExpression(final org.eclipse.papyrus.gmf.codegen.gmfgen.ExpressionLabelParser it) {
    StringConcatenation _builder = new StringConcatenation();
    {
      if (((it.getViewExpression() == null) || (it.getViewExpression().getProvider() == null))) {
        _builder.append("// TODO - viewExpression is not defined in the model");
        _builder.newLine();
        _builder.append("throw new UnsupportedOperationException(\"\"); ");
        _builder.newLine();
      } else {
        CharSequence _evaluateAndReturnExpressionResult = this.evaluateAndReturnExpressionResult(it.getViewExpression().getProvider(), it, "evaluatePrintExpression", it.getViewExpression());
        _builder.append(_evaluateAndReturnExpressionResult);
        _builder.newLineIfNotEmpty();
      }
    }
    return _builder;
  }

  protected CharSequence _getExpression(final GenExpressionProviderBase it, final org.eclipse.papyrus.gmf.codegen.gmfgen.ExpressionLabelParser parser, final ValueExpression expression) {
    StringConcatenation _builder = new StringConcatenation();
    this._common_qvto.ERROR("Abstract template call: getExpression");
    return _builder;
  }

  protected CharSequence _getExpression(final GenExpressionInterpreter it, final org.eclipse.papyrus.gmf.codegen.gmfgen.ExpressionLabelParser parser, final ValueExpression expression) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _expression = this.xptGetExpression.getExpression(it, expression, parser.getExpressionContext());
    _builder.append(_expression);
    _builder.newLineIfNotEmpty();
    return _builder;
  }

  protected CharSequence _evaluateAndReturnExpressionResult(final GenExpressionProviderBase it, final org.eclipse.papyrus.gmf.codegen.gmfgen.ExpressionLabelParser parser, final String javaMethodName, final ValueExpression expression) {
    StringConcatenation _builder = new StringConcatenation();
    this._common_qvto.ERROR(("Abstract template call for: " + it));
    _builder.newLineIfNotEmpty();
    return _builder;
  }

  protected CharSequence _evaluateAndReturnExpressionResult(final GenExpressionInterpreter it, final org.eclipse.papyrus.gmf.codegen.gmfgen.ExpressionLabelParser parser, final String javaMethodName, final ValueExpression expression) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("org.eclipse.emf.ecore.EObject target = element.getAdapter(org.eclipse.emf.ecore.EObject.class);");
    _builder.newLine();
    _builder.append("Object result =  ");
    CharSequence _expression = this.getExpression(it, parser, expression);
    _builder.append(_expression);
    _builder.append(".evaluate(target);");
    _builder.newLineIfNotEmpty();
    _builder.append("return String.valueOf(result);");
    _builder.newLine();
    return _builder;
  }

  protected CharSequence _evaluateAndReturnExpressionResult(final GenJavaExpressionProvider it, final org.eclipse.papyrus.gmf.codegen.gmfgen.ExpressionLabelParser parser, final String javaMethodName, final ValueExpression expression) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("return ");
    _builder.append(javaMethodName);
    _builder.append("(element.getAdapter(org.eclipse.emf.ecore.EObject.class));");
    _builder.newLineIfNotEmpty();
    return _builder;
  }

  protected CharSequence _evaluateAndReturnExpressionResult(final GenLiteralExpressionProvider it, final org.eclipse.papyrus.gmf.codegen.gmfgen.ExpressionLabelParser parser, final String javaMethodName, final ValueExpression expression) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("return ");
    String _body = expression.getBody();
    _builder.append(_body);
    _builder.append(";");
    _builder.newLineIfNotEmpty();
    return _builder;
  }

  public CharSequence accessValidateExpression(final org.eclipse.papyrus.gmf.codegen.gmfgen.ExpressionLabelParser it) {
    StringConcatenation _builder = new StringConcatenation();
    {
      GenConstraint _validateExpression = it.getValidateExpression();
      boolean _tripleNotEquals = (_validateExpression != null);
      if (_tripleNotEquals) {
        {
          GenLanguage _language = it.getValidateExpression().getProvider().getLanguage();
          boolean _equals = Objects.equal(_language, GenLanguage.LITERAL_LITERAL);
          if (_equals) {
            _builder.append("if (!");
            String _body = it.getValidateExpression().getBody();
            _builder.append(_body);
            _builder.append(") {");
            _builder.newLineIfNotEmpty();
          } else {
            _builder.append("if (Boolean.FALSE.equals(");
            CharSequence _dispatchCheckValidateExpression = this.dispatchCheckValidateExpression(it.getValidateExpression().getProvider(), it.getValidateExpression());
            _builder.append(_dispatchCheckValidateExpression);
            _builder.append(")) {");
            _builder.newLineIfNotEmpty();
          }
        }
        _builder.append("return org.eclipse.gmf.runtime.common.ui.services.parser.ParserEditStatus.UNEDITABLE_STATUS;");
        _builder.newLine();
        _builder.append("} // else fall-through");
        _builder.newLine();
      }
    }
    _builder.append("return org.eclipse.gmf.runtime.common.ui.services.parser.ParserEditStatus.EDITABLE_STATUS;");
    _builder.newLine();
    return _builder;
  }

  /**
   * The xpt behavior, that is compilation error in generated code, is preserved, but additional comment had been added in Xtend version
   */
  protected CharSequence _dispatchCheckValidateExpression(final GenExpressionProviderBase it, final GenConstraint expression) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("/*FIXME: unkwnown expression provider */");
    return _builder;
  }

  protected CharSequence _dispatchCheckValidateExpression(final GenExpressionInterpreter it, final GenConstraint expression) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _expression = this.xptGetExpression.getExpression(it, expression, "org.eclipse.emf.ecore.getEcorePackage.eINSTANCE.getEString()");
    _builder.append(_expression);
    _builder.append(".evaluate(editString)»");
    return _builder;
  }

  protected CharSequence _dispatchCheckValidateExpression(final GenJavaExpressionProvider it, final GenConstraint expression) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("evaluateValidateExpression(editString)");
    return _builder;
  }

  public CharSequence extraMethods(final org.eclipse.papyrus.gmf.codegen.gmfgen.ExpressionLabelParser it) {
    StringConcatenation _builder = new StringConcatenation();
    {
      if (((it.getViewExpression() != null) && this._common_qvto.oclIsKindOf(it.getViewExpression().getProvider(), GenJavaExpressionProvider.class))) {
        GenExpressionProviderBase _provider = it.getViewExpression().getProvider();
        CharSequence _javaMethod = this.javaMethod(((GenJavaExpressionProvider) _provider), "evaluatePrintExpression", "String", "org.eclipse.emf.ecore.EObject", it.getViewExpression());
        _builder.append(_javaMethod);
        _builder.newLineIfNotEmpty();
      }
    }
    {
      if (((it.getEditExpression() != null) && this._common_qvto.oclIsKindOf(it.getEditExpression().getProvider(), GenJavaExpressionProvider.class))) {
        GenExpressionProviderBase _provider_1 = it.getEditExpression().getProvider();
        CharSequence _javaMethod_1 = this.javaMethod(((GenJavaExpressionProvider) _provider_1), "evaluateEditExpression", "String", "org.eclipse.emf.ecore.EObject", it.getEditExpression());
        _builder.append(_javaMethod_1);
        _builder.newLineIfNotEmpty();
      }
    }
    {
      if (((it.getValidateExpression() != null) && this._common_qvto.oclIsKindOf(it.getValidateExpression().getProvider(), GenJavaExpressionProvider.class))) {
        GenExpressionProviderBase _provider_2 = it.getValidateExpression().getProvider();
        CharSequence _javaMethod_2 = this.javaMethod(((GenJavaExpressionProvider) _provider_2), "evaluateValidateExpression", "Boolean", "String", it.getValidateExpression());
        _builder.append(_javaMethod_2);
        _builder.newLineIfNotEmpty();
      }
    }
    return _builder;
  }

  public CharSequence javaMethod(final GenJavaExpressionProvider it, final String methodName, final String returnType, final String paramType, final ValueExpression expression) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("private ");
    _builder.append(returnType);
    _builder.append(" ");
    _builder.append(methodName);
    _builder.append("(");
    _builder.append(paramType);
    _builder.append(" self) {");
    _builder.newLineIfNotEmpty();
    {
      if (((it.isInjectExpressionBody() && (expression != null)) && (!StringExtensions.isNullOrEmpty(expression.getBody())))) {
        String _body = expression.getBody();
        _builder.append(_body);
        _builder.newLineIfNotEmpty();
      } else {
        if ((it.isThrowException() || (it.isInjectExpressionBody() && ((expression == null) || StringExtensions.isNullOrEmpty(expression.getBody()))))) {
          _builder.append("// TODO: implement this method to return ");
          _builder.append(returnType);
          _builder.append(" value  ");
          _builder.newLineIfNotEmpty();
          _builder.append("// Ensure that you remove @generated or mark it @generated NOT");
          _builder.newLine();
          _builder.append("throw new java.lang.UnsupportedOperationException(\"No user java implementation provided in \'");
          _builder.append(methodName);
          _builder.append("\' operation\"); ");
          CharSequence _nonNLS = this._common.nonNLS();
          _builder.append(_nonNLS);
          _builder.newLineIfNotEmpty();
        } else {
          _builder.append("return null;");
          _builder.newLine();
        }
      }
    }
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }

  public CharSequence getExpression(final GenExpressionProviderBase it, final org.eclipse.papyrus.gmf.codegen.gmfgen.ExpressionLabelParser parser, final ValueExpression expression) {
    if (it instanceof GenExpressionInterpreter) {
      return _getExpression((GenExpressionInterpreter)it, parser, expression);
    } else if (it != null) {
      return _getExpression(it, parser, expression);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(it, parser, expression).toString());
    }
  }

  public CharSequence evaluateAndReturnExpressionResult(final GenExpressionProviderBase it, final org.eclipse.papyrus.gmf.codegen.gmfgen.ExpressionLabelParser parser, final String javaMethodName, final ValueExpression expression) {
    if (it instanceof GenExpressionInterpreter) {
      return _evaluateAndReturnExpressionResult((GenExpressionInterpreter)it, parser, javaMethodName, expression);
    } else if (it instanceof GenJavaExpressionProvider) {
      return _evaluateAndReturnExpressionResult((GenJavaExpressionProvider)it, parser, javaMethodName, expression);
    } else if (it instanceof GenLiteralExpressionProvider) {
      return _evaluateAndReturnExpressionResult((GenLiteralExpressionProvider)it, parser, javaMethodName, expression);
    } else if (it != null) {
      return _evaluateAndReturnExpressionResult(it, parser, javaMethodName, expression);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(it, parser, javaMethodName, expression).toString());
    }
  }

  public CharSequence dispatchCheckValidateExpression(final GenExpressionProviderBase it, final GenConstraint expression) {
    if (it instanceof GenExpressionInterpreter) {
      return _dispatchCheckValidateExpression((GenExpressionInterpreter)it, expression);
    } else if (it instanceof GenJavaExpressionProvider) {
      return _dispatchCheckValidateExpression((GenJavaExpressionProvider)it, expression);
    } else if (it != null) {
      return _dispatchCheckValidateExpression(it, expression);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(it, expression).toString());
    }
  }
}
