/*
 * Decompiled with CFR 0.152.
 */
package xpt.diagram.updater;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Set;
import org.eclipse.emf.codegen.ecore.genmodel.GenClass;
import org.eclipse.emf.codegen.ecore.genmodel.GenFeature;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.gmf.codegen.gmfgen.FeatureLinkModelFacet;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenCommonBase;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenCompartment;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenContainerBase;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenDiagram;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenLink;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenLinkEnd;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenNode;
import org.eclipse.papyrus.gmf.codegen.gmfgen.LinkModelFacet;
import org.eclipse.papyrus.gmf.codegen.gmfgen.TypeLinkModelFacet;
import org.eclipse.papyrus.gmf.codegen.gmfgen.TypeModelFacet;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import xpt.Common_qvto;
import xpt.diagram.editpolicies.LinkUtils_qvto;
import xpt.diagram.updater.UpdaterLinkType;

@Singleton
public class Utils_qvto {
    @Inject
    @Extension
    private Common_qvto _common_qvto;
    @Inject
    @Extension
    private LinkUtils_qvto _linkUtils_qvto;

    public String getLinkMethodSuffix(UpdaterLinkType type) {
        if (type != null) {
            switch (type) {
                case CONTAINED: {
                    return "Contained";
                }
                case INCOMING: {
                    return "Incoming";
                }
                case OUTGOING: {
                    return "Outgoing";
                }
            }
            throw new IllegalArgumentException("Unknown updaterLinkType: " + String.valueOf((Object)type));
        }
        throw new IllegalArgumentException("Unknown updaterLinkType: " + String.valueOf((Object)type));
    }

    public Iterable<GenLink> computeContainedLinks(GenClass metaClass, GenDiagram diagram) {
        Functions.Function1 _function = link -> this._linkUtils_qvto.canBeContainer((GenLink)link, metaClass);
        return IterableExtensions.filter((Iterable)diagram.getLinks(), (Functions.Function1)_function);
    }

    public Iterable<GenLink> computeOutgoingLinks(GenLinkEnd linkEnd) {
        Functions.Function1 _function = link -> linkEnd.getGenOutgoingLinks().contains(link);
        return IterableExtensions.filter((Iterable)linkEnd.getDiagram().getLinks(), (Functions.Function1)_function);
    }

    public Iterable<GenLink> computeIncomingLinks(GenLinkEnd linkEnd) {
        Functions.Function1 _function = link -> linkEnd.getGenIncomingLinks().contains(link);
        return IterableExtensions.filter((Iterable)linkEnd.getDiagram().getLinks(), (Functions.Function1)_function);
    }

    public Iterable<GenLink> getAllContainedLinks(GenDiagram diagram) {
        Functions.Function1 _function = link -> {
            Functions.Function1 _function_1 = commonBase -> this._linkUtils_qvto.canBeContainer((GenLink)link, this.getMetaClass((EObject)commonBase));
            return this._common_qvto.notEmpty(IterableExtensions.filter(this.getAllSemanticElements(diagram), (Functions.Function1)_function_1));
        };
        return IterableExtensions.filter((Iterable)diagram.getLinks(), (Functions.Function1)_function);
    }

    public Iterable<GenLink> getAllIncomingLinks(GenDiagram diagram) {
        Functions.Function1 _function = link -> this._common_qvto.notEmpty(link.getTargets());
        return IterableExtensions.filter((Iterable)diagram.getLinks(), (Functions.Function1)_function);
    }

    public Iterable<GenLink> getAllOutgoingLinks(GenDiagram diagram) {
        Functions.Function1 _function = link -> this.isOutgoingLink((GenLink)link);
        Functions.Function1 _function_1 = link -> this._common_qvto.notEmpty(link.getSources());
        return IterableExtensions.filter((Iterable)IterableExtensions.filter((Iterable)diagram.getLinks(), (Functions.Function1)_function), (Functions.Function1)_function_1);
    }

    public boolean isOutgoingLink(GenLink link) {
        return link.getModelFacet() != null && this.isOutgoingLinkModelFacet(link.getModelFacet());
    }

    protected boolean _isOutgoingLinkModelFacet(LinkModelFacet facet) {
        return true;
    }

    protected boolean _isOutgoingLinkModelFacet(TypeLinkModelFacet facet) {
        GenFeature _sourceMetaFeature = facet.getSourceMetaFeature();
        return _sourceMetaFeature != null;
    }

    public Iterable<GenLinkEnd> getAllSemanticDiagramElements(GenDiagram diagram) {
        LinkedList result = CollectionLiterals.newLinkedList();
        result.addAll(diagram.getAllNodes());
        result.addAll(diagram.getLinks());
        Functions.Function1 _function = linkEnd -> {
            GenClass _metaClass = this.getMetaClass((EObject)linkEnd);
            return _metaClass != null;
        };
        return IterableExtensions.filter((Iterable)result, (Functions.Function1)_function);
    }

    public Iterable<GenCommonBase> getAllSemanticElements(GenDiagram diagram) {
        boolean _tripleNotEquals;
        GenClass _domainDiagramElement = diagram.getDomainDiagramElement();
        boolean bl = _tripleNotEquals = _domainDiagramElement != null;
        if (_tripleNotEquals) {
            LinkedList result = CollectionLiterals.newLinkedList((Object[])new GenCommonBase[]{diagram});
            Iterables.addAll((Collection)result, this.getAllSemanticDiagramElements(diagram));
            return result;
        }
        return Iterables.filter(this.getAllSemanticDiagramElements(diagram), GenCommonBase.class);
    }

    protected GenClass _getMetaClass(GenCommonBase some) {
        return null;
    }

    protected GenClass _getMetaClass(GenDiagram some) {
        return some.getDomainDiagramElement();
    }

    protected GenClass _getMetaClass(GenNode some) {
        GenClass _xifexpression = null;
        TypeModelFacet _modelFacet = some.getModelFacet();
        boolean _tripleEquals = _modelFacet == null;
        _xifexpression = _tripleEquals ? null : some.getModelFacet().getMetaClass();
        return _xifexpression;
    }

    protected GenClass _getMetaClass(GenLink some) {
        GenClass _xifexpression = null;
        LinkModelFacet _modelFacet = some.getModelFacet();
        boolean _tripleEquals = _modelFacet == null;
        _xifexpression = _tripleEquals ? null : this.getMetaClass((EObject)some.getModelFacet());
        return _xifexpression;
    }

    protected GenClass _getMetaClass(LinkModelFacet facet) {
        return null;
    }

    protected GenClass _getMetaClass(TypeLinkModelFacet facet) {
        return facet.getMetaClass();
    }

    public boolean hasSemanticChildren(GenContainerBase container) {
        return !container.isSansDomain() && this._common_qvto.notEmpty(container.getContainedNodes());
    }

    protected GenClass _getModelElementType(GenContainerBase base) {
        return null;
    }

    protected GenClass _getModelElementType(GenDiagram diagram) {
        return diagram.getDomainDiagramElement();
    }

    protected GenClass _getModelElementType(GenCompartment compartment) {
        return this.getModelElementType((GenContainerBase)compartment.getNode());
    }

    protected GenClass _getModelElementType(GenNode node) {
        return node.getModelFacet().getMetaClass();
    }

    public Set<GenFeature> getSemanticChildrenChildFeatures(GenContainerBase containerBase) {
        LinkedHashSet result = CollectionLiterals.newLinkedHashSet();
        Functions.Function1 _function = node -> node.getModelFacet().getChildMetaFeature();
        Iterables.addAll((Collection)result, (Iterable)IterableExtensions.map(this.getNonPhantomSemanticChildren(containerBase), (Functions.Function1)_function));
        return result;
    }

    public Set<GenFeature> getSemanticChildrenContainmentFeatures(GenContainerBase containerBase) {
        LinkedHashSet result = CollectionLiterals.newLinkedHashSet();
        Functions.Function1 _function = node -> node.getModelFacet().getContainmentMetaFeature();
        Iterables.addAll((Collection)result, (Iterable)IterableExtensions.map(this.getNonPhantomSemanticChildren(containerBase), (Functions.Function1)_function));
        return result;
    }

    public Iterable<GenNode> getSemanticChildren(GenContainerBase containerBase, GenFeature childMetaFeature) {
        Functions.Function1 _function = node -> {
            GenFeature _childMetaFeature = node.getModelFacet().getChildMetaFeature();
            return Objects.equal((Object)_childMetaFeature, (Object)childMetaFeature);
        };
        return IterableExtensions.filter(this.getNonPhantomSemanticChildren(containerBase), (Functions.Function1)_function);
    }

    public Iterable<GenNode> getNonPhantomSemanticChildren(GenContainerBase containerBase) {
        Functions.Function1 _function = node -> {
            boolean _isPhantomElement = node.getModelFacet().isPhantomElement();
            return !_isPhantomElement;
        };
        return IterableExtensions.filter(this.getSemanticChildren(containerBase), (Functions.Function1)_function);
    }

    public boolean hasPhantomNodes(GenDiagram it) {
        boolean _notEmpty = this._common_qvto.notEmpty(this.getPhantomNodes((GenContainerBase)it));
        if (_notEmpty) {
            return true;
        }
        EList _allNodes = it.getAllNodes();
        for (GenNode node : _allNodes) {
            boolean _notEmpty_1 = this._common_qvto.notEmpty(this.getPhantomNodes((GenContainerBase)node));
            if (!_notEmpty_1) continue;
            return true;
        }
        return false;
    }

    protected Iterable<GenNode> _getPhantomNodes(GenContainerBase it) {
        return CollectionLiterals.newLinkedList();
    }

    protected Iterable<GenNode> _getPhantomNodes(GenNode it) {
        return this.getPhantomNodesForContainers((GenContainerBase)it);
    }

    protected Iterable<GenNode> _getPhantomNodes(GenDiagram it) {
        return this.getPhantomNodesForContainers((GenContainerBase)it);
    }

    public Iterable<GenNode> getPhantomNodesForContainers(GenContainerBase it) {
        Functions.Function1 _function = node -> node.getModelFacet().isPhantomElement();
        return IterableExtensions.filter(this.getSemanticChildren(it), (Functions.Function1)_function);
    }

    public Iterable<GenNode> getSemanticChildren(GenContainerBase containerBase) {
        Functions.Function1 _function = node -> {
            TypeModelFacet _modelFacet = node.getModelFacet();
            return _modelFacet != null;
        };
        return IterableExtensions.filter((Iterable)containerBase.getContainedNodes(), (Functions.Function1)_function);
    }

    public boolean hasConformableSemanticChildren(GenContainerBase containerBase) {
        int _size_1;
        Functions.Function1 _function = child -> child.getModelFacet().getMetaClass();
        Iterable childMetaClasses = IterableExtensions.map(this.getSemanticChildren(containerBase), (Functions.Function1)_function);
        int _size = IterableExtensions.size((Iterable)childMetaClasses);
        return _size != (_size_1 = IterableExtensions.toSet((Iterable)childMetaClasses).size());
    }

    protected GenClass _getLinkEndType(LinkModelFacet facet, UpdaterLinkType type) {
        return null;
    }

    protected GenClass _getLinkEndType(FeatureLinkModelFacet facet, UpdaterLinkType type) {
        GenClass _switchResult = null;
        if (type != null) {
            switch (type) {
                case INCOMING: {
                    _switchResult = facet.getTargetType();
                    break;
                }
                case OUTGOING: {
                    _switchResult = facet.getSourceType();
                    break;
                }
                default: {
                    _switchResult = null;
                    break;
                }
            }
        } else {
            _switchResult = null;
        }
        return _switchResult;
    }

    protected GenClass _getLinkEndType(TypeLinkModelFacet facet, UpdaterLinkType type) {
        boolean _tripleEquals;
        boolean _equals = Objects.equal((Object)((Object)type), (Object)((Object)UpdaterLinkType.INCOMING));
        if (_equals) {
            return facet.getTargetType();
        }
        if (Objects.equal((Object)((Object)type), (Object)((Object)UpdaterLinkType.OUTGOING)) && facet.getSourceMetaFeature() != null) {
            return facet.getSourceType();
        }
        GenFeature _containmentMetaFeature = facet.getContainmentMetaFeature();
        boolean bl = _tripleEquals = _containmentMetaFeature == null;
        if (_tripleEquals) {
            return null;
        }
        return facet.getContainmentMetaFeature().getGenClass();
    }

    public boolean isOutgoingLinkModelFacet(LinkModelFacet facet) {
        if (facet instanceof TypeLinkModelFacet) {
            return this._isOutgoingLinkModelFacet((TypeLinkModelFacet)facet);
        }
        if (facet != null) {
            return this._isOutgoingLinkModelFacet(facet);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(facet).toString());
    }

    public GenClass getMetaClass(EObject some) {
        if (some instanceof GenNode) {
            return this._getMetaClass((GenNode)some);
        }
        if (some instanceof GenDiagram) {
            return this._getMetaClass((GenDiagram)some);
        }
        if (some instanceof GenLink) {
            return this._getMetaClass((GenLink)some);
        }
        if (some instanceof TypeLinkModelFacet) {
            return this._getMetaClass((TypeLinkModelFacet)some);
        }
        if (some instanceof LinkModelFacet) {
            return this._getMetaClass((LinkModelFacet)some);
        }
        if (some instanceof GenCommonBase) {
            return this._getMetaClass((GenCommonBase)some);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(some).toString());
    }

    public GenClass getModelElementType(GenContainerBase compartment) {
        if (compartment instanceof GenCompartment) {
            return this._getModelElementType((GenCompartment)compartment);
        }
        if (compartment instanceof GenNode) {
            return this._getModelElementType((GenNode)compartment);
        }
        if (compartment instanceof GenDiagram) {
            return this._getModelElementType((GenDiagram)compartment);
        }
        if (compartment != null) {
            return this._getModelElementType(compartment);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(compartment).toString());
    }

    public Iterable<GenNode> getPhantomNodes(GenContainerBase it) {
        if (it instanceof GenNode) {
            return this._getPhantomNodes((GenNode)it);
        }
        if (it instanceof GenDiagram) {
            return this._getPhantomNodes((GenDiagram)it);
        }
        if (it != null) {
            return this._getPhantomNodes(it);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(it).toString());
    }

    public GenClass getLinkEndType(LinkModelFacet facet, UpdaterLinkType type) {
        if (facet instanceof FeatureLinkModelFacet) {
            return this._getLinkEndType((FeatureLinkModelFacet)facet, type);
        }
        if (facet instanceof TypeLinkModelFacet) {
            return this._getLinkEndType((TypeLinkModelFacet)facet, type);
        }
        if (facet != null) {
            return this._getLinkEndType(facet, type);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(new Object[]{facet, type}).toString());
    }
}

