/**
 * Copyright (c) 2006, 2009, 2013, 2021 Borland Software Corporation, CEA LIST, Artal and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 * Dmitry Stadnik (Borland) - initial API and implementation
 * Alexander Shatalin (Borland) - initial API and implementation
 * Michael Golubev (Montages) - #386838 - migrate to Xtend2
 * Aurelien Didier (ARTAL) - aurelien.didier51@gmail.com - Bug 569174
 * Etienne Allogo (ARTAL) - etienne.allogo@artal.fr - Bug 569174 : 1.4 Merge papyrus extension templates into codegen.xtend
 * Etienne Allogo (ARTAL) - etienne.allogo@artal.fr - L1.2 generate less dead or duplicate code + missing @override
 */
package diagram.editparts;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import impl.diagram.editparts.TextAware;
import impl.diagram.editparts.TextAwareExtent;
import java.util.Arrays;
import org.eclipse.papyrus.gmf.codegen.gmfgen.FigureViewmap;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenChildLabelNode;
import org.eclipse.papyrus.gmf.codegen.gmfgen.Viewmap;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;
import xpt.CodeStyle;
import xpt.Common;

@Singleton
@SuppressWarnings("all")
public class ChildNodeLabelEditPart {
  @Inject
  @Extension
  private Common _common;

  @Inject
  @Extension
  private CodeStyle _codeStyle;

  @Inject
  private impl.diagram.editparts.ChildNodeLabelEditPart xptChildNodeLabelEditPart;

  @Inject
  private xpt.diagram.editparts.Common xptEditpartsCommon;

  @Inject
  private TextAware xptTextAware;

  @Inject
  private TextAwareExtent xptTextAwareExtent;

  public CharSequence className(final GenChildLabelNode it) {
    StringConcatenation _builder = new StringConcatenation();
    String _editPartClassName = it.getEditPartClassName();
    _builder.append(_editPartClassName);
    return _builder;
  }

  public CharSequence packageName(final GenChildLabelNode it) {
    StringConcatenation _builder = new StringConcatenation();
    String _editPartsPackageName = it.getDiagram().getEditPartsPackageName();
    _builder.append(_editPartsPackageName);
    return _builder;
  }

  public CharSequence qualifiedClassName(final GenChildLabelNode it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _packageName = this.packageName(it);
    _builder.append(_packageName);
    _builder.append(".");
    CharSequence _className = this.className(it);
    _builder.append(_className);
    return _builder;
  }

  public CharSequence fullPath(final GenChildLabelNode it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _qualifiedClassName = this.qualifiedClassName(it);
    _builder.append(_qualifiedClassName);
    return _builder;
  }

  public CharSequence Main(final GenChildLabelNode it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _copyright = this._common.copyright(it.getDiagram().getEditorGen());
    _builder.append(_copyright);
    _builder.newLineIfNotEmpty();
    _builder.append("package ");
    CharSequence _packageName = this.packageName(it);
    _builder.append(_packageName);
    _builder.append(";");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    CharSequence _generatedClassComment = this._common.generatedClassComment();
    _builder.append(_generatedClassComment);
    _builder.newLineIfNotEmpty();
    _builder.append("public class ");
    CharSequence _className = this.className(it);
    _builder.append(_className);
    _builder.append(" ");
    CharSequence _extendsList = this.extendsList(it);
    _builder.append(_extendsList);
    _builder.append(" ");
    CharSequence _implementsList = this.implementsList(it);
    _builder.append(_implementsList);
    _builder.append(" {");
    _builder.newLineIfNotEmpty();
    {
      boolean _isCommonUmlCompartment = this.isCommonUmlCompartment(it);
      if (_isCommonUmlCompartment) {
        _builder.append("\t");
        CharSequence _visualIDConstant = this.xptEditpartsCommon.visualIDConstant(it);
        _builder.append(_visualIDConstant, "\t");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("\t");
        CharSequence _constructor = this.xptChildNodeLabelEditPart.constructor(it);
        _builder.append(_constructor, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        CharSequence _createDefaultEditPolicies = this.createDefaultEditPolicies(it);
        _builder.append(_createDefaultEditPolicies, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        CharSequence _methodsExtent = this.xptTextAwareExtent.methodsExtent(it, false, it.isLabelReadOnly(), it.getLabelModelFacet(), it);
        _builder.append(_methodsExtent, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        CharSequence _createFigurePrim = this.createFigurePrim(it.getViewmap());
        _builder.append(_createFigurePrim, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        CharSequence _handleNotificationEventExtent = this.handleNotificationEventExtent(it);
        _builder.append(_handleNotificationEventExtent, "\t");
        _builder.newLineIfNotEmpty();
      } else {
        _builder.append("\t");
        CharSequence _attributes = this.attributes(it);
        _builder.append(_attributes, "\t");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("\t");
        CharSequence _constructor_1 = this.xptChildNodeLabelEditPart.constructor(it);
        _builder.append(_constructor_1, "\t");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("\t");
        CharSequence _dragTracker = this.getDragTracker(it);
        _builder.append(_dragTracker, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        CharSequence _createDefaultEditPolicies_1 = this.createDefaultEditPolicies(it);
        _builder.append(_createDefaultEditPolicies_1, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        CharSequence _methods = this.xptTextAware.methods(it, false, it.isLabelReadOnly(), it.isLabelElementIcon(), it.getViewmap(), it.getLabelModelFacet(), it, it.getDiagram());
        _builder.append(_methods, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        CharSequence _notationalListeners = this.xptEditpartsCommon.notationalListeners(it);
        _builder.append(_notationalListeners, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        CharSequence _handleNotificationEvent = this.handleNotificationEvent(it);
        _builder.append(_handleNotificationEvent, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        CharSequence _labelFigure = this.xptEditpartsCommon.labelFigure(it.getViewmap());
        _builder.append(_labelFigure, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        CharSequence _isSelectable = this.xptChildNodeLabelEditPart.isSelectable(it);
        _builder.append(_isSelectable, "\t");
        _builder.newLineIfNotEmpty();
      }
    }
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }

  public CharSequence extendsList(final GenChildLabelNode it) {
    CharSequence _xifexpression = null;
    boolean _isCommonUmlCompartment = this.isCommonUmlCompartment(it);
    if (_isCommonUmlCompartment) {
      StringConcatenation _builder = new StringConcatenation();
      _builder.append("extends org.eclipse.papyrus.uml.diagram.common.editparts.AbstractCompartmentEditPart");
      _xifexpression = _builder;
    } else {
      StringConcatenation _builder_1 = new StringConcatenation();
      _builder_1.append("extends ");
      String _superEditPart = it.getSuperEditPart();
      _builder_1.append(_superEditPart);
      _builder_1.append(" ");
      _xifexpression = _builder_1;
    }
    return _xifexpression;
  }

  public CharSequence implementsList(final GenChildLabelNode it) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("implements org.eclipse.gmf.runtime.diagram.ui.editparts.ITextAwareEditPart, org.eclipse.gmf.runtime.diagram.ui.editparts.IPrimaryEditPart, org.eclipse.papyrus.infra.gmfdiag.common.editpart.IControlParserForDirectEdit");
    return _builder;
  }

  public CharSequence attributes(final GenChildLabelNode it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _visualIDConstant = this.xptEditpartsCommon.visualIDConstant(it);
    _builder.append(_visualIDConstant);
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    CharSequence _fields = this.xptTextAware.fields(it);
    _builder.append(_fields);
    _builder.newLineIfNotEmpty();
    return _builder;
  }

  public CharSequence getDragTracker(final GenChildLabelNode it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    CharSequence _overrideC = this._codeStyle.overrideC(it);
    _builder.append(_overrideC);
    _builder.newLineIfNotEmpty();
    _builder.append("public org.eclipse.gef.DragTracker getDragTracker(org.eclipse.gef.Request request) {");
    _builder.newLine();
    _builder.append("\t");
    CharSequence _dragTrackerBody = this.xptChildNodeLabelEditPart.getDragTrackerBody(it);
    _builder.append(_dragTrackerBody, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }

  public CharSequence createDefaultEditPolicies(final GenChildLabelNode it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    CharSequence _overrideC = this._codeStyle.overrideC(it);
    _builder.append(_overrideC);
    _builder.newLineIfNotEmpty();
    _builder.append("protected void createDefaultEditPolicies() {");
    _builder.newLine();
    _builder.append("\t");
    CharSequence _createDefaultEditPoliciesBody = this.xptChildNodeLabelEditPart.createDefaultEditPoliciesBody(it);
    _builder.append(_createDefaultEditPoliciesBody, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }

  public CharSequence handleNotificationEvent(final GenChildLabelNode it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    CharSequence _overrideC = this._codeStyle.overrideC(it);
    _builder.append(_overrideC);
    _builder.newLineIfNotEmpty();
    _builder.append("protected void handleNotificationEvent(org.eclipse.emf.common.notify.Notification event) {");
    _builder.newLine();
    _builder.append("\t");
    CharSequence _handleNotificationEventBody = this.xptChildNodeLabelEditPart.handleNotificationEventBody(it);
    _builder.append(_handleNotificationEventBody, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }

  public CharSequence handleNotificationEventExtent(final GenChildLabelNode it) {
    StringConcatenation _builder = new StringConcatenation();
    {
      boolean _isLabelElementIcon = it.isLabelElementIcon();
      if (_isLabelElementIcon) {
        CharSequence _generatedMemberComment = this._common.generatedMemberComment();
        _builder.append(_generatedMemberComment);
        _builder.newLineIfNotEmpty();
        CharSequence _overrideC = this._codeStyle.overrideC(it);
        _builder.append(_overrideC);
        _builder.newLineIfNotEmpty();
        _builder.append("protected void handleNotificationEvent(org.eclipse.emf.common.notify.Notification event) {");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("if(event.getNewValue() instanceof org.eclipse.emf.ecore.EAnnotation && org.eclipse.papyrus.infra.emf.appearance.helper.VisualInformationPapyrusConstants.DISPLAY_NAMELABELICON.equals(((org.eclipse.emf.ecore.EAnnotation)event.getNewValue()).getSource())){");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("refreshLabel();");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("super.handleNotificationEvent(event);");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
      }
    }
    return _builder;
  }

  protected CharSequence _createFigurePrim(final Viewmap it) {
    StringConcatenation _builder = new StringConcatenation();
    return _builder;
  }

  protected CharSequence _createFigurePrim(final FigureViewmap it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    CharSequence _overrideC = this._codeStyle.overrideC(it);
    _builder.append(_overrideC);
    _builder.newLineIfNotEmpty();
    _builder.append("protected org.eclipse.draw2d.IFigure createFigurePrim() {");
    _builder.newLine();
    {
      String _figureQualifiedClassName = it.getFigureQualifiedClassName();
      boolean _tripleEquals = (_figureQualifiedClassName == null);
      if (_tripleEquals) {
        _builder.append("\t");
        _builder.append("return new org.eclipse.draw2d.Label();");
        _builder.newLine();
      } else {
        _builder.append("\t");
        _builder.append("return new ");
        String _figureQualifiedClassName_1 = it.getFigureQualifiedClassName();
        _builder.append(_figureQualifiedClassName_1, "\t");
        _builder.append("();");
        _builder.newLineIfNotEmpty();
      }
    }
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }

  public boolean isCommonUmlCompartment(final GenChildLabelNode it) {
    return (((it.getSuperEditPart() == null) || Objects.equal("org.eclipse.papyrus.uml.diagram.common.editparts.AbstractCompartmentEditPart", it.getSuperEditPart())) || Objects.equal("org.eclipse.papyrus.uml.diagram.common.editparts.UMLCompartmentEditPart", it.getSuperEditPart()));
  }

  public CharSequence createFigurePrim(final Viewmap it) {
    if (it instanceof FigureViewmap) {
      return _createFigurePrim((FigureViewmap)it);
    } else if (it != null) {
      return _createFigurePrim(it);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(it).toString());
    }
  }
}
