/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.profile.drafter.ui.handler;

import java.util.List;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.papyrus.uml.profile.drafter.ui.handler.AbstractProfileBaseHandler;
import org.eclipse.uml2.uml.AggregationKind;
import org.eclipse.uml2.uml.Association;
import org.eclipse.uml2.uml.Extension;
import org.eclipse.uml2.uml.ExtensionEnd;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.UMLFactory;

public class CheckSelectionHandler
extends AbstractProfileBaseHandler {
    private List<NamedElement> cachedSelectionAsNamedElement;

    @Override
    public String getCommandName() {
        return "Check Selection Type";
    }

    @Override
    protected void doExecute(ExecutionEvent event, IEvaluationContext context) {
        this.cachedSelectionAsNamedElement = null;
        System.err.println("Add Profile called. Selected elements:");
        List<NamedElement> selected = this.getSelectionAsNamedElements(context);
        for (NamedElement ele : selected) {
            try {
                System.err.println(ele.getName());
                System.err.println("applicable stereotypes:" + String.valueOf(ele.getApplicableStereotypes()));
                System.err.println("applied profiles:" + String.valueOf(ele.getNearestPackage().getAllAppliedProfiles()));
                System.err.println("profiles application:" + String.valueOf(ele.getNearestPackage().getAllProfileApplications()));
            }
            catch (Exception e) {
                System.err.println("error while printing data (" + e.getMessage() + ")");
            }
        }
        System.err.println("********************");
    }

    @Override
    protected void resetCachedValues() {
        super.resetCachedValues();
        this.cachedSelectionAsNamedElement = null;
    }

    protected List<NamedElement> getSelectionAsNamedElements(IEvaluationContext context) {
        if (this.cachedSelectionAsNamedElement == null) {
            this.cachedSelectionAsNamedElement = this.getSelectionsByType(context, NamedElement.class);
        }
        return this.cachedSelectionAsNamedElement;
    }

    protected Extension createExtension(Stereotype source, Type target) {
        Extension newExtension = UMLFactory.eINSTANCE.createExtension();
        ExtensionEnd endSource = UMLFactory.eINSTANCE.createExtensionEnd();
        endSource.setName("extension_" + source.getName());
        endSource.setType((Type)source);
        endSource.setAggregation(AggregationKind.COMPOSITE_LITERAL);
        newExtension.getOwnedEnds().add((Object)endSource);
        Property property = UMLFactory.eINSTANCE.createProperty();
        property.setName("base_" + target.getName());
        property.setType(target);
        property.setAssociation((Association)newExtension);
        property.setAggregation(AggregationKind.NONE_LITERAL);
        newExtension.getMemberEnds().add((Object)property);
        source.getOwnedAttributes().add((Object)property);
        return newExtension;
    }

    @Override
    public boolean isEnabled(IEvaluationContext context, List<Object> selections) {
        return !selections.isEmpty();
    }
}

