/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.services.edit.commands;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateElementRequest;

public class InsertAtCommand
extends AbstractTransactionalCommand {
    private final CreateElementRequest request;

    public InsertAtCommand(CreateElementRequest request, String label) {
        super(request.getEditingDomain(), label, null);
        this.request = request;
    }

    public InsertAtCommand(CreateElementRequest request) {
        this(request, "Insert element at " + InsertAtCommand.getIndex(request));
    }

    private static int getIndex(CreateElementRequest request) {
        Object indexParameter = request.getParameter("InsertAt");
        return indexParameter instanceof Integer ? (Integer)indexParameter : -1;
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        int currentIndex;
        EList children;
        Object childrenValue;
        int index = InsertAtCommand.getIndex(this.request);
        if (index < 0) {
            return CommandResult.newOKCommandResult();
        }
        EObject newElement = this.request.getNewElement();
        EObject container = this.request.getContainer();
        EReference containmentFeature = this.request.getContainmentFeature();
        if (newElement != null && containmentFeature != null && container != null && (childrenValue = container.eGet((EStructuralFeature)containmentFeature)) instanceof EList && index < (children = (EList)childrenValue).size() && (currentIndex = children.indexOf((Object)newElement)) >= 0) {
            children.move(index, currentIndex);
        }
        return CommandResult.newOKCommandResult();
    }
}

