/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.dev.project.management.handlers.features;

import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.papyrus.dev.project.management.Activator;
import org.eclipse.papyrus.dev.project.management.dialog.TwoInputDialog;
import org.eclipse.papyrus.dev.project.management.utils.Utils;
import org.eclipse.papyrus.eclipse.project.editors.project.FeatureProjectEditor;
import org.eclipse.swt.widgets.Display;

public class SetCopyrightNoticeHandler
extends AbstractHandler {
    static final String OPTIONAL_URL = "url";
    static final String TEXT = "text";

    public Object execute(ExecutionEvent event) throws ExecutionException {
        Utils.getSelectedOpenProject();
        TwoInputDialog dialog = new TwoInputDialog(Display.getDefault().getActiveShell(), "Set Copyright Notice", "Licence url", TEXT, OPTIONAL_URL, TEXT, null);
        if (dialog.open() == 0) {
            String newVersion = dialog.getValue();
            List<IProject> featureProjects = Utils.getOpenedFeatureProject();
            for (IProject current : featureProjects) {
                try {
                    this.setCopyrightNotice(current, dialog.getValue(), dialog.getValue_2());
                }
                catch (Throwable e) {
                    Activator.log.error(e);
                }
            }
        }
        return null;
    }

    protected void setCopyrightNotice(IProject featureProject, String url, String text) throws Throwable {
        FeatureProjectEditor editor = new FeatureProjectEditor(featureProject);
        editor.init();
        String copyrirghtText = editor.getCopyrightText();
        String copyrightURL = editor.getCopyrightURL();
        String settedURL = null;
        String settedText = null;
        settedURL = copyrightURL == null || copyrightURL.equals("") ? url : copyrightURL;
        if (copyrirghtText == null || copyrirghtText.equals("")) {
            settedText = text;
        }
        if (!settedText.equals(copyrirghtText) || !settedURL.equals(copyrightURL)) {
            editor.setCopyright(settedURL, settedText);
            editor.save();
        }
    }
}

