/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.export.utils;

import java.util.Collection;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.gmfdiag.export.utils.ExportUtils;
import org.eclipse.papyrus.infra.ui.util.ServiceUtilsForSelection;

public class SelectionHelper {
    private SelectionHelper() {
    }

    public static IFile convertSelection2File(ISelection selection) {
        IStructuredSelection structuredSelection;
        IFile foundFile = null;
        if (selection instanceof IStructuredSelection && !(structuredSelection = (IStructuredSelection)selection).isEmpty() && structuredSelection.size() == 1) {
            Object selectedObject = structuredSelection.getFirstElement();
            foundFile = SelectionHelper.getIFile(selectedObject);
        }
        return foundFile;
    }

    public static IFile getIFile(Object selectedObj) {
        Collection collec;
        IFile result = null;
        if (selectedObj instanceof IFile) {
            result = (IFile)selectedObj;
        }
        if (result == null && selectedObj instanceof IAdaptable) {
            result = (IFile)((IAdaptable)selectedObj).getAdapter(IFile.class);
        }
        if (result == null) {
            result = (IFile)Platform.getAdapterManager().getAdapter(selectedObj, IFile.class);
        }
        if (result == null && (collec = (Collection)Platform.getAdapterManager().getAdapter(selectedObj, Collection.class)) != null) {
            for (Object o : collec) {
                IFile f;
                if (!(o instanceof IFile) || !"di".equals((f = (IFile)o).getFileExtension())) continue;
                result = f;
                break;
            }
        }
        return result != null && "di".equals(result.getFileExtension()) ? result : null;
    }

    public static boolean isExportableModel(IStructuredSelection receiver) {
        boolean result = false;
        try {
            ModelSet modelSet = ServiceUtilsForSelection.getInstance().getModelSet((Object)receiver);
            result = modelSet != null && ExportUtils.hasExportableDiagrams(modelSet);
        }
        catch (ServiceException serviceException) {
            // empty catch block
        }
        return result;
    }
}

