/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.toolsmiths.profilemigration.internal.migrators.atomic.packages;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.tree.TreeNode;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.papyrus.toolsmiths.profilemigration.MigratorProfileApplication;
import org.eclipse.papyrus.toolsmiths.profilemigration.internal.data.structure.StereotypeApplicationDescriptor;
import org.eclipse.papyrus.toolsmiths.profilemigration.internal.data.structure.StereotypeApplicationRegistry;
import org.eclipse.papyrus.toolsmiths.profilemigration.internal.utils.ProfileUtil;
import org.eclipse.papyrus.toolsmiths.profilemigration.internal.utils.TreeNodeUtils;
import org.eclipse.papyrus.toolsmiths.profilemigration.migrators.atomic.AbstractMigrator;
import org.eclipse.papyrus.toolsmiths.profilemigration.migrators.atomic.packages.IMovePackageMigrator;
import org.eclipse.papyrus.toolsmiths.profilemigration.ui.Activator;
import org.eclipse.papyrus.toolsmiths.profilemigration.ui.dialogs.MovePackageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Profile;
import org.eclipse.uml2.uml.Stereotype;

public class MovePackageMigrator
extends AbstractMigrator
implements IMovePackageMigrator {
    Package movedPackage;
    EObject newContainer;

    public MovePackageMigrator(TreeNode treeNode) {
        super(treeNode);
    }

    public static boolean isValid(TreeNode treeNode) {
        if (TreeNodeUtils.isMoveChange(treeNode)) {
            Object element = TreeNodeUtils.getMovedElement(treeNode);
            EObject oldContainer = TreeNodeUtils.getMovedSourceContainer(treeNode, MigratorProfileApplication.comparison);
            if (element instanceof Package && !(element instanceof Profile) && oldContainer != ((Package)element).getOwner() && oldContainer == MigratorProfileApplication.appliedProfile) {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isValid() {
        return MovePackageMigrator.isValid(this.treeNode);
    }

    @Override
    public void migrationAction() {
        Profile nearestProfile;
        Profile profile;
        if (this.isDisplayDialogPreference() && this.newContainer instanceof Package && (profile = this.getAppliedProfile(nearestProfile = ProfileUtil.getNearestProfile((Element)((Package)this.newContainer)))) == null) {
            MovePackageDialog dialog = new MovePackageDialog(Display.getDefault().getActiveShell(), this.movedPackage, nearestProfile);
            dialog.open();
            if (dialog.isReapply()) {
                MigratorProfileApplication.profiledModel.applyProfile(nearestProfile);
                MigratorProfileApplication.newAppliedProfile.add(nearestProfile);
            } else {
                ArrayList<Stereotype> ownedStereotype = new ArrayList<Stereotype>();
                ProfileUtil.findAllStereotypes(this.movedPackage, ownedStereotype);
                for (Stereotype stereotype : ownedStereotype) {
                    List<StereotypeApplicationDescriptor> list = StereotypeApplicationRegistry.getStereotypeApplicationDescriptors(stereotype);
                    for (StereotypeApplicationDescriptor descriptor : list) {
                        descriptor.getOwner().unapplyStereotype(descriptor.getStereotype());
                    }
                    StereotypeApplicationRegistry.stereotypeApplicationList.removeAll(list);
                }
            }
        }
    }

    private Profile getAppliedProfile(Profile profile) {
        Profile appliedProfile = MigratorProfileApplication.profiledModel.getAppliedProfile(profile.getQualifiedName(), true);
        if (appliedProfile == null && profile.getOwner() != null && profile.getOwner() instanceof Package) {
            return this.getAppliedProfile((Profile)profile.getOwner());
        }
        return appliedProfile;
    }

    @Override
    public void initAttributes() {
        if (this.isValid()) {
            this.movedPackage = (Package)TreeNodeUtils.getMovedElement(this.treeNode);
            this.newContainer = TreeNodeUtils.getMovedTargetContainer(this.treeNode);
        }
    }

    @Override
    public int getPriority() {
        return 0;
    }

    private boolean isDisplayDialogPreference() {
        IPreferenceStore prefStore = Activator.getDefault().getPreferenceStore();
        return prefStore.getBoolean("PackageMove");
    }

    @Override
    public Package getMovedPackage() {
        return this.movedPackage;
    }

    @Override
    public EObject getNewContainer() {
        return this.newContainer;
    }

    @Override
    public Element getTargetContainer() {
        return (Element)this.getNewContainer();
    }

    @Override
    public Element getSourceContainer() {
        return (Element)TreeNodeUtils.getMovedSourceContainer(this.treeNode, MigratorProfileApplication.comparison);
    }

    @Override
    public Element getMovedElement() {
        return this.getMovedPackage();
    }
}

