/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.dev.project.management.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.papyrus.dev.project.management.Activator;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.WorkingSet;

public class Utils {
    public static final String FEATURE_NATURE = "org.eclipse.pde.FeatureNature";
    public static final String PLUGIN_NATURE = "org.eclipse.pde.PluginNature";

    private Utils() {
    }

    public static List<IProject> getOpenedFeatureProject() {
        IProject[] projects;
        ArrayList<IProject> featureProject = new ArrayList<IProject>();
        IProject[] iProjectArray = projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject current = iProjectArray[n2];
            try {
                if (current.isOpen() && current.hasNature(FEATURE_NATURE)) {
                    featureProject.add(current);
                }
            }
            catch (CoreException e) {
                Activator.log.error((Throwable)e);
            }
            ++n2;
        }
        return featureProject;
    }

    public static Collection<IProject> getSelectedOpenProject() {
        HashSet<IProject> selectedProject = new HashSet<IProject>();
        ISelection selection = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getSelectionService().getSelection();
        Assert.isTrue((boolean)(selection instanceof IStructuredSelection));
        for (Object current : (IStructuredSelection)selection) {
            if (current instanceof IProject && ((IProject)current).isOpen()) {
                selectedProject.add((IProject)current);
                continue;
            }
            if (!(current instanceof WorkingSet)) continue;
            IAdaptable[] iAdaptableArray = ((WorkingSet)current).getElements();
            int n = iAdaptableArray.length;
            int n2 = 0;
            while (n2 < n) {
                IAdaptable curr = iAdaptableArray[n2];
                if (curr instanceof IProject && ((IProject)curr).isOpen()) {
                    selectedProject.add((IProject)curr);
                }
                ++n2;
            }
        }
        return selectedProject;
    }
}

