/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.tools.util;

import java.util.concurrent.Callable;
import org.eclipse.core.runtime.IProgressMonitor;

@FunctionalInterface
public interface IProgressCallable<V> {
    public V call(IProgressMonitor var1) throws Exception;

    public static <V> IProgressCallable<V> convert(String label, Callable<V> callable) {
        return progress -> {
            if (progress != null) {
                progress.beginTask(label, -1);
            }
            try {
                Object v = callable.call();
                return v;
            }
            finally {
                if (progress != null) {
                    progress.done();
                }
            }
        };
    }
}

