/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.css.dom;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gmf.runtime.notation.BasicCompartment;
import org.eclipse.gmf.runtime.notation.DecorationNode;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.gmfdiag.css.dom.GMFElementAdapter;
import org.eclipse.papyrus.infra.gmfdiag.css.engine.ExtendedCSSEngine;
import org.eclipse.papyrus.infra.tools.util.ListHelper;
import org.eclipse.papyrus.uml.diagram.common.stereotype.display.helper.StereotypeDisplayUtil;
import org.eclipse.papyrus.uml.diagram.css.helper.CSSDOMUMLSemanticElementHelper;
import org.eclipse.papyrus.uml.service.types.utils.ConnectorUtils;
import org.eclipse.uml2.uml.AcceptEventAction;
import org.eclipse.uml2.uml.ConnectableElement;
import org.eclipse.uml2.uml.Connector;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Event;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.TimeEvent;
import org.eclipse.uml2.uml.Trigger;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.TypedElement;

public class GMFUMLElementAdapter
extends GMFElementAdapter {
    private static final String STEREOTYPE_REFERENCE_EDGE_SOURCE_APPLIED_STEREOTYPES_PROPERTY = "sourceAppliedStereotypes";
    private static final String CONNECTOR_END_TYPE_PROPERTY = "connectorEndType";
    private static final String STEREOTYPE_COMMENT = "StereotypeComment";
    public final StereotypeDisplayUtil stereotypeHelper = StereotypeDisplayUtil.getInstance();
    private static final String IS_TIME_EVENT_ACTION_PROPERTY = "isTimeEventAction";
    public static final String APPLIED_STEREOTYPES_PROPERTY = "appliedStereotypes";
    public static final String IS_FRAME = "isFrame";
    private static final String TYPE_APPLIED_STEREOTYPES_PROPERTY = "typeAppliedStereotypes";
    private static final String COMMENT_ANNOTATED_ELEMENT_EDGE_TYPE = "Comment_AnnotatedElementEdge";
    private static final String COMMENT_LINK = "CommentLink";
    private static final String CONSTRAINT_CONSTRAINED_ELEMENT_EDGE_TYPE = "Constraint_ConstrainedElementEdge";
    private static final String CONSTRAINT_LINK = "ConstraintLink";
    private static final String CONSTRAINT_CONTEXT_EDGE_TYPE = "Constraint_ContextEdge";
    private static final String CONTEXT_LINK = "ContextLink";
    private static final String STEREOTYPE_REFERENCE_LINK = "StereotypePropertyReferenceLink";
    private static final String STEREOTYPE_COMMENT_LINK = "StereotypeCommentLink";
    public static final String QUALIFIER_SEPARATOR = "--";

    public GMFUMLElementAdapter(View view, ExtendedCSSEngine engine) {
        super(view, engine);
        this.helper = CSSDOMUMLSemanticElementHelper.getInstance();
    }

    protected String doGetAttribute(String attr) {
        EAnnotation eAnnotation;
        String value;
        String parentValue = super.doGetAttribute(attr);
        if (parentValue != null) {
            return parentValue;
        }
        if (this.stereotypeHelper.isStereotypeLabel((Object)this.semanticElement) && (value = this.getStereotypeLabelAttribute(attr)) != null && !value.isEmpty()) {
            return value;
        }
        if ((this.stereotypeHelper.isStereotypeCompartment((Object)this.semanticElement) || this.stereotypeHelper.isStereotypeBrace((Object)this.semanticElement)) && (value = this.getStereotypeCompartmentAttribute(attr)) != null && !value.isEmpty()) {
            return value;
        }
        if ((this.stereotypeHelper.isStereotypeProperty((Object)this.semanticElement) || this.stereotypeHelper.isStereotypeBraceProperty((Object)this.semanticElement)) && (value = this.getStereotypePropertyAttribute(attr)) != null && !value.isEmpty()) {
            return value;
        }
        if (this.semanticElement instanceof Element) {
            EList ends;
            Element currentElement = (Element)this.semanticElement;
            if (APPLIED_STEREOTYPES_PROPERTY.equals(attr)) {
                EList appliedStereotypes = currentElement.getAppliedStereotypes();
                if (!appliedStereotypes.isEmpty()) {
                    ArrayList<String> appliedStereotypeNames = new ArrayList<String>(appliedStereotypes.size() * 2);
                    for (Stereotype stereotype : appliedStereotypes) {
                        appliedStereotypeNames.add(stereotype.getName());
                        appliedStereotypeNames.add(stereotype.getQualifiedName());
                    }
                    return ListHelper.deepToString(appliedStereotypeNames, (String)" ");
                }
                return "";
            }
            if (TYPE_APPLIED_STEREOTYPES_PROPERTY.equals(attr) && this.semanticElement instanceof TypedElement) {
                EList appliedStereotypes;
                Type type = ((TypedElement)this.semanticElement).getType();
                if (type != null && !(appliedStereotypes = type.getAppliedStereotypes()).isEmpty()) {
                    ArrayList<String> appliedStereotypeNames = new ArrayList<String>(appliedStereotypes.size() * 2);
                    for (Stereotype stereotype : appliedStereotypes) {
                        appliedStereotypeNames.add(stereotype.getName());
                        appliedStereotypeNames.add(stereotype.getQualifiedName());
                    }
                    return ListHelper.deepToString(appliedStereotypeNames, (String)" ");
                }
                return "";
            }
            for (EObject stereotypeApplication : currentElement.getStereotypeApplications()) {
                EStructuralFeature feature = stereotypeApplication.eClass().getEStructuralFeature(attr);
                if (feature == null) continue;
                if (feature.isMany()) {
                    List values = (List)stereotypeApplication.eGet(feature);
                    if (!values.isEmpty()) {
                        ArrayList<String> cssValues = new ArrayList<String>(values.size());
                        for (Object value2 : values) {
                            cssValues.add(this.getCSSValue(feature, value2));
                        }
                        return ListHelper.deepToString(cssValues, (String)" ");
                    }
                    return "";
                }
                Object value3 = stereotypeApplication.eGet(feature);
                String cssValue = this.getCSSValue(feature, value3);
                return cssValue;
            }
            if (attr.contains(QUALIFIER_SEPARATOR)) {
                EObject stereotypeApplication;
                EStructuralFeature feature;
                List qualifiers = ListHelper.asList((Object[])attr.split(QUALIFIER_SEPARATOR));
                String propertyName = (String)qualifiers.remove(qualifiers.size() - 1);
                String stereotypeName = ListHelper.deepToString((List)qualifiers, (String)"::");
                Stereotype appliedStereotype = currentElement.getAppliedStereotype(stereotypeName);
                if (appliedStereotype != null && (feature = (stereotypeApplication = currentElement.getStereotypeApplication(appliedStereotype)).eClass().getEStructuralFeature(propertyName)) != null) {
                    Object value4 = stereotypeApplication.eGet(feature);
                    return this.getCSSValue(feature, value4);
                }
            }
            if (IS_TIME_EVENT_ACTION_PROPERTY.equals(attr) && this.semanticElement instanceof AcceptEventAction) {
                return String.valueOf(GMFUMLElementAdapter.isAcceptTimeEventAction((AcceptEventAction)this.semanticElement));
            }
            if (IS_FRAME.equals(attr)) {
                if (this.notationElement.eContainer() == this.notationElement.getDiagram()) {
                    return String.valueOf(true);
                }
                return String.valueOf(false);
            }
            if (CONNECTOR_END_TYPE_PROPERTY.equals(attr) && this.semanticElement instanceof Connector && (ends = ((Connector)this.semanticElement).getEnds()) != null && !ends.isEmpty()) {
                ConnectableElement source = new ConnectorUtils().getSourceConnectorEnd((Connector)this.semanticElement).getRole();
                ConnectableElement target = new ConnectorUtils().getTargetConnectorEnd((Connector)this.semanticElement).getRole();
                if (source.getType() != null && target.getType() != null && source.getType().equals(target.getType())) {
                    return source.getType().getName();
                }
            }
        }
        if (STEREOTYPE_REFERENCE_EDGE_SOURCE_APPLIED_STEREOTYPES_PROPERTY.equals(attr) && this.notationElement != null && "StereotypePropertyReferenceEdge".equals(this.notationElement.getType()) && (eAnnotation = this.notationElement.getEAnnotation("StereotypePropertyReferenceEdge")) != null) {
            return (String)eAnnotation.getDetails().get((Object)"stereotypeQualifiedName");
        }
        if ("featureToSet".equals(attr) && this.notationElement != null && "StereotypePropertyReferenceEdge".equals(this.notationElement.getType()) && (eAnnotation = this.notationElement.getEAnnotation("StereotypePropertyReferenceEdge")) != null) {
            return (String)eAnnotation.getDetails().get((Object)"featureToSet");
        }
        return null;
    }

    public static boolean isAcceptTimeEventAction(AcceptEventAction action) {
        boolean hasTimeEvent = false;
        boolean hasOthersTriggers = false;
        if (action.getTriggers() != null) {
            for (Trigger trigger : action.getTriggers()) {
                if (trigger == null) continue;
                Event event = trigger.getEvent();
                if (event instanceof TimeEvent) {
                    hasTimeEvent = true;
                    continue;
                }
                hasOthersTriggers = true;
            }
        }
        return hasTimeEvent && !hasOthersTriggers;
    }

    protected String getStereotypeCompartmentAttribute(String attr) {
        if ("stereotype".equals(attr)) {
            BasicCompartment propertyCompartment = (BasicCompartment)this.semanticElement;
            return this.stereotypeHelper.getName(propertyCompartment);
        }
        return "";
    }

    protected String getStereotypePropertyAttribute(String attr) {
        EObject propertyCompartment;
        if ("property".equals(attr)) {
            DecorationNode propertyLabel = (DecorationNode)this.semanticElement;
            if (propertyLabel.getElement() instanceof Property) {
                Property prop = (Property)propertyLabel.getElement();
                String propLabel = prop.getName();
                return propLabel;
            }
        } else if ("stereotype".equals(attr) && this.stereotypeHelper.isStereotypeCompartment((Object)(propertyCompartment = ((DecorationNode)this.semanticElement).eContainer()))) {
            return this.stereotypeHelper.getName((DecorationNode)propertyCompartment);
        }
        return "";
    }

    protected String getStereotypeLabelAttribute(String attr) {
        if ("stereotype".equals(attr)) {
            DecorationNode label = (DecorationNode)this.semanticElement;
            String stereoName = this.stereotypeHelper.getName(label);
            return stereoName;
        }
        if ("kind".equals(attr) && this.stereotypeHelper.isStereotypeLabel((Object)this.semanticElement)) {
            return "StereotypeLabel";
        }
        return null;
    }

    protected String getCSSValue(EStructuralFeature feature, Object value) {
        if (feature instanceof EReference && value instanceof NamedElement) {
            String name = ((NamedElement)value).getName();
            return name == null || name.isEmpty() ? " " : name;
        }
        return super.getCSSValue(feature, value);
    }

    public String getLocalName() {
        block19: {
            block20: {
                if (this.localName != null) break block19;
                if (!this.stereotypeHelper.isStereotypeComment((Object)this.getNotationElement())) break block20;
                this.localName = STEREOTYPE_COMMENT;
                break block19;
            }
            if (!(this.getSemanticElement() instanceof Edge)) break block19;
            switch (((Edge)this.getSemanticElement()).getType()) {
                case "Comment_AnnotatedElementEdge": {
                    this.localName = COMMENT_LINK;
                    break;
                }
                case "Constraint_ConstrainedElementEdge": {
                    this.localName = CONSTRAINT_LINK;
                    break;
                }
                case "Constraint_ContextEdge": {
                    this.localName = CONTEXT_LINK;
                    break;
                }
                case "StereotypePropertyReferenceEdge": {
                    this.localName = STEREOTYPE_REFERENCE_LINK;
                    break;
                }
                case "StereotypeCommentLink": {
                    this.localName = STEREOTYPE_COMMENT_LINK;
                }
            }
        }
        return this.localName == null ? super.getLocalName() : this.localName;
    }
}

