/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.wizards.wizards;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.papyrus.uml.diagram.wizards.Activator;
import org.eclipse.papyrus.uml.diagram.wizards.messages.Messages;
import org.eclipse.papyrus.uml.diagram.wizards.pages.PapyrusProjectCreationPage;
import org.eclipse.papyrus.uml.diagram.wizards.pages.SelectArchitectureContextPage;
import org.eclipse.papyrus.uml.diagram.wizards.wizards.CreateModelWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.WizardNewProjectCreationPage;

public class NewPapyrusProjectWizard
extends CreateModelWizard {
    public static final String WIZARD_ID = "org.eclipse.papyrus.uml.diagram.wizards.createproject";
    private PapyrusProjectCreationPage myProjectPage;

    @Override
    public boolean isCreateProjectWizard() {
        return true;
    }

    @Override
    public void init(IWorkbench workbench, IStructuredSelection selection) {
        super.init(workbench, selection);
        this.setWindowTitle(Messages.NewPapyrusProjectWizard_new_papyrus_project);
        this.setMyProjectPage(new PapyrusProjectCreationPage(Messages.NewPapyrusProjectWizard_0));
        this.getMyProjectPage().setDescription(Messages.NewPapyrusProjectWizard_1);
        this.setDefaultPageImageDescriptor(Activator.imageDescriptorFromPlugin((String)"org.eclipse.papyrus.uml.diagram.wizards", (String)"icons/papyrus/PapyrusProjectWizban_75x66.gif"));
    }

    @Override
    public void addPages() {
        this.setNewProjectPage(this.getMyProjectPage());
        if (this.getSelectedContexts() == null) {
            this.selectArchitectureContextPage = new SelectArchitectureContextPage();
        }
        super.addPages();
    }

    @Override
    public boolean performFinish() {
        IProject newProjectHandle;
        try {
            newProjectHandle = this.createNewProject();
        }
        catch (CoreException e) {
            Activator.log.error(Messages.NewPapyrusProjectWizard_exception_on_opening, (Throwable)e);
            return false;
        }
        if (newProjectHandle == null) {
            return false;
        }
        return super.performFinish();
    }

    protected IProject createNewProject() throws CoreException {
        IProject project = this.getMyProjectPage().getProjectHandle();
        java.net.URI projectLocationURI = null;
        if (!this.getMyProjectPage().useDefaults()) {
            projectLocationURI = this.getMyProjectPage().getLocationURI();
        }
        IProjectDescription projectDescription = null;
        NullProgressMonitor progressMonitor = new NullProgressMonitor();
        if (!project.exists()) {
            projectDescription = ResourcesPlugin.getWorkspace().newProjectDescription(project.getName());
            if (projectLocationURI != null) {
                projectDescription.setLocationURI(projectLocationURI);
            }
            project.create(projectDescription, (IProgressMonitor)SubMonitor.convert((IProgressMonitor)progressMonitor, (int)1));
            project.open((IProgressMonitor)SubMonitor.convert((IProgressMonitor)progressMonitor, (int)1));
        } else {
            project.open((IProgressMonitor)SubMonitor.convert((IProgressMonitor)progressMonitor, (int)1));
        }
        IWorkingSet[] workingSets = this.getMyProjectPage().getSelectedWorkingSets();
        if (workingSets.length > 0) {
            PlatformUI.getWorkbench().getWorkingSetManager().addToWorkingSets((IAdaptable)project, workingSets);
        }
        return project;
    }

    @Override
    protected URI createNewModelURI(String categoryId) {
        IPath newFilePath = this.getMyProjectPage().getProjectHandle().getFullPath().append(this.getMyProjectPage().getFileName() + "." + this.getDiagramFileExtension(categoryId));
        return URI.createPlatformResourceURI((String)newFilePath.toString(), (boolean)true);
    }

    public PapyrusProjectCreationPage getMyProjectPage() {
        return this.myProjectPage;
    }

    public void setMyProjectPage(PapyrusProjectCreationPage myProjectPage) {
        this.myProjectPage = myProjectPage;
    }

    protected WizardNewProjectCreationPage createNewProjectCreationPage() {
        return this.myProjectPage;
    }
}

